/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.gwt.generator.widgetprocessor.binding.simple;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.PrintWriter;
import org.metawidget.gwt.client.widgetprocessor.binding.simple.SimpleBindingProcessorAdapter;
import org.metawidget.util.simple.StringUtils;

public class SimpleBindingProcessorAdapterGenerator
extends Generator {
    private static final String VARIABLE_NAME_PREFIX = "the";
    private static final int WRITE_GETTER = 0;
    private static final int WRITE_TYPE_GETTER = 1;
    private static final int WRITE_SETTER = 2;
    private static final int WRITE_ACTION = 3;
    private static final int MAXIMUM_DEPTH = 10;
    private TypeOracle mTypeOracle;

    public String generate(TreeLogger treeLogger, GeneratorContext generatorContext, String string) {
        JClassType jClassType;
        this.mTypeOracle = generatorContext.getTypeOracle();
        try {
            jClassType = this.mTypeOracle.getType(string);
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException);
        }
        String string2 = jClassType.getPackage().getName();
        String string3 = jClassType.getSimpleSourceName();
        String string4 = string3 + "BindingAdapter";
        PrintWriter printWriter = generatorContext.tryCreate(treeLogger, string2, string4);
        String string5 = string2 + '.' + string4;
        if (printWriter == null) {
            return string5;
        }
        ClassSourceFileComposerFactory classSourceFileComposerFactory = new ClassSourceFileComposerFactory(string2, string4);
        classSourceFileComposerFactory.addImplementedInterface(SimpleBindingProcessorAdapter.class.getName() + "<" + jClassType.getQualifiedSourceName() + ">");
        SourceWriter sourceWriter = classSourceFileComposerFactory.createSourceWriter(generatorContext, printWriter);
        if (sourceWriter != null) {
            String string6 = VARIABLE_NAME_PREFIX + string3;
            sourceWriter.println();
            sourceWriter.println("// Public methods");
            sourceWriter.println();
            sourceWriter.println("public Object getProperty( " + jClassType.getQualifiedSourceName() + " " + string6 + ", String... names ) {");
            sourceWriter.indent();
            this.writeMethod(sourceWriter, jClassType, string6, 0);
            sourceWriter.outdent();
            sourceWriter.println("}");
            sourceWriter.println();
            sourceWriter.println("public Class<?> getPropertyType( " + jClassType.getQualifiedSourceName() + " " + string6 + ", String... names ) {");
            sourceWriter.indent();
            this.writeMethod(sourceWriter, jClassType, string6, 1);
            sourceWriter.outdent();
            sourceWriter.println("}");
            sourceWriter.println();
            sourceWriter.println("public void setProperty( " + jClassType.getQualifiedSourceName() + " " + string6 + ", Object value, String... names ) {");
            sourceWriter.indent();
            this.writeMethod(sourceWriter, jClassType, string6, 2);
            sourceWriter.outdent();
            sourceWriter.println("}");
            sourceWriter.println();
            sourceWriter.println("public void invokeAction( " + jClassType.getQualifiedSourceName() + " " + string6 + ", String... names ) {");
            sourceWriter.indent();
            this.writeMethod(sourceWriter, jClassType, string6, 3);
            sourceWriter.outdent();
            sourceWriter.println("}");
            sourceWriter.commit(treeLogger);
        }
        return string5;
    }

    private void writeMethod(SourceWriter sourceWriter, JClassType jClassType, String string, int n) {
        sourceWriter.println();
        sourceWriter.println("// Sanity check");
        sourceWriter.println();
        sourceWriter.println("if ( names == null || names.length == 0 ) throw new RuntimeException( \"No names specified\" );");
        this.writeSubtypes(sourceWriter, jClassType, string, 0, n, 0);
    }

    private void writeSubtypes(SourceWriter sourceWriter, JClassType jClassType, String string, int n, int n2, int n3) {
        if (n3 > 10) {
            return;
        }
        JClassType jClassType2 = jClassType.getSubtypes();
        int n4 = ((JClassType[])jClassType2).length;
        for (int i = 0; i < n4; ++i) {
            JClassType jClassType3 = jClassType2[i];
            this.writeProperties(sourceWriter, jClassType3, string, n, true, jClassType, n2, n3);
        }
        for (jClassType2 = jClassType; jClassType2 != null; jClassType2 = jClassType2.getSuperclass()) {
            this.writeProperties(sourceWriter, jClassType2, string, n, false, jClassType, n2, n3);
        }
        sourceWriter.println();
        sourceWriter.println("// Unknown");
        sourceWriter.println();
        sourceWriter.println("throw new RuntimeException( \"Unknown property '\" + names[" + n + "] + \"' of " + jClassType.getParameterizedQualifiedSourceName() + "\" );");
    }

    private void writeProperties(SourceWriter sourceWriter, JClassType jClassType, String string, int n, boolean bl, JClassType jClassType2, int n2, int n3) {
        String string2 = string;
        boolean bl2 = false;
        for (JMethod jMethod : jClassType.getMethods()) {
            String string3;
            String string4;
            if (!jMethod.isPublic()) continue;
            String string5 = jMethod.getName();
            JType jType = jMethod.getReturnType();
            if (JPrimitiveType.VOID.equals((Object)jType)) {
                if (n2 != 3 || jMethod.getParameters().length != 0) continue;
                sourceWriter.println("if ( \"" + string5 + "\".equals( names[" + n + "] )) { " + string2 + '.' + string5 + "(); return; }");
                continue;
            }
            if (string5.startsWith("get")) {
                string4 = string5.substring("get".length());
            } else {
                if (!string5.startsWith("is") || !"boolean".equals(jMethod.getReturnType().getQualifiedSourceName())) continue;
                string4 = string5.substring("is".length());
            }
            String string6 = StringUtils.decapitalize(string4);
            if (!bl2) {
                sourceWriter.println();
                sourceWriter.println("// " + jClassType.getSimpleSourceName() + " properties");
                sourceWriter.println();
                if (bl) {
                    sourceWriter.println("if ( " + string2 + " instanceof " + jClassType.getName() + " ) {");
                    sourceWriter.indent();
                    String string7 = string2;
                    string2 = VARIABLE_NAME_PREFIX + jClassType.getSimpleSourceName();
                    sourceWriter.println(jClassType.getParameterizedQualifiedSourceName() + " " + string2 + " = (" + jClassType.getParameterizedQualifiedSourceName() + ") " + string7 + ";");
                }
                bl2 = true;
            }
            sourceWriter.println("if ( \"" + string6 + "\".equals( names[" + n + "] )) {");
            sourceWriter.indent();
            int n4 = n + 1;
            JClassType jClassType3 = jType.isClass();
            if (jClassType3 != null && jClassType3.getPackage().getName().startsWith(jClassType2.getPackage().getName())) {
                string3 = VARIABLE_NAME_PREFIX + string4;
                if (n3 > 0) {
                    string3 = string3 + (n3 + 1);
                }
                sourceWriter.println(jClassType3.getParameterizedQualifiedSourceName() + " " + string3 + " = " + string2 + '.' + string5 + "();");
                switch (n2) {
                    case 0: {
                        sourceWriter.println("if ( names.length == " + n4 + " ) return " + string3 + ";");
                        break;
                    }
                    case 1: {
                        sourceWriter.println("if ( names.length == " + n4 + " ) return " + this.getWrapperType(jType).getQualifiedSourceName() + ".class;");
                        break;
                    }
                    case 2: {
                        try {
                            String string8 = "set" + string4;
                            jClassType.getMethod(string8, new JType[]{jType});
                            sourceWriter.println("if ( names.length == " + n4 + " ) { " + string2 + '.' + string8 + "( (" + this.getWrapperType(jType).getParameterizedQualifiedSourceName() + ") value ); return; }");
                            break;
                        }
                        catch (NotFoundException notFoundException) {
                            sourceWriter.println("if ( names.length == " + n4 + " ) throw new RuntimeException( \"No setter for name '" + string6 + "'\" );");
                        }
                    }
                }
                this.writeSubtypes(sourceWriter, jClassType3, string3, n4, n2, n3 + 1);
                sourceWriter.outdent();
                sourceWriter.println("}");
                continue;
            }
            sourceWriter.println("if ( names.length > " + n4 + " ) throw new RuntimeException( \"Cannot traverse into property '" + string6 + ".\" + names[" + n4 + "] + \"'\" );");
            switch (n2) {
                case 0: {
                    sourceWriter.println("return " + string2 + '.' + string5 + "();");
                    break;
                }
                case 1: {
                    sourceWriter.println("return " + this.getWrapperType(jType).getQualifiedSourceName() + ".class;");
                    break;
                }
                case 2: {
                    try {
                        string3 = "set" + string4;
                        jClassType.getMethod(string3, new JType[]{jType});
                        sourceWriter.println(string2 + '.' + string3 + "( (" + this.getWrapperType(jType).getParameterizedQualifiedSourceName() + ") value );");
                        sourceWriter.println("return;");
                    }
                    catch (NotFoundException notFoundException) {
                        sourceWriter.println("throw new RuntimeException( \"No setter for property '" + string6 + "'\" );");
                    }
                    break;
                }
                case 3: {
                    sourceWriter.println("if ( names.length == " + n4 + " ) throw new RuntimeException( \"Cannot execute '" + string6 + "' - is a property, not an action\" );");
                }
            }
            sourceWriter.outdent();
            sourceWriter.println("}");
        }
        if (bl2 && bl) {
            sourceWriter.outdent();
            sourceWriter.println("}");
        }
    }

    private JType getWrapperType(JType jType) {
        JPrimitiveType jPrimitiveType = jType.isPrimitive();
        if (jPrimitiveType == null) {
            return jType;
        }
        if (jPrimitiveType.equals((Object)JPrimitiveType.BOOLEAN)) {
            return this.mTypeOracle.findType(Boolean.class.getName());
        }
        if (jPrimitiveType.equals((Object)JPrimitiveType.BYTE)) {
            return this.mTypeOracle.findType(Byte.class.getName());
        }
        if (jPrimitiveType.equals((Object)JPrimitiveType.CHAR)) {
            return this.mTypeOracle.findType(Character.class.getName());
        }
        if (jPrimitiveType.equals((Object)JPrimitiveType.DOUBLE)) {
            return this.mTypeOracle.findType(Double.class.getName());
        }
        if (jPrimitiveType.equals((Object)JPrimitiveType.FLOAT)) {
            return this.mTypeOracle.findType(Float.class.getName());
        }
        if (jPrimitiveType.equals((Object)JPrimitiveType.INT)) {
            return this.mTypeOracle.findType(Integer.class.getName());
        }
        if (jPrimitiveType.equals((Object)JPrimitiveType.LONG)) {
            return this.mTypeOracle.findType(Long.class.getName());
        }
        if (jPrimitiveType.equals((Object)JPrimitiveType.SHORT)) {
            return this.mTypeOracle.findType(Short.class.getName());
        }
        throw new RuntimeException("No wrapper for " + jPrimitiveType);
    }
}

