/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspectionresultprocessor.commons.jexl;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.metawidget.inspectionresultprocessor.commons.jexl.JexlInspectionResultProcessorConfig;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessorException;
import org.metawidget.inspectionresultprocessor.impl.BaseInspectionResultProcessor;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JexlInspectionResultProcessor<M>
extends BaseInspectionResultProcessor<M> {
    private static final String THIS_ATTRIBUTE = "this";
    private static final ThreadLocal<JexlContext> LOCAL_CONTEXT = new ThreadLocal();
    private static final Pattern PATTERN_EXPRESSION = Pattern.compile("\\$\\{([^\\}]+)\\}");
    private PropertyStyle mInjectThis;
    private Object[] mInject;
    private JexlEngine mJexlEngine;

    public JexlInspectionResultProcessor() {
        this(new JexlInspectionResultProcessorConfig());
    }

    public JexlInspectionResultProcessor(JexlInspectionResultProcessorConfig jexlInspectionResultProcessorConfig) {
        this.mInjectThis = jexlInspectionResultProcessorConfig.getInjectThis();
        this.mInject = jexlInspectionResultProcessorConfig.getInject();
        this.mJexlEngine = this.createEngine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element processInspectionResultAsDom(Element element, M m, Object object, String string, String ... stringArray) {
        try {
            LOCAL_CONTEXT.set(this.createContext(m));
            Element element2 = super.processInspectionResultAsDom(element, m, object, string, stringArray);
            return element2;
        }
        finally {
            LOCAL_CONTEXT.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processEntity(Map<String, String> map, M m, Object object, String string, String ... stringArray) {
        JexlContext jexlContext = LOCAL_CONTEXT.get();
        try {
            jexlContext.set(THIS_ATTRIBUTE, this.mInjectThis.traverse(object, string, true, stringArray).getValue());
            super.processEntity(map, m, object, string, stringArray);
        }
        finally {
            jexlContext.set(THIS_ATTRIBUTE, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processTraits(Element element, M m, Object object, String string, String ... stringArray) {
        JexlContext jexlContext = LOCAL_CONTEXT.get();
        try {
            jexlContext.set(THIS_ATTRIBUTE, this.mInjectThis.traverse(object, string, false, stringArray).getValue());
            super.processTraits(element, m, object, string, stringArray);
        }
        finally {
            jexlContext.set(THIS_ATTRIBUTE, null);
        }
    }

    @Override
    protected void processAttributes(Map<String, String> map, M m) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            Matcher matcher = PATTERN_EXPRESSION.matcher(string2);
            int n = 0;
            while (matcher.find()) {
                String string3 = matcher.group(1);
                try {
                    String string4;
                    Object object = this.mJexlEngine.createExpression(string3).evaluate(LOCAL_CONTEXT.get());
                    if (object == null) {
                        if (matcher.start() == 0 && matcher.end() == string2.length()) {
                            string2 = null;
                            break;
                        }
                        string4 = "";
                    } else {
                        if (matcher.start() == 0 && matcher.end() == string2.length()) {
                            if (object instanceof Collection) {
                                string2 = CollectionUtils.toString((Collection)object);
                                break;
                            }
                            if (object.getClass().isArray()) {
                                string2 = ArrayUtils.toString(object);
                                break;
                            }
                            string2 = String.valueOf(object);
                            break;
                        }
                        string4 = String.valueOf(object);
                    }
                    string2 = new StringBuilder(string2).replace(matcher.start() + n, matcher.end() + n, string4).toString();
                    n += string4.length() - (matcher.end() - matcher.start());
                }
                catch (Exception exception) {
                    throw InspectionResultProcessorException.newException("Unable to evaluate " + string2, exception);
                }
            }
            map.put(string, string2);
        }
    }

    protected JexlEngine createEngine() {
        return new JexlEngine();
    }

    protected JexlContext createContext(M m) {
        MapContext mapContext = new MapContext();
        if (this.mInject != null) {
            for (Object object : this.mInject) {
                mapContext.set(StringUtils.decapitalize(object.getClass().getSimpleName()), object);
            }
        }
        return mapContext;
    }
}

