/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.annotation;

import java.util.HashMap;
import java.util.Map;
import org.metawidget.inspector.annotation.UiAction;
import org.metawidget.inspector.annotation.UiAttribute;
import org.metawidget.inspector.annotation.UiAttributes;
import org.metawidget.inspector.annotation.UiComesAfter;
import org.metawidget.inspector.annotation.UiDontExpand;
import org.metawidget.inspector.annotation.UiHidden;
import org.metawidget.inspector.annotation.UiLabel;
import org.metawidget.inspector.annotation.UiLarge;
import org.metawidget.inspector.annotation.UiLookup;
import org.metawidget.inspector.annotation.UiMasked;
import org.metawidget.inspector.annotation.UiReadOnly;
import org.metawidget.inspector.annotation.UiRequired;
import org.metawidget.inspector.annotation.UiSection;
import org.metawidget.inspector.annotation.UiWide;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.Trait;
import org.metawidget.inspector.impl.actionstyle.Action;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetawidgetAnnotationInspector
extends BaseObjectInspector {
    public MetawidgetAnnotationInspector() {
        this(new BaseObjectInspectorConfig());
    }

    public MetawidgetAnnotationInspector(BaseObjectInspectorConfig baseObjectInspectorConfig) {
        super(baseObjectInspectorConfig);
    }

    @Override
    protected Map<String, String> inspectTrait(Trait trait) throws Exception {
        UiAttributes uiAttributes;
        UiAttribute uiAttribute;
        UiLabel uiLabel;
        UiSection uiSection;
        UiReadOnly uiReadOnly;
        UiComesAfter uiComesAfter;
        HashMap<String, String> hashMap = CollectionUtils.newHashMap();
        if (trait.isAnnotationPresent(UiHidden.class)) {
            hashMap.put("hidden", "true");
        }
        if ((uiComesAfter = trait.getAnnotation(UiComesAfter.class)) != null) {
            hashMap.put("comes-after", ArrayUtils.toString(uiComesAfter.value()));
        }
        if ((uiReadOnly = trait.getAnnotation(UiReadOnly.class)) != null) {
            hashMap.put("read-only", "true");
        }
        if ((uiSection = trait.getAnnotation(UiSection.class)) != null) {
            hashMap.put("section", ArrayUtils.toString(uiSection.value()));
        }
        if ((uiLabel = trait.getAnnotation(UiLabel.class)) != null) {
            hashMap.put("label", uiLabel.value());
        }
        if ((uiAttribute = trait.getAnnotation(UiAttribute.class)) != null) {
            this.putUiAttribute(uiAttribute, hashMap);
        }
        if ((uiAttributes = trait.getAnnotation(UiAttributes.class)) != null) {
            for (UiAttribute uiAttribute2 : uiAttributes.value()) {
                this.putUiAttribute(uiAttribute2, hashMap);
            }
        }
        return hashMap;
    }

    @Override
    protected Map<String, String> inspectProperty(Property property) throws Exception {
        UiDontExpand uiDontExpand;
        UiLookup uiLookup;
        HashMap<String, String> hashMap = CollectionUtils.newHashMap();
        if (property.isAnnotationPresent(UiRequired.class)) {
            hashMap.put("required", "true");
        }
        if ((uiLookup = property.getAnnotation(UiLookup.class)) != null) {
            hashMap.put("lookup", ArrayUtils.toString(uiLookup.value()));
            if (uiLookup.labels().length > 0) {
                hashMap.put("lookup-labels", ArrayUtils.toString(uiLookup.labels()));
            }
        }
        if (property.isAnnotationPresent(UiMasked.class)) {
            hashMap.put("masked", "true");
        }
        if (property.isAnnotationPresent(UiLarge.class)) {
            hashMap.put("large", "true");
        }
        if (property.isAnnotationPresent(UiWide.class)) {
            hashMap.put("wide", "true");
        }
        if ((uiDontExpand = property.getAnnotation(UiDontExpand.class)) != null) {
            hashMap.put("dont-expand", "true");
        }
        return hashMap;
    }

    @Override
    protected Map<String, String> inspectAction(Action action) throws Exception {
        HashMap<String, String> hashMap = CollectionUtils.newHashMap();
        if (action.isAnnotationPresent(UiAction.class)) {
            hashMap.put("name", action.getName());
        }
        return hashMap;
    }

    private void putUiAttribute(UiAttribute uiAttribute, Map<String, String> map) {
        for (String string : uiAttribute.name()) {
            map.put(string, uiAttribute.value());
        }
    }
}

