/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.beanvalidation;

import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidationInspector
extends BaseObjectInspector {
    public BeanValidationInspector() {
        this(new BaseObjectInspectorConfig());
    }

    public BeanValidationInspector(BaseObjectInspectorConfig baseObjectInspectorConfig) {
        super(baseObjectInspectorConfig);
    }

    @Override
    protected Map<String, String> inspectProperty(Property property) throws Exception {
        Pattern pattern;
        Size size;
        Max max;
        Min min;
        HashMap<String, String> hashMap = CollectionUtils.newHashMap();
        Digits digits = property.getAnnotation(Digits.class);
        if (digits != null) {
            int n;
            int n2 = digits.integer();
            if (n2 > 0) {
                hashMap.put("maximum-integer-digits", String.valueOf(n2));
            }
            if ((n = digits.fraction()) > 0) {
                hashMap.put("maximum-fractional-digits", String.valueOf(n));
            }
        }
        if (property.isAnnotationPresent(NotNull.class)) {
            hashMap.put("required", "true");
        }
        if ((min = property.getAnnotation(Min.class)) != null) {
            hashMap.put("minimum-value", String.valueOf(min.value()));
        }
        if ((max = property.getAnnotation(Max.class)) != null) {
            hashMap.put("maximum-value", String.valueOf(max.value()));
        }
        if ((size = property.getAnnotation(Size.class)) != null) {
            if (size.min() > 0) {
                hashMap.put("minimum-length", String.valueOf(size.min()));
            }
            if (size.max() > 0) {
                hashMap.put("maximum-length", String.valueOf(size.max()));
            }
        }
        if ((pattern = property.getAnnotation(Pattern.class)) != null) {
            hashMap.put("validation-pattern", String.valueOf(pattern.regexp()));
        }
        return hashMap;
    }
}

