/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.commons.validator;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.metawidget.config.iface.ResourceResolver;
import org.metawidget.inspector.commons.validator.CommonsValidatorInspectorConfig;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspector;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonsValidatorInspector
extends BaseXmlInspector {
    private static final String FORMSET_ELEMENT = "formset";
    private static final String FIELD_ELEMENT = "field";

    public CommonsValidatorInspector(CommonsValidatorInspectorConfig commonsValidatorInspectorConfig) {
        super(commonsValidatorInspectorConfig);
    }

    @Override
    protected Element getDocumentElement(ResourceResolver resourceResolver, InputStream ... inputStreamArray) throws Exception {
        Document document = XmlUtils.newDocument();
        Element element = document.createElement(FORMSET_ELEMENT);
        document.appendChild(element);
        for (InputStream inputStream : inputStreamArray) {
            Document document2 = XmlUtils.parse(inputStream);
            Element element2 = XmlUtils.getChildNamed(document2.getDocumentElement(), FORMSET_ELEMENT);
            if (element2 == null) continue;
            XmlUtils.combineElements(element, element2, this.getTopLevelTypeAttribute(), this.getNameAttribute());
        }
        return element;
    }

    @Override
    protected Map<String, String> inspectProperty(Element element) {
        if (!FIELD_ELEMENT.equals(element.getNodeName())) {
            return null;
        }
        HashMap<String, String> hashMap = CollectionUtils.newHashMap();
        String string = element.getAttribute(this.getNameAttribute());
        hashMap.put("name", string);
        if (element.hasAttribute("depends")) {
            StringTokenizer stringTokenizer = new StringTokenizer(element.getAttribute("depends"), ",");
            Element element2 = XmlUtils.getChildNamed(element, "var");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if ("required".equals(string2)) {
                    hashMap.put("required", "true");
                }
                if ("intRange".equals(string2) || "floatRange".equals(string2) || "doubleRange".equals(string2)) {
                    String string3;
                    String string4 = this.getVarValue(element2, "min");
                    if (string4 != null) {
                        hashMap.put("minimum-value", string4);
                    }
                    if ((string3 = this.getVarValue(element2, "max")) != null) {
                        hashMap.put("maximum-value", string3);
                    }
                    if (string4 == null && string3 == null) {
                        throw InspectorException.newException("Property '" + string + "' depends on " + string2 + " but has no var-name of min or max");
                    }
                }
                if ("minlength".equals(string2)) {
                    hashMap.put("minimum-length", this.getVarValue(element2, "minlength", string, string2));
                }
                if (!"maxlength".equals(string2)) continue;
                hashMap.put("maximum-length", this.getVarValue(element2, "maxlength", string, string2));
            }
        }
        return hashMap;
    }

    @Override
    protected String getTopLevelTypeAttribute() {
        return "name";
    }

    @Override
    protected String getNameAttribute() {
        return "property";
    }

    private String getVarValue(Element element, String string, String string2, String string3) {
        String string4 = this.getVarValue(element, string);
        if (string4 == null) {
            throw InspectorException.newException("Property '" + string2 + "' depends on " + string3 + " but has no var-name of " + string);
        }
        return string4;
    }

    private String getVarValue(Element element, String string) {
        Element element2 = element;
        while (element2 != null) {
            Element element3 = XmlUtils.getChildNamed(element2, "var-name");
            if (string.equals(element3.getTextContent())) {
                Element element4 = XmlUtils.getChildNamed(element2, "var-value");
                if (element4 == null) {
                    throw InspectorException.newException("Variable named '" + string + "' has no var-value");
                }
                return element4.getTextContent();
            }
            element2 = XmlUtils.getSiblingNamed(element2, "var");
        }
        return null;
    }
}

