/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.composite;

import org.metawidget.inspector.composite.CompositeInspectorConfig;
import org.metawidget.inspector.iface.DomInspector;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.LogUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeInspector
implements DomInspector<Element> {
    private static final LogUtils.Log LOG = LogUtils.getLog(CompositeInspector.class);
    final Inspector[] mInspectors;

    public CompositeInspector(CompositeInspectorConfig compositeInspectorConfig) {
        Inspector[] inspectorArray = compositeInspectorConfig.getInspectors();
        if (inspectorArray == null || inspectorArray.length == 0) {
            throw InspectorException.newException("CompositeInspector needs at least one Inspector");
        }
        this.mInspectors = new Inspector[inspectorArray.length];
        int n = inspectorArray.length;
        for (int i = 0; i < n; ++i) {
            Inspector inspector = inspectorArray[i];
            for (int j = 0; j < i; ++j) {
                if (!this.mInspectors[j].equals(inspector)) continue;
                throw InspectorException.newException("CompositeInspector's list of Inspectors contains two of the same " + inspector.getClass().getName());
            }
            this.mInspectors[i] = inspector;
        }
    }

    @Override
    public final String inspect(Object object, String string, String ... stringArray) {
        return this.inspect(null, object, string, stringArray);
    }

    public final String inspect(String string, Object object, String string2, String ... stringArray) {
        Element element = this.inspectAsDom(XmlUtils.documentFromString(string), object, string2, stringArray);
        if (element == null) {
            return null;
        }
        return XmlUtils.nodeToString((Node)element, false);
    }

    @Override
    public final Element inspectAsDom(Object object, String string, String ... stringArray) {
        return this.inspectAsDom(null, object, string, stringArray);
    }

    public Element inspectAsDom(Document document, Object object, String string, String ... stringArray) {
        try {
            Object object2;
            Document document2 = this.runInspectors(document, object, string, stringArray);
            if (document2 == null || !document2.hasChildNodes()) {
                if (object != null && string != null && LOG.isWarnEnabled()) {
                    LOG.warn("No inspectors matched path == {0}{1}", string, ArrayUtils.toString(stringArray, StringUtils.SEPARATOR_FORWARD_SLASH, true, false));
                }
                return null;
            }
            if (LOG.isDebugEnabled()) {
                object2 = XmlUtils.documentToString(document2, true);
                LOG.debug("Inspected {0}{1}\r\n{2}", string, ArrayUtils.toString(stringArray, StringUtils.SEPARATOR_FORWARD_SLASH, true, false), object2);
            }
            object2 = document2.getDocumentElement();
            if (object != null && string != null && LOG.isWarnEnabled() && !object2.hasChildNodes()) {
                LOG.warn("No inspectors matched path == {0}{1}", string, ArrayUtils.toString(stringArray, StringUtils.SEPARATOR_FORWARD_SLASH, true, false));
                return object2;
            }
            return object2;
        }
        catch (Exception exception) {
            throw InspectorException.newException(exception);
        }
    }

    protected Document runInspectors(Document document, Object object, String string, String ... stringArray) throws Exception {
        Document document2 = document;
        for (Inspector inspector : this.mInspectors) {
            Document document3 = this.runInspector(inspector, object, string, stringArray);
            document2 = this.combineInspectionResult(document2, document3);
        }
        return document2;
    }

    protected Document runInspector(Inspector inspector, Object object, String string, String ... stringArray) throws Exception {
        if (inspector instanceof DomInspector) {
            DomInspector domInspector = (DomInspector)inspector;
            Element element = (Element)domInspector.inspectAsDom(object, string, stringArray);
            if (element == null) {
                return null;
            }
            if (LOG.isTraceEnabled()) {
                String string2 = XmlUtils.nodeToString((Node)element, true);
                LOG.trace("{0} inspected {1}{2}\r\n{3}", inspector.getClass(), string, ArrayUtils.toString(stringArray, StringUtils.SEPARATOR_FORWARD_SLASH, true, false), string2);
            }
            this.validate(element.getOwnerDocument());
            return element.getOwnerDocument();
        }
        String string3 = inspector.inspect(object, string, stringArray);
        if (string3 == null) {
            return null;
        }
        LOG.trace("{0} inspected {1}{2}\r\n{3}", inspector.getClass(), string, ArrayUtils.toString(stringArray, StringUtils.SEPARATOR_FORWARD_SLASH, true, false), string3);
        Document document = XmlUtils.documentFromString(string3);
        this.validate(document);
        return document;
    }

    protected Document combineInspectionResult(Document document, Document document2) {
        if (document2 == null || !document2.hasChildNodes()) {
            return document;
        }
        if (document == null || !document.hasChildNodes()) {
            return document2;
        }
        XmlUtils.combineElements(document.getDocumentElement(), document2.getDocumentElement(), "type", "name");
        return document;
    }

    protected void validate(Document document) throws Exception {
    }
}

