/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.hibernate;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.metawidget.config.iface.ResourceResolver;
import org.metawidget.inspector.hibernate.HibernateInspectorConfig;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspector;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateInspector
extends BaseXmlInspector {
    private static final String HIBERNATE_CONFIGURATION_ELEMENT = "hibernate-configuration";
    private static final String HIBERNATE_MAPPING_ELEMENT = "hibernate-mapping";
    private static final InputStream[] EMPTY_INPUTSTREAM_ARRAY = new InputStream[0];
    private static final String PROPERTY_REF_ATTRIBUTE = "property-ref";
    private final boolean mHideIds;

    public HibernateInspector(HibernateInspectorConfig hibernateInspectorConfig) {
        super(hibernateInspectorConfig);
        this.mHideIds = hibernateInspectorConfig.isHideIds();
    }

    @Override
    protected String getTopLevelTypeAttribute() {
        return "name";
    }

    @Override
    protected String getTypeAttribute() {
        return "class";
    }

    @Override
    protected String getExtendsAttribute() {
        return "extends";
    }

    @Override
    protected Element getDocumentElement(ResourceResolver resourceResolver, InputStream ... inputStreamArray) throws Exception {
        Document document = null;
        for (InputStream inputStream : inputStreamArray) {
            Document document2 = XmlUtils.parse(inputStream);
            if (!document2.hasChildNodes()) continue;
            Element element = document2.getDocumentElement();
            String string = element.getNodeName();
            if (HIBERNATE_CONFIGURATION_ELEMENT.equals(string)) {
                Element element2 = XmlUtils.getChildNamed(document2.getDocumentElement(), "session-factory", "mapping");
                ArrayList<InputStream> arrayList = CollectionUtils.newArrayList();
                while (element2 != null) {
                    arrayList.add(resourceResolver.openResource(element2.getAttribute("resource")));
                    element2 = XmlUtils.getSiblingNamed(element2, "mapping");
                }
                element = this.getDocumentElement(resourceResolver, arrayList.toArray(EMPTY_INPUTSTREAM_ARRAY));
                if (document == null || !document.hasChildNodes()) {
                    document = element.getOwnerDocument();
                    continue;
                }
            } else if (HIBERNATE_MAPPING_ELEMENT.equals(string)) {
                this.preprocessDocument(document2);
                if (document == null || !document.hasChildNodes()) {
                    document = document2;
                    continue;
                }
            } else {
                throw InspectorException.newException("Expected an XML document starting with 'hibernate-configuration' or 'hibernate-mapping', but got '" + string + "'");
            }
            XmlUtils.combineElements(document.getDocumentElement(), element, this.getTopLevelTypeAttribute(), this.getNameAttribute());
        }
        if (document == null) {
            return null;
        }
        return document.getDocumentElement();
    }

    @Override
    protected void preprocessDocument(Document document) {
        Element element = document.getDocumentElement();
        String string = element.getAttribute("package");
        if (string != null && !"".equals(string)) {
            string = string + '.';
            String string2 = this.getTopLevelTypeAttribute();
            String string3 = this.getExtendsAttribute();
            Element element2 = XmlUtils.getFirstChildElement(element);
            while (element2 != null) {
                String string4;
                String string5 = element2.getAttribute(string2);
                if (string5 != null && !"".equals(string5) && string5.indexOf(46) == -1) {
                    element2.setAttribute(string2, string + string5);
                }
                if ((string4 = element2.getAttribute(string3)) != null && !"".equals(string4) && string4.indexOf(46) == -1) {
                    element2.setAttribute(string3, string + string4);
                }
                this.prependPackageToClassAttribute(element2, string);
                element2 = XmlUtils.getNextSiblingElement(element2);
            }
        }
    }

    @Override
    protected Map<String, String> inspectProperty(Element element) {
        Element element2;
        String string;
        HashMap<String, String> hashMap = CollectionUtils.newHashMap();
        hashMap.put("name", element.getAttribute("name"));
        String string2 = element.getAttribute("type");
        if ("clob".equals(string2)) {
            hashMap.put("type", String.class.getName());
            hashMap.put("large", "true");
        }
        if (element.hasAttribute(string = this.getTypeAttribute())) {
            hashMap.put("type", element.getAttribute(string));
        }
        this.inspectColumnAttributes(element, hashMap);
        Element element3 = XmlUtils.getChildNamed(element, "column");
        if (element3 != null) {
            this.inspectColumnAttributes(element3, hashMap);
        }
        String string3 = element.getNodeName();
        if (this.mHideIds && "id".equals(string3)) {
            hashMap.put("hidden", "true");
        }
        if (("bag".equals(string3) || "list".equals(string3) || "set".equals(string3)) && (element2 = XmlUtils.getChildWithAttribute(element, string)) != null) {
            hashMap.put("parameterized-type", element2.getAttribute(string));
            if (element2.hasAttribute(PROPERTY_REF_ATTRIBUTE)) {
                hashMap.put("inverse-relationship", element2.getAttribute(PROPERTY_REF_ATTRIBUTE));
            }
        }
        if (element.hasAttribute(PROPERTY_REF_ATTRIBUTE)) {
            hashMap.put("inverse-relationship", element.getAttribute(PROPERTY_REF_ATTRIBUTE));
        }
        return hashMap;
    }

    private void inspectColumnAttributes(Element element, Map<String, String> map) {
        if ("true".equals(element.getAttribute("not-null"))) {
            map.put("required", "true");
        }
        if (element.hasAttribute("length")) {
            map.put("maximum-length", element.getAttribute("length"));
        }
    }

    private void prependPackageToClassAttribute(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        String string2 = this.getTypeAttribute();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            String string3 = element2.getAttribute(string2);
            if (string3 != null && !"".equals(string3) && string3.indexOf(46) == -1) {
                element2.setAttribute(string2, string + string3);
            }
            this.prependPackageToClassAttribute(element2, string);
        }
    }
}

