/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import org.metawidget.inspector.iface.DomInspector;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.Trait;
import org.metawidget.inspector.impl.actionstyle.Action;
import org.metawidget.inspector.impl.actionstyle.ActionStyle;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.inspector.impl.propertystyle.ValueAndDeclaredType;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.LogUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseObjectInspector
implements DomInspector<Element> {
    protected final LogUtils.Log mLog = LogUtils.getLog(this.getClass());
    private final PropertyStyle mPropertyStyle;
    private final ActionStyle mActionStyle;

    protected BaseObjectInspector() {
        this(new BaseObjectInspectorConfig());
    }

    protected BaseObjectInspector(BaseObjectInspectorConfig baseObjectInspectorConfig) {
        this.mPropertyStyle = baseObjectInspectorConfig.getPropertyStyle();
        this.mActionStyle = baseObjectInspectorConfig.getActionStyle();
    }

    @Override
    public final String inspect(Object object, String string, String ... stringArray) {
        Element element = this.inspectAsDom(object, string, stringArray);
        if (element == null) {
            return null;
        }
        return XmlUtils.nodeToString((Node)element, false);
    }

    @Override
    public Element inspectAsDom(Object object, String string, String ... stringArray) {
        if (string == null) {
            return null;
        }
        try {
            Object object2;
            Map<String, String> map;
            String string2;
            Object object3;
            String string3;
            Object object4;
            Object object5;
            Object object6;
            boolean bl = false;
            if (object != null) {
                ClassUtils.registerAlienClassLoader(object.getClass().getClassLoader());
            }
            if (stringArray != null && stringArray.length > 0) {
                object6 = this.mPropertyStyle.traverse(object, string, true, stringArray);
                object5 = ((ValueAndDeclaredType)object6).getDeclaredType();
                if (object5 == null) {
                    return null;
                }
                object4 = ((ValueAndDeclaredType)object6).getValue();
                if (object4 != null) {
                    object5 = object4.getClass().getName();
                }
                string3 = stringArray[stringArray.length - 1];
                object3 = this.mPropertyStyle.getProperties((String)object5).get(string3);
                if (object3 == null) {
                    throw InspectorException.newException("Parent of " + string + ArrayUtils.toString(stringArray, StringUtils.SEPARATOR_FORWARD_SLASH, true, false) + " does not define a property '" + string3 + "'");
                }
                string2 = object3.getType();
                map = this.inspectParent(object4, (Property)object3);
                if (object4 == null || !object3.isReadable()) {
                    object2 = null;
                } else {
                    object2 = object3.read(object4);
                    if (object2 == null) {
                        bl = true;
                    } else {
                        ClassUtils.registerAlienClassLoader(object2.getClass().getClassLoader());
                    }
                }
            } else {
                object2 = object;
                string3 = null;
                string2 = string;
                map = null;
            }
            object6 = XmlUtils.newDocument();
            object5 = object6.createElementNS("http://metawidget.org/inspection-result", "entity");
            object4 = object2 == null || ClassUtils.isPrimitive(string2) ? string2 : object2.getClass().getName();
            XmlUtils.setMapAsAttributes((Element)object5, this.inspectEntity(string2, (String)object4));
            if (!bl) {
                this.inspectTraits(object2, (String)object4, (Element)object5);
            }
            XmlUtils.setMapAsAttributes((Element)object5, map);
            if (this.isInspectionEmpty((Element)object5)) {
                return null;
            }
            object3 = object6.createElementNS("http://metawidget.org/inspection-result", "inspection-result");
            object3.setAttribute("version", "1.0");
            object6.appendChild((Node)object3);
            object3.appendChild((Node)object5);
            if (string3 != null) {
                object5.setAttribute("name", string3);
            }
            object5.setAttribute("type", string2);
            return object3;
        }
        catch (Exception exception) {
            throw InspectorException.newException(exception);
        }
    }

    protected Map<String, String> inspectParent(Object object, Property property) throws Exception {
        Map<String, String> map = this.inspectTrait(property);
        Map<String, String> map2 = this.inspectProperty(property);
        if (map == null) {
            return map2;
        }
        if (map2 == null) {
            return map;
        }
        map.putAll(map2);
        return map;
    }

    protected void inspectTraits(Object object, String string, Element element) throws Exception {
        Object object2;
        Map<String, String> map;
        Map<String, String> map2;
        Document document = element.getOwnerDocument();
        for (Property trait : this.getProperties(string).values()) {
            map2 = this.inspectTrait(trait);
            map = this.inspectProperty(trait);
            object2 = this.inspectPropertyAsEntity(trait, object);
            if (!(map2 != null && !map2.isEmpty() || map != null && !map.isEmpty() || object2 != null && !object2.isEmpty())) continue;
            Element element2 = document.createElementNS("http://metawidget.org/inspection-result", "property");
            element2.setAttribute("name", trait.getName());
            XmlUtils.setMapAsAttributes(element2, map2);
            XmlUtils.setMapAsAttributes(element2, map);
            XmlUtils.setMapAsAttributes(element2, (Map<String, String>)object2);
            element.appendChild(element2);
        }
        for (Action action : this.getActions(string).values()) {
            map2 = this.inspectTrait(action);
            map = this.inspectAction(action);
            if (!(map2 != null && !map2.isEmpty() || map != null && !map.isEmpty())) continue;
            object2 = document.createElementNS("http://metawidget.org/inspection-result", "action");
            object2.setAttribute("name", action.getName());
            XmlUtils.setMapAsAttributes((Element)object2, map2);
            XmlUtils.setMapAsAttributes((Element)object2, map);
            element.appendChild((Node)object2);
        }
    }

    protected Map<String, String> inspectEntity(String string, String string2) throws Exception {
        return null;
    }

    protected Map<String, String> inspectTrait(Trait trait) throws Exception {
        return null;
    }

    protected Map<String, String> inspectProperty(Property property) throws Exception {
        return null;
    }

    protected Map<String, String> inspectAction(Action action) throws Exception {
        return null;
    }

    protected boolean shouldInspectPropertyAsEntity(Property property) {
        return false;
    }

    protected final Map<String, Property> getProperties(String string) {
        if (this.mPropertyStyle == null) {
            return Collections.emptyMap();
        }
        return this.mPropertyStyle.getProperties(string);
    }

    protected final Map<String, Action> getActions(String string) {
        if (this.mActionStyle == null) {
            return Collections.emptyMap();
        }
        return this.mActionStyle.getActions(string);
    }

    private Map<String, String> inspectPropertyAsEntity(Property property, Object object) throws Exception {
        if (!this.shouldInspectPropertyAsEntity(property)) {
            return null;
        }
        String string = property.getType();
        if (object != null) {
            Class<?> clazz = ClassUtils.niceForName(string);
            if (property.isReadable() && (clazz == null || !Modifier.isFinal(clazz.getModifiers()))) {
                Object object2 = null;
                try {
                    object2 = property.read(object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (object2 != null) {
                    string = object2.getClass().getName();
                }
            }
        }
        return this.inspectEntity(property.getType(), string);
    }

    private boolean isInspectionEmpty(Element element) {
        if (element.hasAttributes()) {
            return false;
        }
        return !element.hasChildNodes();
    }
}

