/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.metawidget.inspector.impl.BaseTraitStyleConfig;
import org.metawidget.inspector.impl.Trait;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTraitStyle<T extends Trait> {
    final Map<String, Map<String, T>> mCache;
    private Pattern mExcludeBaseType;
    private Class<?>[] mExcludeReturnType;
    private String[] mExcludeName;
    protected final LogUtils.Log mLog = LogUtils.getLog(this.getClass());

    protected BaseTraitStyle(BaseTraitStyleConfig baseTraitStyleConfig) {
        this.mCache = baseTraitStyleConfig.isCacheLookups() ? CollectionUtils.newHashMap() : null;
        this.mExcludeBaseType = baseTraitStyleConfig.getExcludeBaseType();
        this.mExcludeReturnType = baseTraitStyleConfig.getExcludeReturnType();
        this.mExcludeName = baseTraitStyleConfig.getExcludeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        if (this.mCache == null) {
            return;
        }
        Map<String, Map<String, T>> map = this.mCache;
        synchronized (map) {
            this.mCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<String, T> getTraits(String string) {
        if (this.mCache == null) {
            return this.getUncachedTraits(string);
        }
        Map<String, Map<String, T>> map = this.mCache;
        synchronized (map) {
            Map<String, T> map2 = this.getCachedTraits(string);
            if (map2 == null) {
                map2 = this.getUncachedTraits(string);
                this.cacheTraits(string, map2);
            }
            return map2;
        }
    }

    protected final Map<String, T> getCachedTraits(String string) {
        return this.mCache.get(string);
    }

    protected final void cacheTraits(String string, Map<String, T> map) {
        this.mCache.put(string, Collections.unmodifiableMap(map));
    }

    protected abstract Map<String, T> getUncachedTraits(String var1);

    protected final boolean isExcluded(Class<?> clazz, String string, Class<?> clazz2) {
        if (this.isExcludedBaseType(clazz)) {
            return true;
        }
        if (this.isExcludedReturnType(clazz2)) {
            return true;
        }
        return this.isExcludedName(string);
    }

    protected boolean isExcludedBaseType(Class<?> clazz) {
        String string = clazz.getName();
        return this.mExcludeBaseType != null && this.mExcludeBaseType.matcher(string).matches();
    }

    protected boolean isExcludedReturnType(Class<?> clazz) {
        if (this.mExcludeReturnType != null) {
            for (Class<?> clazz2 : this.mExcludeReturnType) {
                if (!clazz2.isAssignableFrom(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isExcludedName(String string) {
        return ArrayUtils.contains(this.mExcludeName, string);
    }
}

