/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import java.util.regex.Pattern;
import org.metawidget.util.simple.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseTraitStyleConfig {
    private static Pattern DEFAULT_EXCLUDE_BASE_TYPE;
    private boolean mCacheLookups = true;
    private Pattern mExcludeBaseType;
    private boolean mNullExcludeBaseType;
    private Class<?>[] mExcludeReturnType;
    private String[] mExcludeName;

    public BaseTraitStyleConfig setCacheLookups(boolean bl) {
        this.mCacheLookups = bl;
        return this;
    }

    public BaseTraitStyleConfig setExcludeBaseType(Pattern pattern) {
        this.mExcludeBaseType = pattern;
        this.mNullExcludeBaseType = pattern == null;
        return this;
    }

    public BaseTraitStyleConfig setExcludeReturnType(Class<?> ... classArray) {
        this.mExcludeReturnType = classArray;
        return this;
    }

    public BaseTraitStyleConfig setExcludeName(String ... stringArray) {
        this.mExcludeName = stringArray;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!ObjectUtils.nullSafeClassEquals(this, object)) {
            return false;
        }
        if (this.mCacheLookups != ((BaseTraitStyleConfig)object).mCacheLookups) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mExcludeBaseType, ((BaseTraitStyleConfig)object).mExcludeBaseType)) {
            return false;
        }
        if (this.mNullExcludeBaseType != ((BaseTraitStyleConfig)object).mNullExcludeBaseType) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mExcludeReturnType, ((BaseTraitStyleConfig)object).mExcludeReturnType)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.mExcludeName, ((BaseTraitStyleConfig)object).mExcludeName);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mCacheLookups);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mExcludeBaseType);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mNullExcludeBaseType);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mExcludeReturnType);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mExcludeName);
        return n;
    }

    protected boolean isCacheLookups() {
        return this.mCacheLookups;
    }

    protected Pattern getExcludeBaseType() {
        if (this.mExcludeBaseType == null && !this.mNullExcludeBaseType) {
            if (DEFAULT_EXCLUDE_BASE_TYPE == null) {
                DEFAULT_EXCLUDE_BASE_TYPE = Pattern.compile("^(java|javax)\\..*$");
            }
            return DEFAULT_EXCLUDE_BASE_TYPE;
        }
        return this.mExcludeBaseType;
    }

    protected Class<?>[] getExcludeReturnType() {
        return this.mExcludeReturnType;
    }

    protected String[] getExcludeName() {
        return this.mExcludeName;
    }
}

