/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import java.io.InputStream;
import java.util.Map;
import org.metawidget.config.iface.ResourceResolver;
import org.metawidget.inspector.iface.DomInspector;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.inspector.impl.propertystyle.ValueAndDeclaredType;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.LogUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseXmlInspector
implements DomInspector<Element> {
    protected LogUtils.Log mLog = LogUtils.getLog(this.getClass());
    private Element mRoot;
    private final PropertyStyle mRestrictAgainstObject;
    private final boolean mInferInheritanceHierarchy;

    protected BaseXmlInspector(BaseXmlInspectorConfig baseXmlInspectorConfig) {
        try {
            InputStream[] inputStreamArray = baseXmlInspectorConfig.getInputStreams();
            if (inputStreamArray != null && inputStreamArray.length > 0) {
                this.mRoot = this.getDocumentElement(baseXmlInspectorConfig.getResourceResolver(), baseXmlInspectorConfig.getInputStreams());
            }
            if (this.mRoot == null) {
                throw InspectorException.newException("No XML input file specified");
            }
            if (this.mLog.isTraceEnabled()) {
                this.mLog.trace(XmlUtils.documentToString(this.mRoot.getOwnerDocument(), false), new Object[0]);
            }
            this.mRestrictAgainstObject = baseXmlInspectorConfig.getRestrictAgainstObject();
            this.mInferInheritanceHierarchy = baseXmlInspectorConfig.isInferInheritanceHierarchy();
            if (this.mRestrictAgainstObject != null && this.mInferInheritanceHierarchy) {
                throw InspectorException.newException("When using restrictAgainstObject, inferInheritanceHierarchy is implied");
            }
            PropertyStyle propertyStyle = baseXmlInspectorConfig.getValidateAgainstClasses();
            if (propertyStyle != null) {
                String string = this.getTopLevelTypeAttribute();
                String string2 = this.getExtendsAttribute();
                String string3 = this.getNameAttribute();
                String string4 = this.getTypeAttribute();
                Element element = XmlUtils.getChildWithAttribute(this.mRoot, string);
                while (element != null) {
                    String string5 = element.getAttribute(string);
                    Class<?> clazz = ClassUtils.niceForName(string5);
                    if (clazz != null) {
                        String string6 = element.getAttribute(string2);
                        Class<?> clazz2 = clazz.getSuperclass();
                        if (!"".equals(string6) && !string6.equals(clazz2.getName())) {
                            throw InspectorException.newException(clazz + " extends " + clazz2 + ", not '" + string6 + "'");
                        }
                        Map<String, Property> map = propertyStyle.getProperties(string5);
                        Element element2 = XmlUtils.getChildWithAttribute(element, string3);
                        while (element2 != null) {
                            String string7 = element2.getAttribute(string3);
                            Property property = map.get(string7);
                            if (property == null) {
                                throw InspectorException.newException(clazz + " does not define a property '" + string7 + "'");
                            }
                            String string8 = element2.getAttribute(string4);
                            String string9 = property.getType();
                            if (!"".equals(string8) && !string8.equals(string9)) {
                                throw InspectorException.newException(clazz + " defines property '" + string7 + "' to be " + string9 + ", not '" + string8 + "'");
                            }
                            element2 = XmlUtils.getSiblingWithAttribute(element2, string3);
                        }
                    }
                    element = XmlUtils.getSiblingWithAttribute(element, string);
                }
            }
        }
        catch (Exception exception) {
            throw InspectorException.newException(exception);
        }
    }

    @Override
    public final String inspect(Object object, String string, String ... stringArray) {
        Element element = this.inspectAsDom(object, string, stringArray);
        if (element == null) {
            return null;
        }
        return XmlUtils.nodeToString((Node)element, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element inspectAsDom(Object object, String string, String ... stringArray) {
        if (string == null) {
            return null;
        }
        try {
            Element element;
            Document document;
            ValueAndDeclaredType valueAndDeclaredType;
            Map<String, String> map = null;
            Element element2 = this.mRoot;
            synchronized (element2) {
                Element element3;
                if (stringArray != null && stringArray.length > 0 && (element3 = (Element)this.traverse(object, string, true, stringArray).getValue()) != null) {
                    map = this.inspectProperty(element3);
                }
                if ((valueAndDeclaredType = this.traverse(object, string, false, stringArray)).getValue() == null) {
                    if (map == null || map.isEmpty()) {
                        return null;
                    }
                    document = XmlUtils.newDocument();
                    element = document.createElementNS("http://metawidget.org/inspection-result", "entity");
                } else {
                    document = XmlUtils.newDocument();
                    element = document.createElementNS("http://metawidget.org/inspection-result", "entity");
                    this.inspectTraits((Element)valueAndDeclaredType.getValue(), element);
                    if (!element.hasChildNodes()) {
                        return null;
                    }
                }
            }
            element2 = document.createElementNS("http://metawidget.org/inspection-result", "inspection-result");
            element2.setAttribute("version", "1.0");
            document.appendChild(element2);
            element2.appendChild(element);
            XmlUtils.setMapAsAttributes(element, map);
            element.setAttribute("type", valueAndDeclaredType.getDeclaredType());
            return element2;
        }
        catch (Exception exception) {
            throw InspectorException.newException(exception);
        }
    }

    protected Element getDocumentElement(ResourceResolver resourceResolver, InputStream ... inputStreamArray) throws Exception {
        Document document = null;
        for (InputStream inputStream : inputStreamArray) {
            Document document2 = XmlUtils.parse(inputStream);
            if (!document2.hasChildNodes()) continue;
            this.preprocessDocument(document2);
            if (document == null || !document.hasChildNodes()) {
                document = document2;
                continue;
            }
            XmlUtils.combineElements(document.getDocumentElement(), document2.getDocumentElement(), this.getTopLevelTypeAttribute(), this.getNameAttribute());
        }
        if (document == null) {
            return null;
        }
        return document.getDocumentElement();
    }

    protected void preprocessDocument(Document document) {
    }

    protected void inspectTraits(Element element, Element element2) {
        if (element == null) {
            return;
        }
        Document document = element2.getOwnerDocument();
        String string = this.getExtendsAttribute();
        if (string != null && element.hasAttribute(string)) {
            this.inspectTraits((Element)this.traverse(null, element.getAttribute(string), false, new String[0]).getValue(), element2);
        }
        Element element3 = document.createElementNS("http://metawidget.org/inspection-result", "entity");
        Element element4 = XmlUtils.getFirstChildElement(element);
        while (element4 != null) {
            Element element5 = this.inspectTrait(document, element4);
            if (element5 != null) {
                element3.appendChild(element5);
            }
            element4 = XmlUtils.getNextSiblingElement(element4);
        }
        XmlUtils.combineElements(element2, element3, "name", "name");
    }

    protected Element inspectTrait(Document document, Element element) {
        Map<String, String> map = this.inspectProperty(element);
        if (map != null && !map.isEmpty()) {
            Element element2 = document.createElementNS("http://metawidget.org/inspection-result", "property");
            XmlUtils.setMapAsAttributes(element2, map);
            return element2;
        }
        Map<String, String> map2 = this.inspectAction(element);
        if (map2 != null && !map2.isEmpty()) {
            if (map != null) {
                throw InspectorException.newException("Ambigious match: " + element.getNodeName() + " matches as both a property and an action");
            }
            Element element3 = document.createElementNS("http://metawidget.org/inspection-result", "action");
            XmlUtils.setMapAsAttributes(element3, map2);
            return element3;
        }
        return null;
    }

    protected Map<String, String> inspectProperty(Element element) {
        return null;
    }

    protected Map<String, String> inspectAction(Element element) {
        return null;
    }

    protected ValueAndDeclaredType traverse(Object object, String string, boolean bl, String ... stringArray) {
        Element element;
        Object object2;
        String string2 = string;
        Object object3 = stringArray;
        Object object4 = null;
        String string3 = null;
        if (object != null && this.mRestrictAgainstObject != null) {
            object2 = this.mRestrictAgainstObject.traverse(object, string2, bl, (String)object3);
            object4 = ((ValueAndDeclaredType)object2).getValue();
            if (((ValueAndDeclaredType)object2).getDeclaredType() != null) {
                string3 = ((ValueAndDeclaredType)object2).getDeclaredType();
            }
            if (object4 == null) {
                return new ValueAndDeclaredType(null, string3);
            }
            object3 = bl ? new String[]{object3[((String[])object3).length - 1]} : null;
            string2 = object4.getClass().getName();
        }
        if (string3 == null) {
            string3 = string2;
        }
        if ((element = XmlUtils.getChildWithAttributeValue(this.mRoot, (String)(object2 = this.getTopLevelTypeAttribute()), string2)) == null) {
            Class<?> clazz;
            if (object4 == null && !this.mInferInheritanceHierarchy) {
                return new ValueAndDeclaredType(null, string3);
            }
            if (object4 != null) {
                clazz = object4.getClass();
            } else {
                clazz = ClassUtils.niceForName(string2);
                if (clazz == null) {
                    return new ValueAndDeclaredType(null, string2);
                }
            }
            while (element == null && (clazz = clazz.getSuperclass()) != null) {
                element = XmlUtils.getChildWithAttributeValue(this.mRoot, (String)object2, clazz.getName());
            }
            if (element == null) {
                return new ValueAndDeclaredType(null, string3);
            }
        }
        if (object3 == null) {
            return new ValueAndDeclaredType(element, string3);
        }
        int n = ((String[])object3).length;
        if (n == 0) {
            return new ValueAndDeclaredType(element, string3);
        }
        String string4 = this.getExtendsAttribute();
        String string5 = this.getNameAttribute();
        String string6 = this.getTypeAttribute();
        for (int i = 0; i < n; ++i) {
            String string7 = object3[i];
            Element element2 = XmlUtils.getChildWithAttributeValue(element, string5, string7);
            if (element2 == null) {
                if (string4 == null) {
                    return new ValueAndDeclaredType(null, null);
                }
                do {
                    if (!element.hasAttribute(string4)) {
                        return new ValueAndDeclaredType(null, null);
                    }
                    String string8 = element.getAttribute(string4);
                    if ((element = XmlUtils.getChildWithAttributeValue(this.mRoot, (String)object2, string8)) != null) continue;
                    return new ValueAndDeclaredType(null, null);
                } while ((element2 = XmlUtils.getChildWithAttributeValue(element, string5, string7)) == null);
                if (element2 == null) {
                    throw new NullPointerException("property");
                }
            }
            if (bl && i >= n - 1) {
                return new ValueAndDeclaredType(element2, element2.getAttribute(string6));
            }
            if (!element2.hasAttribute(string6)) {
                throw InspectorException.newException("Property " + string7 + " in entity " + element.getAttribute(string6) + " has no @" + string6 + " attribute in the XML, so cannot navigate to " + string + ArrayUtils.toString(object3, StringUtils.SEPARATOR_FORWARD_SLASH, true, false));
            }
            string3 = element2.getAttribute(string6);
            element = XmlUtils.getChildWithAttributeValue(this.mRoot, (String)object2, string3);
            if (element == null) break;
        }
        return new ValueAndDeclaredType(element, string3);
    }

    protected String getTopLevelTypeAttribute() {
        return "type";
    }

    protected String getNameAttribute() {
        return "name";
    }

    protected String getTypeAttribute() {
        return "type";
    }

    protected String getExtendsAttribute() {
        return null;
    }
}

