/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import java.io.InputStream;
import org.metawidget.config.iface.NeedsResourceResolver;
import org.metawidget.config.iface.ResourceResolver;
import org.metawidget.config.impl.SimpleResourceResolver;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.util.simple.ObjectUtils;

public class BaseXmlInspectorConfig
implements NeedsResourceResolver {
    private String mDefaultFile;
    private ResourceResolver mResourceResolver;
    private InputStream[] mInputStreams;
    private PropertyStyle mRestrictAgainstObject;
    private boolean mInferInheritanceHierarchy;
    private PropertyStyle mValidateAgainstClasses;

    public BaseXmlInspectorConfig setInputStreams(InputStream ... inputStreamArray) {
        this.mInputStreams = inputStreamArray;
        return this;
    }

    public BaseXmlInspectorConfig setInputStream(InputStream inputStream) {
        this.mDefaultFile = null;
        this.mInputStreams = new InputStream[]{inputStream};
        return this;
    }

    public void setResourceResolver(ResourceResolver resourceResolver) {
        this.mResourceResolver = resourceResolver;
    }

    public BaseXmlInspectorConfig setRestrictAgainstObject(PropertyStyle propertyStyle) {
        this.mRestrictAgainstObject = propertyStyle;
        return this;
    }

    public BaseXmlInspectorConfig setInferInheritanceHierarchy(boolean bl) {
        this.mInferInheritanceHierarchy = bl;
        return this;
    }

    public BaseXmlInspectorConfig setValidateAgainstClasses(PropertyStyle propertyStyle) {
        this.mValidateAgainstClasses = propertyStyle;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!ObjectUtils.nullSafeClassEquals(this, object)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mDefaultFile, ((BaseXmlInspectorConfig)object).mDefaultFile)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mResourceResolver, ((BaseXmlInspectorConfig)object).mResourceResolver)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mInputStreams, ((BaseXmlInspectorConfig)object).mInputStreams)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mRestrictAgainstObject, ((BaseXmlInspectorConfig)object).mRestrictAgainstObject)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mInferInheritanceHierarchy, ((BaseXmlInspectorConfig)object).mInferInheritanceHierarchy)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.mValidateAgainstClasses, ((BaseXmlInspectorConfig)object).mValidateAgainstClasses);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mDefaultFile);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mResourceResolver);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mInputStreams);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mRestrictAgainstObject);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mInferInheritanceHierarchy);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mValidateAgainstClasses);
        return n;
    }

    protected void setDefaultFile(String string) {
        this.mDefaultFile = string;
    }

    protected InputStream[] getInputStreams() {
        if (this.mInputStreams == null && this.mDefaultFile != null) {
            return new InputStream[]{this.getResourceResolver().openResource(this.mDefaultFile)};
        }
        return this.mInputStreams;
    }

    protected ResourceResolver getResourceResolver() {
        if (this.mResourceResolver == null) {
            return new SimpleResourceResolver();
        }
        return this.mResourceResolver;
    }

    protected PropertyStyle getRestrictAgainstObject() {
        return this.mRestrictAgainstObject;
    }

    protected boolean isInferInheritanceHierarchy() {
        return this.mInferInheritanceHierarchy;
    }

    protected PropertyStyle getValidateAgainstClasses() {
        return this.mValidateAgainstClasses;
    }
}

