/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.actionstyle;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import org.metawidget.inspector.impl.BaseTrait;
import org.metawidget.inspector.impl.BaseTraitStyleConfig;
import org.metawidget.inspector.impl.actionstyle.Action;
import org.metawidget.inspector.impl.actionstyle.BaseActionStyle;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodActionStyle
extends BaseActionStyle {
    protected MethodActionStyle(BaseTraitStyleConfig baseTraitStyleConfig) {
        super(baseTraitStyleConfig);
    }

    @Override
    protected Map<String, Action> inspectActions(String string) {
        TreeMap<String, Action> treeMap = CollectionUtils.newTreeMap(StringUtils.CASE_INSENSITIVE_COMPARATOR);
        Class<?> clazz = ClassUtils.niceForName(string);
        if (clazz == null) {
            return treeMap;
        }
        for (Method method : clazz.getMethods()) {
            if (!this.matchAction(method)) continue;
            String string2 = method.getName();
            if (this.isExcluded(ClassUtils.getOriginalDeclaringClass(method), string2, method.getReturnType())) continue;
            treeMap.put(string2, new MethodAction(string2, method));
        }
        return treeMap;
    }

    protected abstract boolean matchAction(Method var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MethodAction
    extends BaseTrait
    implements Action {
        private Method mMethod;

        public MethodAction(String string, Method method) {
            super(string);
            this.mMethod = method;
            if (this.mMethod == null) {
                throw new NullPointerException("method");
            }
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            return ClassUtils.getOriginalAnnotation(this.mMethod, clazz);
        }
    }
}

