/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.propertystyle.javabean;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.propertystyle.BaseProperty;
import org.metawidget.inspector.impl.propertystyle.BasePropertyStyle;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.javabean.JavaBeanPropertyStyleConfig;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanPropertyStyle
extends BasePropertyStyle {
    private boolean mSupportPublicFields;
    private MessageFormat mPrivateFieldConvention;
    private ClassLoader mAdditionalClassLoader;

    public JavaBeanPropertyStyle() {
        this(new JavaBeanPropertyStyleConfig());
    }

    public JavaBeanPropertyStyle(JavaBeanPropertyStyleConfig javaBeanPropertyStyleConfig) {
        super(javaBeanPropertyStyleConfig);
        this.mSupportPublicFields = javaBeanPropertyStyleConfig.isSupportPublicFields();
        this.mPrivateFieldConvention = javaBeanPropertyStyleConfig.getPrivateFieldConvention();
        this.mAdditionalClassLoader = javaBeanPropertyStyleConfig.getAdditionalClassLoader();
    }

    @Override
    protected Map<String, Property> inspectProperties(String string) {
        TreeMap<String, Property> treeMap = CollectionUtils.newTreeMap(StringUtils.CASE_INSENSITIVE_COMPARATOR);
        Class<?> clazz = ClassUtils.niceForName(string, this.mAdditionalClassLoader);
        if (clazz == null) {
            return treeMap;
        }
        this.lookupFields(treeMap, clazz);
        this.lookupGetters(treeMap, clazz);
        this.lookupSetters(treeMap, clazz);
        Iterator iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getValue() != null) continue;
            iterator.remove();
        }
        return treeMap;
    }

    protected void lookupFields(Map<String, Property> map, Class<?> clazz) {
        if (!this.mSupportPublicFields) {
            return;
        }
        for (Field field : clazz.getFields()) {
            int n = field.getModifiers();
            if (Modifier.isStatic(n)) continue;
            String string = field.getName();
            Class<?> clazz2 = field.getType();
            if (this.isExcluded(field.getDeclaringClass(), string, clazz2)) {
                map.put(string, null);
                continue;
            }
            map.put(string, new FieldProperty(string, field));
        }
    }

    protected void lookupGetters(Map<String, Property> map, Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            JavaBeanProperty javaBeanProperty;
            String string;
            Class<?> clazz2;
            if (Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 0 || Void.TYPE.equals(clazz2 = method.getReturnType()) || (string = this.isGetter(method)) == null) continue;
            if (this.isExcluded(ClassUtils.getOriginalDeclaringClass(method), string, clazz2)) {
                map.put(string, null);
                continue;
            }
            Property property = map.get(string);
            if (property instanceof FieldProperty) {
                throw InspectorException.newException("JavaBeanProperty '" + ((FieldProperty)property).getField() + "' has both a public member variable and a public getter method. Should be one or the other");
            }
            if (property instanceof JavaBeanProperty && clazz2.isAssignableFrom(ClassUtils.niceForName((javaBeanProperty = (JavaBeanProperty)property).getType(), this.mAdditionalClassLoader)) || property == null && map.containsKey(string)) continue;
            map.put(string, new JavaBeanProperty(string, clazz2.getName(), method, null, this.getPrivateField(clazz, string)));
        }
    }

    protected String isGetter(Method method) {
        String string;
        String string2 = method.getName();
        if (string2.startsWith("get")) {
            string = string2.substring("get".length());
        } else if (string2.startsWith("is") && Boolean.TYPE.equals(method.getReturnType())) {
            string = string2.substring("is".length());
        } else {
            return null;
        }
        return StringUtils.decapitalize(string);
    }

    protected void lookupSetters(Map<String, Property> map, Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            Class<?>[] classArray;
            if (Modifier.isStatic(method.getModifiers()) || (classArray = method.getParameterTypes()).length != 1) continue;
            Class<?> clazz2 = classArray[0];
            String string = this.isSetter(method);
            if (string == null) continue;
            if (this.isExcluded(ClassUtils.getOriginalDeclaringClass(method), string, clazz2)) {
                map.put(string, null);
                continue;
            }
            Property property = map.get(string);
            if (property instanceof FieldProperty) {
                throw InspectorException.newException("JavaBeanProperty '" + ((FieldProperty)property).getField() + "' has both a public member variable and a public setter method. Should be one or the other");
            }
            if (property instanceof JavaBeanProperty) {
                JavaBeanProperty javaBeanProperty = (JavaBeanProperty)property;
                map.put(string, new JavaBeanProperty(string, javaBeanProperty.getType(), javaBeanProperty.getReadMethod(), method, this.getPrivateField(clazz, string)));
                continue;
            }
            if (property == null && map.containsKey(string)) continue;
            map.put(string, new JavaBeanProperty(string, clazz2.getName(), null, method, this.getPrivateField(clazz, string)));
        }
    }

    protected String isSetter(Method method) {
        String string = method.getName();
        if (!string.startsWith("set")) {
            return null;
        }
        String string2 = string.substring("set".length());
        return StringUtils.decapitalize(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Field getPrivateField(Class<?> clazz, String string) {
        String string2;
        if (this.mPrivateFieldConvention == null) {
            return null;
        }
        Object[] objectArray = new String[]{string, StringUtils.capitalize(string)};
        Serializable serializable = this.mPrivateFieldConvention;
        synchronized (serializable) {
            string2 = this.mPrivateFieldConvention.format(objectArray, new StringBuffer(), (FieldPosition)null).toString();
        }
        for (serializable = clazz; serializable != null && !this.isExcludedBaseType((Class<?>)serializable); serializable = ((Class)serializable).getSuperclass()) {
            try {
                return ((Class)serializable).getDeclaredField(string2);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaBeanProperty
    extends BaseProperty {
        private Method mReadMethod;
        private Method mWriteMethod;
        private Field mPrivateField;

        public JavaBeanProperty(String string, String string2, Method method, Method method2, Field field) {
            super(string, string2);
            this.mReadMethod = method;
            this.mWriteMethod = method2;
            if (this.mReadMethod == null && this.mWriteMethod == null) {
                throw InspectorException.newException("JavaBeanProperty '" + string + "' has no getter and no setter");
            }
            this.mPrivateField = field;
        }

        @Override
        public boolean isReadable() {
            return this.mReadMethod != null;
        }

        @Override
        public Object read(Object object) {
            try {
                return this.mReadMethod.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                throw InspectorException.newException(exception);
            }
        }

        @Override
        public boolean isWritable() {
            return this.mWriteMethod != null;
        }

        @Override
        public void write(Object object, Object object2) {
            try {
                this.mWriteMethod.invoke(object, object2);
            }
            catch (Exception exception) {
                throw InspectorException.newException(exception);
            }
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            T t;
            if (this.mReadMethod != null && (t = ClassUtils.getOriginalAnnotation(this.mReadMethod, clazz)) != null) {
                return t;
            }
            if (this.mWriteMethod != null && (t = ClassUtils.getOriginalAnnotation(this.mWriteMethod, clazz)) != null) {
                return t;
            }
            if (this.mPrivateField != null) {
                t = this.mPrivateField.getAnnotation(clazz);
                if (t != null) {
                    return t;
                }
                return null;
            }
            return null;
        }

        @Override
        public String getGenericType() {
            Type type = this.mReadMethod != null ? ClassUtils.getOriginalGenericReturnType(this.mReadMethod) : ClassUtils.getOriginalGenericParameterTypes(this.mWriteMethod)[0];
            return ClassUtils.getGenericTypeAsString(type);
        }

        public Method getReadMethod() {
            return this.mReadMethod;
        }

        public Method getWriteMethod() {
            return this.mWriteMethod;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldProperty
    extends BaseProperty {
        private Field mField;

        public FieldProperty(String string, Field field) {
            super(string, field.getType().getName());
            this.mField = field;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public Object read(Object object) {
            try {
                return this.mField.get(object);
            }
            catch (Exception exception) {
                throw InspectorException.newException(exception);
            }
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public void write(Object object, Object object2) {
            try {
                this.mField.set(object, object2);
            }
            catch (Exception exception) {
                throw InspectorException.newException(exception);
            }
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            return this.mField.getAnnotation(clazz);
        }

        @Override
        public String getGenericType() {
            return ClassUtils.getGenericTypeAsString(this.mField.getGenericType());
        }

        public Field getField() {
            return this.mField;
        }
    }
}

