/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.propertystyle.javabean;

import java.text.MessageFormat;
import org.metawidget.inspector.impl.BaseTraitStyleConfig;
import org.metawidget.util.simple.ObjectUtils;

public class JavaBeanPropertyStyleConfig
extends BaseTraitStyleConfig {
    private static String[] DEFAULT_EXCLUDE_NAME = new String[]{"propertyChangeListeners", "vetoableChangeListeners"};
    private boolean mNullExcludeName;
    private boolean mSupportPublicFields;
    private MessageFormat mPrivateFieldConvention;
    private ClassLoader mAdditionalClassLoader;

    public JavaBeanPropertyStyleConfig setExcludeName(String ... stringArray) {
        super.setExcludeName(stringArray);
        this.mNullExcludeName = stringArray == null;
        return this;
    }

    public JavaBeanPropertyStyleConfig setSupportPublicFields(boolean bl) {
        this.mSupportPublicFields = bl;
        return this;
    }

    public JavaBeanPropertyStyleConfig setPrivateFieldConvention(MessageFormat messageFormat) {
        this.mPrivateFieldConvention = messageFormat;
        return this;
    }

    public JavaBeanPropertyStyleConfig setAdditionalClassLoader(ClassLoader classLoader) {
        this.mAdditionalClassLoader = classLoader;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!ObjectUtils.nullSafeClassEquals(this, object)) {
            return false;
        }
        if (this.mNullExcludeName != ((JavaBeanPropertyStyleConfig)object).mNullExcludeName) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mPrivateFieldConvention, ((JavaBeanPropertyStyleConfig)object).mPrivateFieldConvention)) {
            return false;
        }
        if (this.mSupportPublicFields != ((JavaBeanPropertyStyleConfig)object).mSupportPublicFields) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mAdditionalClassLoader, ((JavaBeanPropertyStyleConfig)object).mAdditionalClassLoader)) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mNullExcludeName);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mPrivateFieldConvention);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mSupportPublicFields);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mAdditionalClassLoader);
        return n;
    }

    protected String[] getExcludeName() {
        String[] stringArray = super.getExcludeName();
        if (stringArray == null && !this.mNullExcludeName) {
            return DEFAULT_EXCLUDE_NAME;
        }
        return stringArray;
    }

    protected boolean isSupportPublicFields() {
        return this.mSupportPublicFields;
    }

    protected MessageFormat getPrivateFieldConvention() {
        return this.mPrivateFieldConvention;
    }

    protected ClassLoader getAdditionalClassLoader() {
        return this.mAdditionalClassLoader;
    }
}

