/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.propertytype;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTypeInspector
extends BaseObjectInspector {
    public PropertyTypeInspector() {
        this(new BaseObjectInspectorConfig());
    }

    public PropertyTypeInspector(BaseObjectInspectorConfig baseObjectInspectorConfig) {
        super(baseObjectInspectorConfig);
    }

    @Override
    protected boolean shouldInspectPropertyAsEntity(Property property) {
        return true;
    }

    @Override
    protected Map<String, String> inspectEntity(String string, String string2) throws Exception {
        Class<?> clazz;
        HashMap<String, String> hashMap = CollectionUtils.newHashMap();
        hashMap.put("type", string);
        int n = string.indexOf(60);
        if (n != -1) {
            int n2 = string.indexOf(62);
            hashMap.put("parameterized-type", string.substring(n + 1, n2));
        }
        if (!string2.equals(string)) {
            hashMap.put("actual-class", string2);
        }
        if (Boolean.class.getName().equals(string2)) {
            hashMap.put("lookup", "true, false");
            hashMap.put("lookup-labels", "Yes, No");
        }
        if ((clazz = ClassUtils.niceForName(string2)) != null && Enum.class.isAssignableFrom(clazz)) {
            Method method = clazz.getMethod("values", new Class[0]);
            Enum[] enumArray = (Enum[])method.invoke(clazz, new Object[0]);
            ArrayList arrayList = CollectionUtils.newArrayList();
            ArrayList arrayList2 = CollectionUtils.newArrayList();
            for (Enum enum_ : enumArray) {
                arrayList.add(enum_.name());
                arrayList2.add(enum_.toString());
            }
            hashMap.put("lookup", CollectionUtils.toString(arrayList));
            hashMap.put("lookup-labels", CollectionUtils.toString(arrayList2));
        }
        return hashMap;
    }

    @Override
    protected Map<String, String> inspectProperty(Property property) throws Exception {
        String string;
        HashMap<String, String> hashMap = CollectionUtils.newHashMap();
        if (!property.isWritable()) {
            hashMap.put("no-setter", "true");
        }
        if (!property.isReadable()) {
            hashMap.put("no-getter", "true");
        }
        if ((string = property.getGenericType()) != null) {
            hashMap.put("parameterized-type", string);
        }
        return hashMap;
    }
}

