/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.jsp.tagext.html.widgetbuilder;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.metawidget.jsp.tagext.MetawidgetTag;
import org.metawidget.jsp.tagext.html.BaseHtmlMetawidgetTag;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlWidgetBuilderUtils {
    public static String writeValueAttribute(Map<String, String> map, MetawidgetTag metawidgetTag) {
        String string = HtmlWidgetBuilderUtils.evaluateAsText(map, metawidgetTag);
        if (string == null || "".equals(string)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" value=\"");
        stringBuilder.append(string);
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    public static String writeAttributes(Map<String, String> map, MetawidgetTag metawidgetTag) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" name=\"");
        String string = map.get("name");
        if (metawidgetTag.getPathPrefix() != null) {
            string = metawidgetTag.getPathPrefix() + string;
        }
        stringBuilder.append(string);
        stringBuilder.append("\"");
        BaseHtmlMetawidgetTag baseHtmlMetawidgetTag = (BaseHtmlMetawidgetTag)metawidgetTag;
        if (baseHtmlMetawidgetTag.getStyle() != null) {
            stringBuilder.append(" style=\"");
            stringBuilder.append(baseHtmlMetawidgetTag.getStyle());
            stringBuilder.append("\"");
        }
        if (baseHtmlMetawidgetTag.getStyleClass() != null) {
            stringBuilder.append(" class=\"");
            stringBuilder.append(baseHtmlMetawidgetTag.getStyleClass());
            stringBuilder.append("\"");
        }
        return stringBuilder.toString();
    }

    public static String evaluateAsText(Map<String, String> map, MetawidgetTag metawidgetTag) {
        Object object = HtmlWidgetBuilderUtils.evaluate(map, metawidgetTag);
        if (object == null) {
            return "";
        }
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(clazz);
            if (propertyEditor == null) continue;
            propertyEditor.setValue(object);
            return propertyEditor.getAsText();
        }
        return StringUtils.quietValueOf(object);
    }

    public static Object evaluate(Map<String, String> map, MetawidgetTag metawidgetTag) {
        if (metawidgetTag.getPathPrefix() == null) {
            return null;
        }
        return HtmlWidgetBuilderUtils.evaluate("${" + metawidgetTag.getPathPrefix() + map.get("name") + "}", metawidgetTag);
    }

    public static Object evaluate(String string, MetawidgetTag metawidgetTag) {
        try {
            PageContext pageContext = metawidgetTag.getPageContext();
            return pageContext.getExpressionEvaluator().evaluate(string, Object.class, pageContext.getVariableResolver(), null);
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private HtmlWidgetBuilderUtils() {
    }
}

