/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.jsp.tagext.html.widgetbuilder.spring;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.metawidget.jsp.JspUtils;
import org.metawidget.jsp.tagext.MetawidgetTag;
import org.metawidget.jsp.tagext.html.HtmlStubTag;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetbuilder.iface.WidgetBuilderException;
import org.springframework.web.servlet.tags.form.CheckboxTag;
import org.springframework.web.servlet.tags.form.InputTag;
import org.springframework.web.servlet.tags.form.OptionTag;
import org.springframework.web.servlet.tags.form.OptionsTag;
import org.springframework.web.servlet.tags.form.PasswordInputTag;
import org.springframework.web.servlet.tags.form.SelectTag;
import org.springframework.web.servlet.tags.form.TextareaTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringWidgetBuilder
implements WidgetBuilder<Tag, MetawidgetTag> {
    private static final List<Boolean> LIST_BOOLEAN_VALUES = CollectionUtils.unmodifiableList(Boolean.TRUE, Boolean.FALSE);

    @Override
    public Tag buildWidget(String string, Map<String, String> map, MetawidgetTag metawidgetTag) {
        if ("true".equals(map.get("hidden"))) {
            map.put("metawidget-needs-hidden-field", "true");
            return new HtmlStubTag();
        }
        if ("action".equals(string)) {
            return new HtmlStubTag();
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(map, String.class);
        if (Boolean.class.equals(clazz) && "true".equals(map.get("required"))) {
            return new CheckboxTag();
        }
        String string2 = map.get("spring-lookup");
        if (string2 != null && !"".equals(string2)) {
            return this.createSelectTag(string2, map);
        }
        String string3 = map.get("lookup");
        if (string3 != null && !"".equals(string3)) {
            return this.createSelectTag(CollectionUtils.fromString(string3), CollectionUtils.fromString(map.get("lookup-labels")), map);
        }
        if (clazz != null) {
            if (clazz.isPrimitive()) {
                if (Boolean.TYPE.equals(clazz)) {
                    return new CheckboxTag();
                }
                if (Character.TYPE.equals(clazz)) {
                    InputTag inputTag = new InputTag();
                    inputTag.setMaxlength("1");
                    return inputTag;
                }
                return this.createInputTag(map);
            }
            if (String.class.equals(clazz)) {
                if ("true".equals(map.get("masked"))) {
                    PasswordInputTag passwordInputTag = new PasswordInputTag();
                    String string4 = map.get("maximum-length");
                    if (string4 != null) {
                        passwordInputTag.setMaxlength(string4);
                    }
                    return passwordInputTag;
                }
                if ("true".equals(map.get("large"))) {
                    return new TextareaTag();
                }
                return this.createInputTag(map);
            }
            if (Character.class.equals(clazz)) {
                InputTag inputTag = new InputTag();
                inputTag.setMaxlength("1");
                return inputTag;
            }
            if (Date.class.equals(clazz)) {
                return this.createInputTag(map);
            }
            if (Boolean.class.equals(clazz)) {
                return this.createSelectTag(LIST_BOOLEAN_VALUES, null, map);
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return this.createInputTag(map);
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new HtmlStubTag();
            }
        }
        if ("true".equals(map.get("dont-expand"))) {
            return this.createInputTag(map);
        }
        return null;
    }

    private InputTag createInputTag(Map<String, String> map) {
        InputTag inputTag = new InputTag();
        String string = map.get("maximum-length");
        if (string != null) {
            inputTag.setMaxlength(string);
        }
        return inputTag;
    }

    private Tag createSelectTag(String string, Map<String, String> map) {
        String string2;
        OptionTag optionTag;
        SelectTag selectTag = new SelectTag();
        if (WidgetBuilderUtils.needsEmptyLookupItem(map)) {
            optionTag = new OptionTag();
            optionTag.setValue((Object)"");
            JspUtils.addDeferredChild((TagSupport)selectTag, (Tag)optionTag);
        }
        optionTag = new OptionsTag();
        optionTag.setItems((Object)string);
        String string3 = map.get("spring-lookup-item-value");
        if (string3 != null) {
            optionTag.setItemValue(string3);
        }
        if ((string2 = map.get("spring-lookup-item-label")) != null) {
            optionTag.setItemLabel(string2);
        }
        JspUtils.addDeferredChild((TagSupport)selectTag, (Tag)optionTag);
        return selectTag;
    }

    private Tag createSelectTag(List<?> list, List<String> list2, Map<String, String> map) {
        if (list2 != null && !list2.isEmpty() && list2.size() != list.size()) {
            throw WidgetBuilderException.newException("Labels list must be same size as values list");
        }
        SelectTag selectTag = new SelectTag();
        if (WidgetBuilderUtils.needsEmptyLookupItem(map)) {
            OptionTag optionTag = new OptionTag();
            optionTag.setValue((Object)"");
            JspUtils.addDeferredChild((TagSupport)selectTag, (Tag)optionTag);
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            OptionTag optionTag = new OptionTag();
            optionTag.setValue(list.get(i));
            if (list2 != null && !list2.isEmpty()) {
                optionTag.setLabel(list2.get(i));
            }
            JspUtils.addDeferredChild((TagSupport)selectTag, (Tag)optionTag);
        }
        return selectTag;
    }
}

