/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.layout.decorator;

import java.util.Map;
import org.metawidget.layout.decorator.LayoutDecoratorConfig;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.layout.iface.Layout;
import org.metawidget.layout.iface.LayoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayoutDecorator<W, C extends W, M extends C>
implements AdvancedLayout<W, C, M> {
    private final Layout<W, C, M> mDelegate;

    protected LayoutDecorator(LayoutDecoratorConfig<W, C, M> layoutDecoratorConfig) {
        this.mDelegate = layoutDecoratorConfig.getLayout();
        if (this.mDelegate == null) {
            throw LayoutException.newException(this.getClass().getName() + " needs a Layout to decorate (use " + layoutDecoratorConfig.getClass().getName() + ".setLayout)");
        }
    }

    @Override
    public void onStartBuild(M m) {
        if (this.getDelegate() instanceof AdvancedLayout) {
            ((AdvancedLayout)this.getDelegate()).onStartBuild(m);
        }
    }

    @Override
    public void startContainerLayout(C c, M m) {
        if (this.getDelegate() instanceof AdvancedLayout) {
            ((AdvancedLayout)this.getDelegate()).startContainerLayout(c, m);
        }
    }

    @Override
    public void layoutWidget(W w, String string, Map<String, String> map, C c, M m) {
        this.getDelegate().layoutWidget(w, string, map, c, m);
    }

    @Override
    public void endContainerLayout(C c, M m) {
        if (this.getDelegate() instanceof AdvancedLayout) {
            ((AdvancedLayout)this.getDelegate()).endContainerLayout(c, m);
        }
    }

    @Override
    public void onEndBuild(M m) {
        if (this.getDelegate() instanceof AdvancedLayout) {
            ((AdvancedLayout)this.getDelegate()).onEndBuild(m);
        }
    }

    protected Layout<W, C, M> getDelegate() {
        return this.mDelegate;
    }
}

