/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.pipeline.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.metawidget.inspectionresultprocessor.iface.DomInspectionResultProcessor;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessor;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessorException;
import org.metawidget.inspector.iface.DomInspector;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.layout.iface.Layout;
import org.metawidget.widgetbuilder.iface.AdvancedWidgetBuilder;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePipeline<W, C extends W, E, M extends C> {
    private static final int DEFAULT_MAXIMUM_INSPECTION_DEPTH = 10;
    private boolean mReadOnly;
    private int mMaximumInspectionDepth = 10;
    private boolean mNeedsConfiguring = true;
    private Inspector mInspector;
    private List<InspectionResultProcessor<M>> mInspectionResultProcessors;
    private WidgetBuilder<W, M> mWidgetBuilder;
    private List<WidgetProcessor<W, M>> mWidgetProcessors;
    private Layout<W, C, M> mLayout;

    public void setReadOnly(boolean bl) {
        this.mReadOnly = bl;
    }

    public boolean isReadOnly() {
        return this.mReadOnly;
    }

    public int getMaximumInspectionDepth() {
        return this.mMaximumInspectionDepth;
    }

    public void setMaximumInspectionDepth(int n) {
        this.mMaximumInspectionDepth = n;
    }

    public void setNeedsConfiguring() {
        this.mNeedsConfiguring = true;
    }

    public void configureOnce() {
        if (!this.mNeedsConfiguring) {
            return;
        }
        this.mNeedsConfiguring = false;
        this.configure();
    }

    public void setInspector(Inspector inspector) {
        this.mInspector = inspector;
    }

    public Inspector getInspector() {
        this.configureOnce();
        return this.mInspector;
    }

    public List<InspectionResultProcessor<M>> getInspectionResultProcessors() {
        this.configureOnce();
        return this.mInspectionResultProcessors;
    }

    public void setInspectionResultProcessors(InspectionResultProcessor<M> ... inspectionResultProcessorArray) {
        this.mInspectionResultProcessors = inspectionResultProcessorArray == null ? null : new ArrayList<InspectionResultProcessor<M>>(Arrays.asList(inspectionResultProcessorArray));
    }

    public void addInspectionResultProcessor(InspectionResultProcessor<M> inspectionResultProcessor) {
        this.configureOnce();
        if (this.mInspectionResultProcessors == null) {
            this.mInspectionResultProcessors = new ArrayList<InspectionResultProcessor<M>>();
        } else if (this.mInspectionResultProcessors.contains(inspectionResultProcessor)) {
            throw InspectionResultProcessorException.newException("List of InspectionResultProcessors already contains " + inspectionResultProcessor.getClass());
        }
        this.mInspectionResultProcessors.add(inspectionResultProcessor);
    }

    public void removeInspectionResultProcessor(InspectionResultProcessor<M> inspectionResultProcessor) {
        this.configureOnce();
        if (this.mInspectionResultProcessors == null) {
            return;
        }
        this.mInspectionResultProcessors.remove(inspectionResultProcessor);
    }

    public void setWidgetBuilder(WidgetBuilder<W, M> widgetBuilder) {
        this.mWidgetBuilder = widgetBuilder;
    }

    public WidgetBuilder<W, M> getWidgetBuilder() {
        this.configureOnce();
        return this.mWidgetBuilder;
    }

    public List<WidgetProcessor<W, M>> getWidgetProcessors() {
        this.configureOnce();
        return this.mWidgetProcessors;
    }

    public void setWidgetProcessors(WidgetProcessor<W, M> ... widgetProcessorArray) {
        this.mWidgetProcessors = widgetProcessorArray == null ? null : new ArrayList<WidgetProcessor<W, M>>(Arrays.asList(widgetProcessorArray));
    }

    public void addWidgetProcessor(WidgetProcessor<W, M> widgetProcessor) {
        this.configureOnce();
        if (this.mWidgetProcessors == null) {
            this.mWidgetProcessors = new ArrayList<WidgetProcessor<W, M>>();
        } else if (this.mWidgetProcessors.contains(widgetProcessor)) {
            throw WidgetProcessorException.newException("List of WidgetProcessors already contains " + widgetProcessor.getClass());
        }
        this.mWidgetProcessors.add(widgetProcessor);
    }

    public void removeWidgetProcessor(WidgetProcessor<W, M> widgetProcessor) {
        this.configureOnce();
        if (this.mWidgetProcessors == null) {
            return;
        }
        this.mWidgetProcessors.remove(widgetProcessor);
    }

    public Layout<W, C, M> getLayout() {
        this.configureOnce();
        return this.mLayout;
    }

    public void setLayout(Layout<W, C, M> layout) {
        this.mLayout = layout;
    }

    public String inspect(Object object, String string, String ... stringArray) {
        E e = this.inspectAsDom(object, string, stringArray);
        return this.elementToString(e);
    }

    public E inspectAsDom(Object object, String string, String ... stringArray) {
        this.configureOnce();
        if (this.mInspector == null) {
            throw new NullPointerException("No inspector configured");
        }
        String string2 = this.mInspector instanceof DomInspector ? ((DomInspector)this.mInspector).inspectAsDom(object, string, stringArray) : this.mInspector.inspect(object, string, stringArray);
        if (string2 == null) {
            return null;
        }
        return this.processInspectionResult(string2, object, string, stringArray);
    }

    public void buildWidgets(E e) throws Exception {
        this.configureOnce();
        this.startBuild();
        if (e != null) {
            W w;
            E e2 = this.getFirstChildElement(e);
            String string = this.getElementName(e2);
            if (!"entity".equals(string)) {
                throw new Exception("Top-level element name should be entity, not " + string);
            }
            E e3 = this.getNextSiblingElement(e2);
            if (e3 != null) {
                throw new Exception("Top-level entity element has a sibling " + this.getElementName(e3) + " element");
            }
            Map<String, String> map = this.getAttributesAsMap(e2);
            if (this.isReadOnly()) {
                map.put("read-only", "true");
            }
            if ((w = this.buildWidget("entity", map)) == null) {
                this.buildCompoundWidget(e2);
            } else if ((w = this.processWidget(w, "entity", map)) != null) {
                this.layoutWidget(w, "entity", map);
            }
        }
        this.endBuild();
    }

    public void initNestedPipeline(BasePipeline<W, C, E, M> basePipeline, Map<String, String> map) {
        basePipeline.setReadOnly(this.isReadOnly() || map != null && "true".equals(map.get("read-only")));
        basePipeline.setMaximumInspectionDepth(this.getMaximumInspectionDepth() - 1);
        basePipeline.setInspector(this.getInspector());
        basePipeline.setWidgetBuilder(this.getWidgetBuilder());
        basePipeline.setLayout(this.getLayout());
        basePipeline.mInspectionResultProcessors = this.mInspectionResultProcessors == null ? null : new ArrayList<InspectionResultProcessor<M>>(this.mInspectionResultProcessors);
        basePipeline.mWidgetProcessors = this.mWidgetProcessors == null ? null : new ArrayList<WidgetProcessor<W, M>>(this.mWidgetProcessors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildCompoundWidget(E e) throws Exception {
        E e2 = this.getFirstChildElement(e);
        int n = 0;
        while (e2 != null) {
            ++n;
            String string = this.getElementName(e2);
            if (!"property".equals(string) && !"action".equals(string)) {
                throw new Exception("Child element #" + n + " should be " + "property" + " or " + "action" + ", not " + string);
            }
            Map<String, String> map = this.getAttributesAsMap(e2);
            String string2 = map.get("name");
            if (string2 == null || "".equals(string2)) {
                throw new Exception("Child element #" + n + " has no @" + "name");
            }
            boolean bl = false;
            if (!"true".equals(map.get("read-only")) && this.isReadOnly()) {
                map.put("read-only", "true");
                bl = true;
            }
            try {
                Map<String, String> map2;
                Object object = this.buildWidget(string, map);
                if (object == null) {
                    if (this.mMaximumInspectionDepth <= 0) continue;
                    if (bl) {
                        map.remove("read-only");
                    }
                    object = this.buildNestedMetawidget(map);
                }
                if ((map2 = this.getAdditionalAttributes(object)) != null) {
                    map.putAll(map2);
                }
                if ((object = this.processWidget(object, string, map)) == null) continue;
                this.layoutWidget(object, string, map);
            }
            finally {
                e2 = this.getNextSiblingElement(e2);
            }
        }
    }

    protected abstract E stringToElement(String var1);

    protected abstract String elementToString(E var1);

    protected abstract E getFirstChildElement(E var1);

    protected abstract E getNextSiblingElement(E var1);

    protected abstract String getElementName(E var1);

    protected abstract Map<String, String> getAttributesAsMap(E var1);

    protected abstract void configure();

    protected void startBuild() {
        M m = this.getPipelineOwner();
        if (this.mWidgetBuilder instanceof AdvancedWidgetBuilder) {
            ((AdvancedWidgetBuilder)this.mWidgetBuilder).onStartBuild(m);
        }
        if (this.mWidgetProcessors != null) {
            for (WidgetProcessor<W, M> widgetProcessor : this.mWidgetProcessors) {
                if (!(widgetProcessor instanceof AdvancedWidgetProcessor)) continue;
                ((AdvancedWidgetProcessor)widgetProcessor).onStartBuild(m);
            }
        }
        if (this.mLayout instanceof AdvancedLayout) {
            AdvancedLayout advancedLayout = (AdvancedLayout)this.mLayout;
            advancedLayout.onStartBuild(m);
            advancedLayout.startContainerLayout(m, m);
        }
    }

    protected E processInspectionResult(Object object, Object object2, String string, String ... stringArray) {
        Object object3;
        Object object4 = object;
        if (this.mInspectionResultProcessors != null) {
            object3 = this.getPipelineOwner();
            for (InspectionResultProcessor<M> inspectionResultProcessor : this.mInspectionResultProcessors) {
                Object object5;
                if (inspectionResultProcessor instanceof DomInspectionResultProcessor) {
                    if (object4 instanceof String) {
                        object4 = this.stringToElement((String)object4);
                    }
                    object5 = (DomInspectionResultProcessor)inspectionResultProcessor;
                    Object object6 = object4;
                    object4 = object5.processInspectionResultAsDom(object6, object3, object2, string, stringArray);
                } else {
                    if (!(object4 instanceof String)) {
                        object5 = object4;
                        object4 = this.elementToString(object5);
                    }
                    object4 = inspectionResultProcessor.processInspectionResult((String)object4, object3, object2, string, stringArray);
                }
                if (object4 != null) continue;
                return null;
            }
        }
        if (object4 instanceof String) {
            return this.stringToElement((String)object4);
        }
        object3 = object4;
        return (E)object3;
    }

    protected abstract Map<String, String> getAdditionalAttributes(W var1);

    protected W buildWidget(String string, Map<String, String> map) {
        if (this.mWidgetBuilder == null) {
            return null;
        }
        return this.mWidgetBuilder.buildWidget(string, map, this.getPipelineOwner());
    }

    protected W processWidget(W w, String string, Map<String, String> map) {
        W w2 = w;
        if (this.mWidgetProcessors != null) {
            M m = this.getPipelineOwner();
            for (WidgetProcessor<W, M> widgetProcessor : this.mWidgetProcessors) {
                w2 = widgetProcessor.processWidget(w2, string, map, m);
                if (w2 != null) continue;
                return null;
            }
        }
        return w2;
    }

    protected abstract M buildNestedMetawidget(Map<String, String> var1) throws Exception;

    protected abstract M getPipelineOwner();

    protected void layoutWidget(W w, String string, Map<String, String> map) {
        M m = this.getPipelineOwner();
        this.mLayout.layoutWidget(w, string, map, m, m);
    }

    protected void endBuild() {
        M m = this.getPipelineOwner();
        if (this.mLayout instanceof AdvancedLayout) {
            AdvancedLayout advancedLayout = (AdvancedLayout)this.mLayout;
            advancedLayout.endContainerLayout(m, m);
            advancedLayout.onEndBuild(m);
        }
        if (this.mWidgetProcessors != null) {
            for (WidgetProcessor widgetProcessor : this.mWidgetProcessors) {
                if (!(widgetProcessor instanceof AdvancedWidgetProcessor)) continue;
                ((AdvancedWidgetProcessor)widgetProcessor).onEndBuild(m);
            }
        }
        if (this.mWidgetBuilder instanceof AdvancedWidgetBuilder) {
            ((AdvancedWidgetBuilder)this.mWidgetBuilder).onEndBuild(m);
        }
    }
}

