/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.statically;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.metawidget.statically.BaseStaticWidget;
import org.metawidget.statically.StaticUtils;
import org.metawidget.statically.StaticXmlWidget;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseStaticXmlWidget
extends BaseStaticWidget
implements StaticXmlWidget {
    private String mPrefix;
    private String mTagName;
    private String mNamespaceURI;
    private Map<String, String> mAttributes;
    private String mTextContent;
    private Map<String, String> mAdditionalNamespaceURIs;

    protected BaseStaticXmlWidget(String string, String string2, String string3) {
        this.mPrefix = string;
        this.mTagName = string2;
        this.mNamespaceURI = string3;
    }

    @Override
    public String getPrefix() {
        return this.mPrefix;
    }

    @Override
    public String getNamespaceURI() {
        return this.mNamespaceURI;
    }

    @Override
    public String getAttribute(String string) {
        if (this.mAttributes == null) {
            return null;
        }
        return this.mAttributes.get(string);
    }

    @Override
    public void putAttribute(String string, String string2) {
        if (this.mAttributes == null) {
            this.mAttributes = CollectionUtils.newTreeMap();
        }
        this.mAttributes.put(string, string2);
    }

    @Override
    public String getTextContent() {
        return this.mTextContent;
    }

    @Override
    public void setTextContent(String string) {
        this.mTextContent = string;
    }

    @Override
    public Map<String, String> getAdditionalNamespaceURIs() {
        return this.mAdditionalNamespaceURIs;
    }

    public void putAdditionalNamespaceURI(String string, String string2) {
        if (this.mAdditionalNamespaceURIs == null) {
            this.mAdditionalNamespaceURIs = CollectionUtils.newHashMap();
        }
        this.mAdditionalNamespaceURIs.put(string, string2);
    }

    @Override
    public void write(Writer writer) throws IOException {
        if (this.getChildren().isEmpty()) {
            this.writeStartTag(writer);
            if (!this.isSelfClosing()) {
                if (this.mTagName != null) {
                    writer.append(">");
                }
                if (this.mTextContent != null) {
                    writer.append(this.mTextContent);
                }
                if (writer instanceof StaticUtils.IndentedWriter) {
                    ((StaticUtils.IndentedWriter)writer).indent();
                }
                this.writeEndTag(writer);
            } else {
                if (this.mTagName != null) {
                    writer.append("/>");
                }
                if (writer instanceof StaticUtils.IndentedWriter) {
                    writer.append("\r\n");
                }
            }
        } else {
            this.writeStartTag(writer);
            if (this.mTagName != null) {
                writer.append(">");
            }
            if (writer instanceof StaticUtils.IndentedWriter) {
                writer.append("\r\n");
                ((StaticUtils.IndentedWriter)writer).indent();
            }
            super.write(writer);
            if (this.getTextContent() != null && this.getTextContent().length() > 0) {
                writer.append(this.mTextContent);
                if (writer instanceof StaticUtils.IndentedWriter) {
                    writer.append("\r\n");
                }
            }
            this.writeEndTag(writer);
        }
    }

    protected void writeAttribute(Writer writer, String string, String string2) throws IOException {
        if (string2 == null) {
            return;
        }
        writer.append(string);
        writer.append("=\"");
        writer.append(string2);
        writer.append("\"");
    }

    protected boolean isSelfClosing() {
        return this.getTextContent() == null || this.getTextContent().length() == 0;
    }

    private void writeStartTag(Writer writer) throws IOException {
        if (this.mTagName == null) {
            return;
        }
        writer.append('<');
        if (this.mPrefix != null) {
            writer.append(this.mPrefix);
            writer.append(':');
        }
        writer.append(this.mTagName);
        if (this.mAttributes != null) {
            for (Map.Entry<String, String> entry : this.mAttributes.entrySet()) {
                this.writeAttribute(new StaticUtils.LeadingSpaceWriter(writer), entry.getKey(), entry.getValue());
            }
        }
    }

    private void writeEndTag(Writer writer) throws IOException {
        if (this.mTagName == null) {
            return;
        }
        if (writer instanceof StaticUtils.IndentedWriter) {
            ((StaticUtils.IndentedWriter)writer).outdent();
        }
        writer.append("</");
        if (this.mPrefix != null) {
            writer.append(this.mPrefix);
            writer.append(':');
        }
        writer.append(this.mTagName);
        writer.append(">");
        if (writer instanceof StaticUtils.IndentedWriter) {
            writer.append("\r\n");
        }
    }
}

