/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.statically.faces;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StaticFacesUtils {
    private static final Pattern PATTERN_EXPRESSION = Pattern.compile("(#|\\$)\\{([^\\}]+)\\}");
    private static final String EXPRESSION_START = "#{";
    private static final String EXPRESSION_END = "}";

    public static boolean isExpression(String string) {
        return StaticFacesUtils.matchExpression(string).matches();
    }

    public static Matcher matchExpression(String string) {
        return PATTERN_EXPRESSION.matcher(string);
    }

    public static String unwrapExpression(String string) {
        Matcher matcher = PATTERN_EXPRESSION.matcher(string);
        if (!matcher.matches()) {
            return string;
        }
        return matcher.group(2);
    }

    public static String wrapExpression(String string) {
        if (StaticFacesUtils.isExpression(string)) {
            return string;
        }
        return EXPRESSION_START + StaticFacesUtils.unwrapExpression(string) + EXPRESSION_END;
    }

    private StaticFacesUtils() {
    }
}

