/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.statically.faces.component.html.widgetbuilder;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.metawidget.statically.BaseStaticWidget;
import org.metawidget.statically.BaseStaticXmlWidget;
import org.metawidget.statically.StaticMetawidget;
import org.metawidget.statically.StaticWidget;
import org.metawidget.statically.StaticXmlMetawidget;
import org.metawidget.statically.StaticXmlStub;
import org.metawidget.statically.StaticXmlWidget;
import org.metawidget.statically.faces.StaticFacesUtils;
import org.metawidget.statically.faces.component.html.StaticHtmlMetawidget;
import org.metawidget.statically.faces.component.html.widgetbuilder.Facet;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlColumn;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlDataTable;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlInputSecret;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlInputText;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlInputTextarea;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlOutputText;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlSelectBooleanCheckbox;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlSelectOneMenu;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlWidgetBuilderConfig;
import org.metawidget.statically.faces.component.html.widgetbuilder.SelectItem;
import org.metawidget.statically.faces.component.html.widgetbuilder.SelectItems;
import org.metawidget.statically.layout.SimpleLayout;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlWidgetBuilder
implements WidgetBuilder<StaticXmlWidget, StaticXmlMetawidget> {
    private static final String MAX_LENGTH = "maxLength";
    private final int mMaximumColumnsInDataTable;

    public HtmlWidgetBuilder() {
        this(new HtmlWidgetBuilderConfig());
    }

    public HtmlWidgetBuilder(HtmlWidgetBuilderConfig htmlWidgetBuilderConfig) {
        this.mMaximumColumnsInDataTable = htmlWidgetBuilderConfig.getMaximumColumnsInDataTable();
    }

    @Override
    public StaticXmlWidget buildWidget(String string, Map<String, String> map, StaticXmlMetawidget staticXmlMetawidget) {
        if ("true".equals(map.get("hidden"))) {
            return new StaticXmlStub();
        }
        if ("action".equals(string)) {
            return new StaticXmlStub();
        }
        String string2 = map.get("faces-lookup");
        if (string2 != null && !"".equals(string2)) {
            HtmlSelectOneMenu htmlSelectOneMenu = new HtmlSelectOneMenu();
            this.addSelectItems(htmlSelectOneMenu, string2, map);
            return htmlSelectOneMenu;
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(map, String.class);
        String string3 = map.get("lookup");
        if (string3 != null && !"".equals(string3)) {
            HtmlSelectOneMenu htmlSelectOneMenu = new HtmlSelectOneMenu();
            this.addSelectItems(htmlSelectOneMenu, CollectionUtils.fromString(string3), CollectionUtils.fromString(map.get("lookup-labels")), map);
            return htmlSelectOneMenu;
        }
        if (Boolean.class.equals(clazz) && "true".equals(map.get("required"))) {
            return new HtmlSelectBooleanCheckbox();
        }
        if (clazz != null) {
            if (Boolean.TYPE.equals(clazz)) {
                return new HtmlSelectBooleanCheckbox();
            }
            if (Character.TYPE.equals(clazz)) {
                HtmlInputText htmlInputText = new HtmlInputText();
                htmlInputText.putAttribute(MAX_LENGTH, "1");
                return htmlInputText;
            }
            if (clazz.isPrimitive()) {
                return this.createHtmlInputText(map);
            }
            if (String.class.equals(clazz)) {
                if ("true".equals(map.get("large"))) {
                    return new HtmlInputTextarea();
                }
                if ("true".equals(map.get("masked"))) {
                    HtmlInputSecret htmlInputSecret = new HtmlInputSecret();
                    htmlInputSecret.putAttribute(MAX_LENGTH, map.get("maximum-length"));
                    return htmlInputSecret;
                }
                return this.createHtmlInputText(map);
            }
            if (Character.class.equals(clazz)) {
                HtmlInputText htmlInputText = new HtmlInputText();
                htmlInputText.putAttribute(MAX_LENGTH, "1");
                return htmlInputText;
            }
            if (Date.class.equals(clazz)) {
                return this.createHtmlInputText(map);
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return this.createHtmlInputText(map);
            }
            if (List.class.isAssignableFrom(clazz) || clazz.isArray()) {
                return this.createDataTableComponent(string, map, staticXmlMetawidget);
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new StaticXmlStub();
            }
        }
        if ("true".equals(map.get("dont-expand"))) {
            return this.createHtmlInputText(map);
        }
        return null;
    }

    protected StaticXmlWidget createDataTableComponent(String string, Map<String, String> map, StaticXmlMetawidget staticXmlMetawidget) {
        Object object;
        NodeList nodeList;
        HtmlDataTable htmlDataTable = new HtmlDataTable();
        String string2 = "_item";
        htmlDataTable.putAttribute("var", string2);
        String string3 = WidgetBuilderUtils.getComponentType(map);
        String string4 = null;
        if (string3 != null) {
            string4 = staticXmlMetawidget.inspect(null, string3, new String[0]);
        }
        if (string4 == null) {
            nodeList = null;
        } else {
            object = XmlUtils.documentFromString(string4).getDocumentElement();
            nodeList = object.getFirstChild().getChildNodes();
        }
        if (nodeList == null || nodeList.getLength() == 0) {
            object = CollectionUtils.newHashMap();
            object.put("name", map.get("name"));
            this.addColumnComponent(htmlDataTable, map, "entity", (Map<String, String>)object, staticXmlMetawidget);
        } else {
            this.addColumnComponents(htmlDataTable, map, nodeList, staticXmlMetawidget);
        }
        return htmlDataTable;
    }

    protected void addColumnComponents(HtmlDataTable htmlDataTable, Map<String, String> map, NodeList nodeList, StaticXmlMetawidget staticXmlMetawidget) {
        boolean bl = true;
        while (true) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element;
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || "action".equals((element = (Element)node).getNodeName()) || "true".equals(element.getAttribute("hidden")) || bl && !"true".equals(element.getAttribute("required"))) continue;
                this.addColumnComponent(htmlDataTable, map, "property", XmlUtils.getAttributesAsMap(element), staticXmlMetawidget);
                if (htmlDataTable.getChildren().size() == this.mMaximumColumnsInDataTable) break;
            }
            if (!htmlDataTable.getChildren().isEmpty() || !bl) break;
            bl = false;
        }
    }

    protected void addColumnComponent(HtmlDataTable htmlDataTable, Map<String, String> map, String string, Map<String, String> map2, StaticXmlMetawidget staticXmlMetawidget) {
        BaseStaticWidget baseStaticWidget;
        Object object;
        BaseStaticWidget baseStaticWidget2;
        HtmlColumn htmlColumn = new HtmlColumn();
        if ("entity".equals(string)) {
            baseStaticWidget2 = new HtmlOutputText();
            baseStaticWidget2.putAttribute("value", StaticFacesUtils.wrapExpression(htmlDataTable.getAttribute("var")));
        } else {
            baseStaticWidget2 = new StaticHtmlMetawidget();
            object = htmlDataTable.getAttribute("var") + '.' + StringUtils.decapitalize(map2.get("name"));
            baseStaticWidget2.putAttribute("value", StaticFacesUtils.wrapExpression((String)object));
            baseStaticWidget = (StaticHtmlMetawidget)baseStaticWidget2;
            ((StaticMetawidget)baseStaticWidget).setPath(WidgetBuilderUtils.getComponentType(map) + '/' + map2.get("name"));
            staticXmlMetawidget.initNestedMetawidget((StaticMetawidget)baseStaticWidget, map2);
            ((StaticMetawidget)baseStaticWidget).setLayout(new SimpleLayout());
            ((StaticMetawidget)baseStaticWidget).setReadOnly(true);
        }
        htmlColumn.getChildren().add(baseStaticWidget2);
        object = new HtmlOutputText();
        ((BaseStaticXmlWidget)object).putAttribute("value", staticXmlMetawidget.getLabelString(map2));
        baseStaticWidget = new Facet();
        ((BaseStaticXmlWidget)baseStaticWidget).putAttribute("name", "header");
        baseStaticWidget.getChildren().add((StaticWidget)object);
        htmlColumn.getChildren().add(0, baseStaticWidget);
        htmlDataTable.getChildren().add(htmlColumn);
    }

    protected void addSelectItems(HtmlSelectOneMenu htmlSelectOneMenu, String string, Map<String, String> map) {
        if (WidgetBuilderUtils.needsEmptyLookupItem(map)) {
            this.addSelectItem(htmlSelectOneMenu, null, null);
        }
        SelectItems selectItems = new SelectItems();
        selectItems.putAttribute("value", string);
        htmlSelectOneMenu.getChildren().add(selectItems);
    }

    private HtmlInputText createHtmlInputText(Map<String, String> map) {
        HtmlInputText htmlInputText = new HtmlInputText();
        if (!"".equals(map.get("maximum-length"))) {
            htmlInputText.putAttribute(MAX_LENGTH, map.get("maximum-length"));
        }
        return htmlInputText;
    }

    private void addSelectItems(HtmlSelectOneMenu htmlSelectOneMenu, List<String> list, List<String> list2, Map<String, String> map) {
        if (list == null) {
            return;
        }
        if (WidgetBuilderUtils.needsEmptyLookupItem(map)) {
            this.addSelectItem(htmlSelectOneMenu, null, null);
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            String string2 = null;
            if (list2 != null && !list2.isEmpty()) {
                string2 = list2.get(i);
            }
            this.addSelectItem(htmlSelectOneMenu, string, string2);
        }
    }

    private void addSelectItem(HtmlSelectOneMenu htmlSelectOneMenu, String string, String string2) {
        SelectItem selectItem = new SelectItem();
        selectItem.putAttribute("itemLabel", string2);
        selectItem.putAttribute("itemValue", string);
        htmlSelectOneMenu.getChildren().add(selectItem);
    }
}

