/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.statically.html.layout;

import java.util.Map;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.layout.iface.LayoutException;
import org.metawidget.statically.StaticXmlStub;
import org.metawidget.statically.StaticXmlWidget;
import org.metawidget.statically.html.StaticHtmlMetawidget;
import org.metawidget.statically.html.layout.HtmlLayout;
import org.metawidget.statically.html.layout.HtmlTableLayoutConfig;
import org.metawidget.statically.html.widgetbuilder.HtmlTable;
import org.metawidget.statically.html.widgetbuilder.HtmlTableBody;
import org.metawidget.statically.html.widgetbuilder.HtmlTableCell;
import org.metawidget.statically.html.widgetbuilder.HtmlTableHeader;
import org.metawidget.statically.html.widgetbuilder.HtmlTableRow;
import org.metawidget.statically.html.widgetbuilder.HtmlTag;
import org.metawidget.util.WidgetBuilderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTableLayout
extends HtmlLayout
implements AdvancedLayout<StaticXmlWidget, StaticXmlWidget, StaticHtmlMetawidget> {
    private String mTableStyle;
    private String mTableStyleClass;
    private String mLabelColumnClass;
    private String mComponentColumnClass;
    private String mRequiredColumnClass;

    public HtmlTableLayout() {
        this(new HtmlTableLayoutConfig());
    }

    public HtmlTableLayout(HtmlTableLayoutConfig htmlTableLayoutConfig) {
        this.mTableStyle = htmlTableLayoutConfig.getTableStyle();
        this.mTableStyleClass = htmlTableLayoutConfig.getTableStyleClass();
        this.mLabelColumnClass = htmlTableLayoutConfig.getLabelColumnStyleClass();
        this.mComponentColumnClass = htmlTableLayoutConfig.getComponentColumnStyleClass();
        this.mRequiredColumnClass = htmlTableLayoutConfig.getRequiredColumnStyleClass();
    }

    @Override
    public void onStartBuild(StaticHtmlMetawidget staticHtmlMetawidget) {
    }

    @Override
    public void startContainerLayout(StaticXmlWidget staticXmlWidget, StaticHtmlMetawidget staticHtmlMetawidget) {
        try {
            HtmlTable htmlTable = new HtmlTable();
            htmlTable.setId(staticHtmlMetawidget.getId());
            if (this.mTableStyle != null) {
                htmlTable.putAttribute("style", this.mTableStyle);
            }
            if (this.mTableStyleClass != null) {
                htmlTable.putAttribute("class", this.mTableStyleClass);
            }
            htmlTable.getChildren().add(new HtmlTableBody());
            staticXmlWidget.getChildren().add(htmlTable);
        }
        catch (Exception exception) {
            throw LayoutException.newException(exception);
        }
    }

    @Override
    public void layoutWidget(StaticXmlWidget staticXmlWidget, String string, Map<String, String> map, StaticXmlWidget staticXmlWidget2, StaticHtmlMetawidget staticHtmlMetawidget) {
        try {
            if (staticXmlWidget instanceof StaticXmlStub && staticXmlWidget.getChildren().isEmpty()) {
                return;
            }
            HtmlTableBody htmlTableBody = (HtmlTableBody)staticXmlWidget2.getChildren().get(0).getChildren().get(0);
            HtmlTableRow htmlTableRow = new HtmlTableRow();
            this.layoutLabel(htmlTableRow, staticXmlWidget, string, map, staticHtmlMetawidget);
            HtmlTableCell htmlTableCell = new HtmlTableCell();
            htmlTableCell.getChildren().add(staticXmlWidget);
            htmlTableCell.putAttribute("class", this.mComponentColumnClass);
            htmlTableRow.getChildren().add(htmlTableCell);
            HtmlTableCell htmlTableCell2 = new HtmlTableCell();
            htmlTableCell2.putAttribute("class", this.mRequiredColumnClass);
            if ("true".equals(map.get("required")) && !WidgetBuilderUtils.isReadOnly(map) && !"true".equals(map.get("hidden"))) {
                htmlTableCell2.setTextContent("*");
            }
            htmlTableRow.getChildren().add(htmlTableCell2);
            htmlTableBody.getChildren().add(htmlTableRow);
        }
        catch (Exception exception) {
            throw LayoutException.newException(exception);
        }
    }

    @Override
    public void endContainerLayout(StaticXmlWidget staticXmlWidget, StaticHtmlMetawidget staticHtmlMetawidget) {
    }

    @Override
    public void onEndBuild(StaticHtmlMetawidget staticHtmlMetawidget) {
    }

    @Override
    protected boolean layoutLabel(HtmlTag htmlTag, StaticXmlWidget staticXmlWidget, String string, Map<String, String> map, StaticHtmlMetawidget staticHtmlMetawidget) {
        HtmlTableHeader htmlTableHeader = new HtmlTableHeader();
        htmlTableHeader.putAttribute("class", this.mLabelColumnClass);
        htmlTag.getChildren().add(htmlTableHeader);
        return super.layoutLabel(htmlTableHeader, staticXmlWidget, string, map, staticHtmlMetawidget);
    }
}

