/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.statically.html.widgetbuilder;

import java.awt.Color;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.metawidget.statically.StaticXmlMetawidget;
import org.metawidget.statically.StaticXmlStub;
import org.metawidget.statically.StaticXmlWidget;
import org.metawidget.statically.html.StaticHtmlMetawidget;
import org.metawidget.statically.html.widgetbuilder.HtmlInput;
import org.metawidget.statically.html.widgetbuilder.HtmlOption;
import org.metawidget.statically.html.widgetbuilder.HtmlSelect;
import org.metawidget.statically.html.widgetbuilder.HtmlTable;
import org.metawidget.statically.html.widgetbuilder.HtmlTableBody;
import org.metawidget.statically.html.widgetbuilder.HtmlTableHead;
import org.metawidget.statically.html.widgetbuilder.HtmlTableHeader;
import org.metawidget.statically.html.widgetbuilder.HtmlTableRow;
import org.metawidget.statically.html.widgetbuilder.HtmlTextarea;
import org.metawidget.statically.html.widgetbuilder.HtmlWidgetBuilderConfig;
import org.metawidget.statically.html.widgetprocessor.IdProcessor;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlWidgetBuilder
implements WidgetBuilder<StaticXmlWidget, StaticHtmlMetawidget> {
    private final int mMaximumColumnsInDataTable;

    public HtmlWidgetBuilder() {
        this(new HtmlWidgetBuilderConfig());
    }

    public HtmlWidgetBuilder(HtmlWidgetBuilderConfig htmlWidgetBuilderConfig) {
        this.mMaximumColumnsInDataTable = htmlWidgetBuilderConfig.getMaximumColumnsInDataTable();
    }

    @Override
    public StaticXmlWidget buildWidget(String string, Map<String, String> map, StaticHtmlMetawidget staticHtmlMetawidget) {
        if ("true".equals(map.get("hidden"))) {
            return new StaticXmlStub();
        }
        if ("action".equals(string)) {
            return new StaticXmlStub();
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(map, String.class);
        if (Boolean.class.equals(clazz) && "true".equals(map.get("required"))) {
            return this.createHtmlCheckbox();
        }
        String string2 = map.get("lookup");
        if (string2 != null && !"".equals(string2)) {
            HtmlSelect htmlSelect = new HtmlSelect();
            this.addSelectItems(htmlSelect, CollectionUtils.fromString(string2), CollectionUtils.fromString(map.get("lookup-labels")), map);
            return htmlSelect;
        }
        if (clazz != null) {
            String string3 = map.get("minimum-value");
            String string4 = map.get("maximum-value");
            if (clazz.isPrimitive()) {
                if (Boolean.TYPE.equals(clazz)) {
                    return this.createHtmlCheckbox();
                }
                if (Character.TYPE.equals(clazz)) {
                    map.put("maximum-length", "1");
                    HtmlInput htmlInput = this.createHtmlInputText(map);
                    return htmlInput;
                }
                HtmlInput htmlInput = this.createHtmlInputNumber();
                if (!"".equals(string3)) {
                    htmlInput.putAttribute("min", string3);
                }
                if (!"".equals(string4)) {
                    htmlInput.putAttribute("max", string4);
                }
                return htmlInput;
            }
            if (String.class.equals(clazz)) {
                if ("true".equals(map.get("large"))) {
                    return this.createHtmlTextareaTag(map);
                }
                if ("true".equals(map.get("masked"))) {
                    HtmlInput htmlInput = this.createHtmlInputText(map);
                    htmlInput.putAttribute("type", "secret");
                    return htmlInput;
                }
                if ("true".equals(map.get("validation-email"))) {
                    HtmlInput htmlInput = this.createHtmlInputText(map);
                    htmlInput.putAttribute("type", "email");
                    return htmlInput;
                }
                HtmlInput htmlInput = this.createHtmlInputText(map);
                htmlInput.putAttribute("pattern", map.get("validation-pattern"));
                return htmlInput;
            }
            if (Character.class.equals(clazz)) {
                map.put("maximum-length", "1");
                HtmlInput htmlInput = this.createHtmlInputText(map);
                return htmlInput;
            }
            if (Date.class.equals(clazz)) {
                return this.createHtmlInputDate();
            }
            if (Number.class.isAssignableFrom(clazz)) {
                HtmlInput htmlInput = this.createHtmlInputNumber();
                if (string3 != null) {
                    htmlInput.putAttribute("min", string3);
                }
                if (string4 != null) {
                    htmlInput.putAttribute("max", string4);
                }
                return htmlInput;
            }
            if (Color.class.equals(clazz)) {
                return this.createHtmlInputColor();
            }
            if (Collection.class.isAssignableFrom(clazz) || clazz.isArray()) {
                return this.createDataTableComponent(string, map, staticHtmlMetawidget);
            }
        }
        if ("true".equals(map.get("dont-expand"))) {
            return this.createHtmlInputText(map);
        }
        return null;
    }

    protected StaticXmlWidget createDataTableComponent(String string, Map<String, String> map, StaticHtmlMetawidget staticHtmlMetawidget) {
        HtmlTable htmlTable = new HtmlTable();
        HtmlTableHead htmlTableHead = new HtmlTableHead();
        htmlTable.getChildren().add(htmlTableHead);
        htmlTableHead.getChildren().add(new HtmlTableRow());
        HtmlTableBody htmlTableBody = new HtmlTableBody();
        htmlTable.getChildren().add(htmlTableBody);
        String string2 = WidgetBuilderUtils.getComponentType(map);
        String string3 = null;
        if (string2 != null) {
            string3 = staticHtmlMetawidget.inspect(null, string2, null);
        }
        if (string3 == null) {
            HashMap<String, String> hashMap = CollectionUtils.newHashMap();
            hashMap.put("name", map.get("name"));
            this.addColumnHeader(htmlTable, hashMap, staticHtmlMetawidget);
        } else {
            IdProcessor idProcessor = staticHtmlMetawidget.getWidgetProcessor(IdProcessor.class);
            if (idProcessor != null) {
                idProcessor.processWidget(htmlTable, string, map, staticHtmlMetawidget);
            }
            Element element = XmlUtils.documentFromString(string3).getDocumentElement();
            NodeList nodeList = element.getFirstChild().getChildNodes();
            this.addColumnComponents(htmlTable, nodeList, staticHtmlMetawidget);
        }
        return htmlTable;
    }

    protected void addColumnComponents(HtmlTable htmlTable, NodeList nodeList, StaticXmlMetawidget staticXmlMetawidget) {
        boolean bl = true;
        HtmlTableRow htmlTableRow = (HtmlTableRow)htmlTable.getChildren().get(0).getChildren().get(0);
        while (true) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element;
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || "action".equals((element = (Element)node).getNodeName()) || "true".equals(element.getAttribute("hidden")) || bl && !"true".equals(element.getAttribute("required"))) continue;
                this.addColumnHeader(htmlTable, XmlUtils.getAttributesAsMap(element), staticXmlMetawidget);
                if (htmlTableRow.getChildren().size() == this.mMaximumColumnsInDataTable) break;
            }
            if (!htmlTableRow.getChildren().isEmpty() || !bl) break;
            bl = false;
        }
    }

    protected void addColumnHeader(HtmlTable htmlTable, Map<String, String> map, StaticXmlMetawidget staticXmlMetawidget) {
        HtmlTableHeader htmlTableHeader = new HtmlTableHeader();
        String string = map.get("name");
        String string2 = htmlTable.getAttribute("id");
        if (string2 != null) {
            string = string2 + '-' + string;
        }
        htmlTableHeader.putAttribute("id", string);
        htmlTableHeader.setTextContent(staticXmlMetawidget.getLabelString(map));
        htmlTable.getChildren().get(0).getChildren().get(0).getChildren().add(htmlTableHeader);
    }

    protected void addSelectItems(HtmlSelect htmlSelect, String string, Map<String, String> map) {
        if (WidgetBuilderUtils.needsEmptyLookupItem(map)) {
            this.addSelectItem(htmlSelect, "", null);
        }
        this.addSelectItem(htmlSelect, string, null);
    }

    protected void addSelectItems(HtmlSelect htmlSelect, List<String> list, List<String> list2, Map<String, String> map) {
        if (list == null) {
            return;
        }
        if (WidgetBuilderUtils.needsEmptyLookupItem(map)) {
            this.addSelectItem(htmlSelect, "", null);
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            String string2 = null;
            if (list2 != null && !list2.isEmpty()) {
                string2 = list2.get(i);
            }
            this.addSelectItem(htmlSelect, string, string2);
        }
    }

    private HtmlInput createHtmlInputText(Map<String, String> map) {
        HtmlInput htmlInput = new HtmlInput();
        htmlInput.putAttribute("type", "text");
        if (!"".equals(map.get("maximum-length"))) {
            htmlInput.putAttribute("maxlength", map.get("maximum-length"));
        }
        return htmlInput;
    }

    private StaticXmlWidget createHtmlCheckbox() {
        HtmlInput htmlInput = new HtmlInput();
        htmlInput.putAttribute("type", "checkbox");
        return htmlInput;
    }

    private HtmlInput createHtmlInputDate() {
        HtmlInput htmlInput = new HtmlInput();
        htmlInput.putAttribute("type", "date");
        return htmlInput;
    }

    private HtmlInput createHtmlInputNumber() {
        HtmlInput htmlInput = new HtmlInput();
        htmlInput.putAttribute("type", "number");
        return htmlInput;
    }

    private HtmlInput createHtmlInputColor() {
        HtmlInput htmlInput = new HtmlInput();
        htmlInput.putAttribute("type", "color");
        return htmlInput;
    }

    private StaticXmlWidget createHtmlTextareaTag(Map<String, String> map) {
        String string;
        HtmlTextarea htmlTextarea = new HtmlTextarea();
        String string2 = map.get("cols");
        if (string2 != null) {
            htmlTextarea.putAttribute("cols", string2);
        }
        if ((string = map.get("rows")) != null) {
            htmlTextarea.putAttribute("rows", string);
        }
        return htmlTextarea;
    }

    private void addSelectItem(HtmlSelect htmlSelect, String string, String string2) {
        HtmlOption htmlOption = new HtmlOption();
        htmlOption.putAttribute("value", string);
        if (string2 != null) {
            htmlOption.setTextContent(string2);
        }
        htmlSelect.getChildren().add(htmlOption);
    }
}

