/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.beans.Beans;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.metawidget.iface.Immutable;
import org.metawidget.iface.MetawidgetException;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessor;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.layout.iface.Layout;
import org.metawidget.pipeline.w3c.W3CPipeline;
import org.metawidget.swing.Facet;
import org.metawidget.swing.Stub;
import org.metawidget.swing.SwingValuePropertyProvider;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetbuilder.composite.CompositeWidgetBuilder;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingMetawidget
extends JComponent {
    private static final Stroke STROKE_DOTTED = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{3.0f}, 0.0f);
    private Object mToInspect;
    private String mPath;
    private ResourceBundle mBundle;
    private boolean mNeedToBuildWidgets;
    private Element mLastInspectionResult;
    private boolean mIgnoreAddRemove;
    private List<JComponent> mExistingComponents = CollectionUtils.newArrayList();
    private List<JComponent> mExistingUnusedComponents;
    private Map<String, Facet> mFacets = CollectionUtils.newHashMap();
    Pipeline mPipeline = this.newPipeline();

    public void setToInspect(Object object) {
        this.updateToInspectWithoutInvalidate(object);
        this.invalidateInspection();
    }

    public void updateToInspectWithoutInvalidate(Object object) {
        if (this.mToInspect == null) {
            if (this.mPath == null && object != null) {
                this.mPath = object.getClass().getName();
            }
        } else if (this.mToInspect.getClass().getName().equals(this.mPath)) {
            this.mPath = object == null ? null : object.getClass().getName();
        }
        this.mToInspect = object;
    }

    public <T> T getToInspect() {
        return (T)this.mToInspect;
    }

    public void setPath(String string) {
        this.mPath = string;
        this.invalidateInspection();
    }

    public String getPath() {
        return this.mPath;
    }

    public void setConfig(String string) {
        this.mPipeline.setConfig(string);
        this.invalidateInspection();
    }

    public void setInspector(Inspector inspector) {
        this.mPipeline.setInspector(inspector);
        this.invalidateInspection();
    }

    public String inspect(Object object, String string, String ... stringArray) {
        return this.mPipeline.inspect(object, string, stringArray);
    }

    public void addInspectionResultProcessor(InspectionResultProcessor<SwingMetawidget> inspectionResultProcessor) {
        this.mPipeline.addInspectionResultProcessor(inspectionResultProcessor);
        this.invalidateInspection();
    }

    public void removeInspectionResultProcessor(InspectionResultProcessor<SwingMetawidget> inspectionResultProcessor) {
        this.mPipeline.removeInspectionResultProcessor(inspectionResultProcessor);
        this.invalidateInspection();
    }

    public void setInspectionResultProcessors(InspectionResultProcessor<SwingMetawidget> ... inspectionResultProcessorArray) {
        this.mPipeline.setInspectionResultProcessors(inspectionResultProcessorArray);
        this.invalidateInspection();
    }

    public void setWidgetBuilder(WidgetBuilder<JComponent, SwingMetawidget> widgetBuilder) {
        this.mPipeline.setWidgetBuilder(widgetBuilder);
        this.invalidateWidgets();
    }

    public WidgetBuilder<JComponent, SwingMetawidget> getWidgetBuilder() {
        this.buildWidgets();
        return this.mPipeline.getWidgetBuilder();
    }

    public void addWidgetProcessor(WidgetProcessor<JComponent, SwingMetawidget> widgetProcessor) {
        this.mPipeline.addWidgetProcessor(widgetProcessor);
        this.invalidateWidgets();
    }

    public void removeWidgetProcessor(WidgetProcessor<JComponent, SwingMetawidget> widgetProcessor) {
        this.mPipeline.removeWidgetProcessor(widgetProcessor);
        this.invalidateWidgets();
    }

    public void setWidgetProcessors(WidgetProcessor<JComponent, SwingMetawidget> ... widgetProcessorArray) {
        this.mPipeline.setWidgetProcessors(widgetProcessorArray);
        this.invalidateWidgets();
    }

    public <T> T getWidgetProcessor(Class<T> clazz) {
        this.buildWidgets();
        return this.mPipeline.getWidgetProcessor(clazz);
    }

    public void setMetawidgetLayout(Layout<JComponent, JComponent, SwingMetawidget> layout) {
        this.mPipeline.setLayout(layout);
        this.invalidateWidgets();
    }

    public Layout<JComponent, JComponent, SwingMetawidget> getMetawidgetLayout() {
        this.buildWidgets();
        return this.mPipeline.getLayout();
    }

    public void setBundle(ResourceBundle resourceBundle) {
        this.mBundle = resourceBundle;
        this.invalidateWidgets();
    }

    public String getLabelString(Map<String, String> map) {
        if (map == null) {
            return "";
        }
        String string = map.get("label");
        if (string != null) {
            if ("".equals(string)) {
                return null;
            }
            String string2 = this.getLocalizedKey(StringUtils.camelCase(string));
            if (string2 != null) {
                return string2.trim();
            }
            return string.trim();
        }
        String string3 = map.get("name");
        if (string3 != null) {
            String string4 = this.getLocalizedKey(string3);
            if (string4 != null) {
                return string4.trim();
            }
            return StringUtils.uncamelCase(string3);
        }
        return "";
    }

    public String getLocalizedKey(String string) {
        if (this.mBundle == null) {
            return null;
        }
        try {
            return this.mBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "???" + string + "???";
        }
    }

    public boolean isReadOnly() {
        return this.mPipeline.isReadOnly();
    }

    public void setReadOnly(boolean bl) {
        if (this.mPipeline.isReadOnly() == bl) {
            return;
        }
        this.mPipeline.setReadOnly(bl);
        this.invalidateWidgets();
    }

    public int getMaximumInspectionDepth() {
        return this.mPipeline.getMaximumInspectionDepth();
    }

    public void setMaximumInspectionDepth(int n) {
        this.mPipeline.setMaximumInspectionDepth(n);
        this.invalidateWidgets();
    }

    public List<JComponent> fetchExistingUnusedComponents() {
        return this.mExistingUnusedComponents;
    }

    @Override
    public Dimension getPreferredSize() {
        this.buildWidgets();
        return super.getPreferredSize();
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.buildWidgets();
        super.setBounds(rectangle);
    }

    @Override
    public Rectangle getBounds(Rectangle rectangle) {
        this.buildWidgets();
        return super.getBounds(rectangle);
    }

    @Override
    public Component getComponent(int n) {
        this.buildWidgets();
        return super.getComponent(n);
    }

    @Override
    public Component[] getComponents() {
        this.buildWidgets();
        return super.getComponents();
    }

    @Override
    public int getComponentCount() {
        this.buildWidgets();
        return super.getComponentCount();
    }

    @Override
    public LayoutManager getLayout() {
        this.buildWidgets();
        return super.getLayout();
    }

    @Override
    public void addNotify() {
        this.buildWidgets();
        super.addNotify();
    }

    public <T> T getValue(String ... stringArray) {
        ComponentAndValueProperty componentAndValueProperty = this.getComponentAndValueProperty(stringArray);
        return ClassUtils.getProperty(componentAndValueProperty.getComponent(), componentAndValueProperty.getValueProperty());
    }

    public void setValue(Object object, String ... stringArray) {
        ComponentAndValueProperty componentAndValueProperty = this.getComponentAndValueProperty(stringArray);
        ClassUtils.setProperty(componentAndValueProperty.getComponent(), componentAndValueProperty.getValueProperty(), object);
    }

    public String getValueProperty(Component component) {
        return this.getValueProperty(component, this.mPipeline.getWidgetBuilder());
    }

    public <T extends Component> T getComponent(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Component component = this;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (component instanceof SwingMetawidget) {
                component.buildWidgets();
            }
            component = this.getComponent((Container)component, string);
            if (i == n - 1) {
                return (T)component;
            }
            if (component != null) continue;
            throw MetawidgetException.newException("No such component '" + string + "' of '" + ArrayUtils.toString(stringArray, "', '") + "'");
        }
        return (T)component;
    }

    public Facet getFacet(String string) {
        this.buildWidgets();
        return this.mFacets.get(string);
    }

    @Override
    public void remove(Component component) {
        super.remove(component);
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
            if (component instanceof Facet) {
                this.mFacets.remove(((Facet)component).getName());
            } else {
                this.mExistingComponents.remove(component);
            }
        }
    }

    @Override
    public void remove(int n) {
        Component component = this.getComponent(n);
        super.remove(n);
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
            if (component instanceof Facet) {
                this.mFacets.remove(((Facet)component).getName());
            } else {
                this.mExistingComponents.remove(component);
            }
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
            this.mFacets.clear();
            this.mExistingComponents.clear();
        }
    }

    public void initNestedMetawidget(SwingMetawidget swingMetawidget, Map<String, String> map) {
        this.mPipeline.initNestedPipeline(swingMetawidget.mPipeline, map);
        swingMetawidget.setPath(this.mPath + '/' + map.get("name"));
        swingMetawidget.setBundle(this.mBundle);
        swingMetawidget.setOpaque(this.isOpaque());
        swingMetawidget.setToInspect(this.mToInspect);
    }

    protected Pipeline newPipeline() {
        return new Pipeline();
    }

    protected String getDefaultConfiguration() {
        return ClassUtils.getPackagesAsFolderNames(SwingMetawidget.class) + "/metawidget-swing-default.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        this.buildWidgets();
        super.paintComponent(graphics);
        if (Beans.isDesignTime()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = graphics2D.getStroke();
            try {
                graphics2D.setStroke(STROKE_DOTTED);
                int n = this.getHeight();
                graphics2D.drawRect(0, 0, this.getWidth() - 1, n - 1);
                graphics2D.drawString("Metawidget", 10, n / 2);
            }
            finally {
                graphics2D.setStroke(stroke);
            }
        }
    }

    protected void invalidateInspection() {
        this.mLastInspectionResult = null;
        this.invalidateWidgets();
    }

    protected void invalidateWidgets() {
        if (this.mNeedToBuildWidgets) {
            return;
        }
        super.removeAll();
        this.mNeedToBuildWidgets = true;
        this.repaint();
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
            if (component instanceof Facet) {
                this.mFacets.put(component.getName(), (Facet)component);
                return;
            }
            if (component instanceof JComponent) {
                this.mExistingComponents.add((JComponent)component);
            }
        }
        super.addImpl(component, object, n);
    }

    protected void buildWidgets() {
        if (!this.mNeedToBuildWidgets || Beans.isDesignTime()) {
            return;
        }
        this.mPipeline.configureOnce();
        this.mNeedToBuildWidgets = false;
        this.mIgnoreAddRemove = true;
        try {
            if (this.mLastInspectionResult == null) {
                this.mLastInspectionResult = this.inspect();
            }
            this.mPipeline.buildWidgets(this.mLastInspectionResult);
        }
        catch (Exception exception) {
            throw MetawidgetException.newException(exception);
        }
        finally {
            this.mIgnoreAddRemove = false;
        }
    }

    protected void startBuild() {
        this.mExistingUnusedComponents = CollectionUtils.newArrayList(this.mExistingComponents);
    }

    protected void layoutWidget(Component component, String string, Map<String, String> map) {
        component.setName(map.get("name"));
        this.remove(component);
        Map<String, String> map2 = this.mPipeline.getAdditionalAttributes((JComponent)component);
        if (map2 != null) {
            map.putAll(map2);
        }
    }

    protected void endBuild() {
        if (this.mExistingUnusedComponents != null) {
            for (JComponent jComponent : this.mExistingUnusedComponents) {
                if (jComponent instanceof Facet) continue;
                HashMap<String, String> hashMap = CollectionUtils.newHashMap();
                hashMap.put("section", "");
                this.mPipeline.layoutWidget(jComponent, "property", (Map<String, String>)hashMap);
            }
        }
    }

    private Element inspect() {
        if (this.mPath == null) {
            return null;
        }
        PathUtils.TypeAndNames typeAndNames = PathUtils.parsePath(this.mPath);
        return (Element)this.mPipeline.inspectAsDom(this.mToInspect, typeAndNames.getType(), typeAndNames.getNamesAsArray());
    }

    private ComponentAndValueProperty getComponentAndValueProperty(String ... stringArray) {
        String string;
        Object object = this.getComponent(stringArray);
        if (object == null) {
            throw MetawidgetException.newException("No component named '" + ArrayUtils.toString(stringArray, "', '") + "'");
        }
        if (object instanceof JScrollPane) {
            object = ((JScrollPane)object).getViewport().getView();
        }
        if ((string = this.getValueProperty((Component)object)) == null) {
            throw MetawidgetException.newException("Don't know how to getValue from a " + object.getClass().getName());
        }
        return new ComponentAndValueProperty((Component)object, string);
    }

    private String getValueProperty(Component component, WidgetBuilder<JComponent, SwingMetawidget> widgetBuilder) {
        try {
            if (widgetBuilder instanceof CompositeWidgetBuilder) {
                for (WidgetBuilder<JComponent, SwingMetawidget> widgetBuilder2 : ((CompositeWidgetBuilder)widgetBuilder).getWidgetBuilders()) {
                    String string = this.getValueProperty(component, widgetBuilder2);
                    if (string == null) continue;
                    return string;
                }
                return null;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (widgetBuilder instanceof SwingValuePropertyProvider) {
            return ((SwingValuePropertyProvider)((Object)widgetBuilder)).getValueProperty(component);
        }
        return null;
    }

    private Component getComponent(Container container, String string) {
        for (Component component : container.getComponents()) {
            if (!(component.getName() == null && component instanceof Container ? (component = this.getComponent((Container)component, string)) != null : string.equals(component.getName()))) continue;
            return component;
        }
        return null;
    }

    private static class ComponentAndValueProperty
    implements Immutable {
        private Component mComponent;
        private String mValueProperty;

        public ComponentAndValueProperty(Component component, String string) {
            this.mComponent = component;
            this.mValueProperty = string;
        }

        public Component getComponent() {
            return this.mComponent;
        }

        public String getValueProperty() {
            return this.mValueProperty;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Pipeline
    extends W3CPipeline<JComponent, JComponent, SwingMetawidget> {
        protected Pipeline() {
        }

        @Override
        protected SwingMetawidget getPipelineOwner() {
            return SwingMetawidget.this;
        }

        @Override
        protected String getDefaultConfiguration() {
            return SwingMetawidget.this.getDefaultConfiguration();
        }

        @Override
        protected void configure() {
            if (Beans.isDesignTime()) {
                return;
            }
            super.configure();
        }

        @Override
        protected void configureDefaults() {
            super.configureDefaults();
            if (this.getLayout() == null) {
                this.getConfigReader().configure(this.getDefaultConfiguration(), (Object)this.getPipelineOwner(), "metawidgetLayout");
            }
        }

        @Override
        protected void startBuild() {
            super.startBuild();
            SwingMetawidget.this.startBuild();
        }

        @Override
        protected void layoutWidget(JComponent jComponent, String string, Map<String, String> map) {
            SwingMetawidget.this.layoutWidget(jComponent, string, map);
            if (this.getLayout() == null) {
                SwingMetawidget.this.add(jComponent);
            } else {
                super.layoutWidget(jComponent, string, map);
            }
            if (jComponent instanceof SwingMetawidget) {
                ((SwingMetawidget)jComponent).buildWidgets();
            }
        }

        @Override
        protected Map<String, String> getAdditionalAttributes(JComponent jComponent) {
            if (jComponent instanceof Stub) {
                return ((Stub)jComponent).getAttributes();
            }
            return null;
        }

        @Override
        public SwingMetawidget buildNestedMetawidget(Map<String, String> map) throws Exception {
            SwingMetawidget swingMetawidget = (SwingMetawidget)SwingMetawidget.this.getClass().newInstance();
            SwingMetawidget.this.initNestedMetawidget(swingMetawidget, map);
            return swingMetawidget;
        }

        @Override
        protected void endBuild() {
            SwingMetawidget.this.endBuild();
            super.endBuild();
            SwingMetawidget.this.validate();
        }
    }
}

