/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.layout;

import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.swing.Facet;
import org.metawidget.swing.Stub;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.SimpleLayoutUtils;

public class GroupLayout
implements AdvancedLayout<JComponent, JComponent, SwingMetawidget> {
    private static final Component[] EMPTY_COMPONENTS_ARRAY = new Component[0];
    private static final int COMPONENT_GAP = 3;
    private static final String LABEL_NAME_SUFFIX = "_label";

    @Override
    public void onStartBuild(SwingMetawidget swingMetawidget) {
    }

    @Override
    public void startContainerLayout(JComponent jComponent, SwingMetawidget swingMetawidget) {
        javax.swing.GroupLayout groupLayout = new javax.swing.GroupLayout(jComponent);
        jComponent.setLayout(groupLayout);
        jComponent.putClientProperty(GroupLayout.class, null);
        State state = this.getState(jComponent);
        state.groupHorizontal = groupLayout.createParallelGroup();
        groupLayout.setHorizontalGroup(state.groupHorizontal);
        state.labels = CollectionUtils.newArrayList();
        state.groupVertical = groupLayout.createSequentialGroup();
        groupLayout.setVerticalGroup(state.groupVertical);
    }

    @Override
    public void layoutWidget(JComponent jComponent, String string, Map<String, String> map, JComponent jComponent2, SwingMetawidget swingMetawidget) {
        String string2;
        if (jComponent instanceof Stub && ((Stub)jComponent).getComponentCount() == 0) {
            return;
        }
        javax.swing.GroupLayout groupLayout = (javax.swing.GroupLayout)jComponent2.getLayout();
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE);
        State state = this.getState(jComponent2);
        state.groupHorizontal.addGroup(sequentialGroup);
        state.groupVertical.addGap(3, 3, 3);
        state.groupVertical.addGroup(parallelGroup);
        if (map != null && SimpleLayoutUtils.needsLabel(string2 = swingMetawidget.getLabelString(map), string)) {
            JLabel jLabel = new JLabel();
            jLabel.setName(map.get("name") + LABEL_NAME_SUFFIX);
            SimpleLayoutUtils.StrippedMnemonicAndFirstIndex strippedMnemonicAndFirstIndex = SimpleLayoutUtils.stripMnemonic(string2);
            String string3 = strippedMnemonicAndFirstIndex.getStrippedMnemonic();
            if ("true".equals(map.get("required")) && !WidgetBuilderUtils.isReadOnly(map) && !swingMetawidget.isReadOnly()) {
                string3 = string3 + "*";
            }
            jLabel.setText(string3 + ":");
            jLabel.setLabelFor(jComponent);
            int n = strippedMnemonicAndFirstIndex.getFirstIndex();
            if (n != -1) {
                jLabel.setDisplayedMnemonic(string3.charAt(n));
                jLabel.setDisplayedMnemonicIndex(n);
            }
            sequentialGroup.addComponent(jLabel).addGap(3, 3, 3);
            parallelGroup.addComponent(jLabel);
            state.labels.add(jLabel);
        }
        sequentialGroup.addComponent(jComponent);
        parallelGroup.addComponent(jComponent);
    }

    @Override
    public void endContainerLayout(JComponent jComponent, SwingMetawidget swingMetawidget) {
        State state = this.getState(jComponent);
        javax.swing.GroupLayout groupLayout = (javax.swing.GroupLayout)jComponent.getLayout();
        if (!state.labels.isEmpty()) {
            groupLayout.linkSize(0, state.labels.toArray(EMPTY_COMPONENTS_ARRAY));
        }
    }

    @Override
    public void onEndBuild(SwingMetawidget swingMetawidget) {
        Facet facet = swingMetawidget.getFacet("buttons");
        if (facet != null) {
            State state = this.getState(swingMetawidget);
            javax.swing.GroupLayout groupLayout = (javax.swing.GroupLayout)swingMetawidget.getLayout();
            state.groupHorizontal.addGroup(groupLayout.createSequentialGroup().addComponent(facet));
            state.groupVertical.addGap(3, 3, 3);
            state.groupVertical.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(facet));
        }
    }

    private State getState(JComponent jComponent) {
        State state = (State)jComponent.getClientProperty(GroupLayout.class);
        if (state == null) {
            state = new State();
            jComponent.putClientProperty(GroupLayout.class, state);
        }
        return state;
    }

    static class State {
        GroupLayout.ParallelGroup groupHorizontal;
        GroupLayout.SequentialGroup groupVertical;
        List<JLabel> labels;

        State() {
        }
    }
}

