/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.layout;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.swing.Facet;
import org.metawidget.swing.Stub;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.swing.layout.MigLayoutConfig;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.SimpleLayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigLayout
implements AdvancedLayout<JComponent, JComponent, SwingMetawidget> {
    private static final String LABEL_NAME_SUFFIX = "_label";
    private final int mNumberOfColumns;
    private final boolean mSupportMnemonics;
    private final boolean mDebugMode;

    public MigLayout() {
        this(new MigLayoutConfig());
    }

    public MigLayout(MigLayoutConfig migLayoutConfig) {
        this.mNumberOfColumns = migLayoutConfig.getNumberOfColumns();
        this.mSupportMnemonics = migLayoutConfig.isSupportMnemonics();
        this.mDebugMode = migLayoutConfig.isDebugMode();
    }

    @Override
    public void onStartBuild(SwingMetawidget swingMetawidget) {
    }

    @Override
    public void startContainerLayout(JComponent jComponent, SwingMetawidget swingMetawidget) {
        jComponent.putClientProperty(MigLayout.class, null);
        State state = this.getState(jComponent);
        LC lC = new LC().insets("0");
        if (this.mDebugMode) {
            lC.debug(500);
        }
        net.miginfocom.swing.MigLayout migLayout = new net.miginfocom.swing.MigLayout(lC);
        jComponent.setLayout((LayoutManager)migLayout);
        JTextField jTextField = new JTextField();
        jTextField.setLayout((LayoutManager)migLayout);
        double d = jTextField.getPreferredSize().getHeight();
        JLabel jLabel = new JLabel("X");
        jLabel.setLayout((LayoutManager)migLayout);
        double d2 = jLabel.getPreferredSize().getHeight();
        state.defaultLabelVerticalPadding = (int)Math.max(0.0, Math.floor((d - d2) / 2.0));
    }

    @Override
    public void layoutWidget(JComponent jComponent, String string, Map<String, String> map, JComponent jComponent2, SwingMetawidget swingMetawidget) {
        boolean bl;
        if (jComponent instanceof Stub && ((Stub)jComponent).getComponentCount() == 0) {
            return;
        }
        State state = this.getState(jComponent2);
        boolean bl2 = bl = jComponent instanceof JScrollPane || jComponent instanceof SwingMetawidget || SimpleLayoutUtils.isSpanAllColumns(map);
        if (bl && state.currentColumn > 0) {
            state.currentColumn = 0;
            ++state.currentRow;
        }
        String string2 = null;
        if (map != null) {
            string2 = swingMetawidget.getLabelString(map);
        }
        this.layoutBeforeChild(jComponent, string2, string, map, jComponent2, swingMetawidget);
        CC cC = new CC();
        if (string2 != null) {
            cC.cell(new int[]{state.currentColumn * 2 + 1, state.currentRow});
        } else {
            cC.cell(new int[]{state.currentColumn * 2, state.currentRow});
            cC.spanX(2);
        }
        cC.pushX(Float.valueOf(1.0f)).growX();
        if (bl) {
            cC.spanX();
            state.currentColumn = this.mNumberOfColumns;
        }
        cC.alignY("top");
        if (this.willFillVertically(jComponent, map)) {
            cC.pushY(Float.valueOf(1.0f)).growY();
        }
        jComponent2.add((Component)jComponent, cC);
        ++state.currentColumn;
        if (state.currentColumn >= this.mNumberOfColumns) {
            state.currentColumn = 0;
            ++state.currentRow;
        }
    }

    @Override
    public void endContainerLayout(JComponent jComponent, SwingMetawidget swingMetawidget) {
    }

    @Override
    public void onEndBuild(SwingMetawidget swingMetawidget) {
        Facet facet = swingMetawidget.getFacet("buttons");
        if (facet != null) {
            State state = this.getState(swingMetawidget);
            if (state.currentColumn > 0) {
                state.currentColumn = 0;
            }
            swingMetawidget.add((Component)facet, new CC().cell(new int[]{0, ++state.currentRow}).spanX().growX());
        }
    }

    protected void layoutBeforeChild(Component component, String string, String string2, Map<String, String> map, JComponent jComponent, SwingMetawidget swingMetawidget) {
        State state = this.getState(jComponent);
        if (SimpleLayoutUtils.needsLabel(string, string2)) {
            JLabel jLabel = new JLabel();
            jLabel.setName(map.get("name") + LABEL_NAME_SUFFIX);
            SimpleLayoutUtils.StrippedMnemonicAndFirstIndex strippedMnemonicAndFirstIndex = SimpleLayoutUtils.stripMnemonic(string);
            String string3 = strippedMnemonicAndFirstIndex.getStrippedMnemonic();
            if ("true".equals(map.get("required")) && !WidgetBuilderUtils.isReadOnly(map) && !swingMetawidget.isReadOnly()) {
                jLabel.setText(string3 + "*:");
            } else {
                jLabel.setText(string3 + ":");
            }
            jLabel.setLabelFor(component);
            int n = strippedMnemonicAndFirstIndex.getFirstIndex();
            if (n != -1 && this.mSupportMnemonics) {
                jLabel.setDisplayedMnemonic(string3.charAt(n));
                jLabel.setDisplayedMnemonicIndex(n);
            }
            CC cC = new CC();
            cC.cell(new int[]{state.currentColumn * 2, state.currentRow});
            cC.growX();
            cC.alignY("top");
            cC.pad(state.defaultLabelVerticalPadding, 0, state.defaultLabelVerticalPadding, 0);
            jComponent.add((Component)jLabel, cC);
        }
    }

    protected boolean willFillVertically(JComponent jComponent, Map<String, String> map) {
        if (map != null && "true".equals(map.get("large"))) {
            return true;
        }
        return jComponent instanceof JScrollPane;
    }

    private State getState(JComponent jComponent) {
        State state = (State)jComponent.getClientProperty(MigLayout.class);
        if (state == null) {
            state = new State();
            jComponent.putClientProperty(MigLayout.class, state);
        }
        return state;
    }

    static class State {
        int currentColumn;
        int currentRow;
        int defaultLabelVerticalPadding;

        State() {
        }
    }
}

