/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.layout;

import org.metawidget.layout.iface.LayoutException;
import org.metawidget.util.simple.ObjectUtils;

public class MigLayoutConfig {
    private int mNumberOfColumns = 1;
    private boolean mSupportMnemonics = true;
    private boolean mDebugMode;

    public MigLayoutConfig setNumberOfColumns(int n) {
        if (n < 1) {
            throw LayoutException.newException("numberOfColumns must be >= 1");
        }
        this.mNumberOfColumns = n;
        return this;
    }

    public MigLayoutConfig setSupportMnemonics(boolean bl) {
        this.mSupportMnemonics = bl;
        return this;
    }

    public MigLayoutConfig setDebugMode(boolean bl) {
        this.mDebugMode = bl;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!ObjectUtils.nullSafeClassEquals(this, object)) {
            return false;
        }
        if (this.mNumberOfColumns != ((MigLayoutConfig)object).mNumberOfColumns) {
            return false;
        }
        if (this.mSupportMnemonics != ((MigLayoutConfig)object).mSupportMnemonics) {
            return false;
        }
        return this.mDebugMode == ((MigLayoutConfig)object).mDebugMode;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.mNumberOfColumns;
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mSupportMnemonics);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mDebugMode);
        return n;
    }

    protected int getNumberOfColumns() {
        return this.mNumberOfColumns;
    }

    protected boolean isSupportMnemonics() {
        return this.mSupportMnemonics;
    }

    protected boolean isDebugMode() {
        return this.mDebugMode;
    }
}

