/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.widgetbuilder;

import java.awt.Component;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.metawidget.swing.Stub;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.swing.SwingValuePropertyProvider;
import org.metawidget.swing.widgetbuilder.LookupLabel;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyWidgetBuilder
implements WidgetBuilder<JComponent, SwingMetawidget>,
SwingValuePropertyProvider {
    @Override
    public String getValueProperty(Component component) {
        if (component instanceof JLabel) {
            return "text";
        }
        return null;
    }

    @Override
    public JComponent buildWidget(String string, Map<String, String> map, SwingMetawidget swingMetawidget) {
        if (!WidgetBuilderUtils.isReadOnly(map)) {
            return null;
        }
        if ("true".equals(map.get("hidden"))) {
            return new Stub();
        }
        if ("action".equals(string)) {
            JButton jButton = new JButton(swingMetawidget.getLabelString(map));
            jButton.setEnabled(false);
            return jButton;
        }
        if ("true".equals(map.get("masked"))) {
            return new JPanel();
        }
        String string2 = map.get("lookup");
        if (string2 != null && !"".equals(string2)) {
            String string3 = map.get("lookup-labels");
            if (string3 != null && !"".equals(string3)) {
                return new LookupLabel(CollectionUtils.newHashMap(CollectionUtils.fromString(string2), CollectionUtils.fromString(string3)));
            }
            return new JLabel();
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(map, String.class);
        if (clazz != null) {
            if (clazz.isPrimitive()) {
                return new JLabel();
            }
            if (String.class.equals(clazz)) {
                if ("true".equals(map.get("large"))) {
                    JTextArea jTextArea = new JTextArea();
                    jTextArea.setLineWrap(true);
                    jTextArea.setWrapStyleWord(true);
                    jTextArea.setEditable(false);
                    jTextArea.setRows(2);
                    JScrollPane jScrollPane = new JScrollPane(jTextArea);
                    jScrollPane.setBorder(null);
                    return jScrollPane;
                }
                return new JLabel();
            }
            if (Character.class.equals(clazz)) {
                return new JLabel();
            }
            if (Date.class.equals(clazz)) {
                return new JLabel();
            }
            if (Boolean.class.equals(clazz)) {
                return new JLabel();
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return new JLabel();
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new Stub();
            }
        }
        if ("true".equals(map.get("dont-expand"))) {
            return new JLabel();
        }
        return null;
    }
}

