/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.widgetprocessor.binding.beansbinding;

import java.awt.Component;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.swing.widgetprocessor.binding.BindingConverter;
import org.metawidget.swing.widgetprocessor.binding.beansbinding.BeansBindingProcessorConfig;
import org.metawidget.swing.widgetprocessor.binding.beansbinding.BooleanConverter;
import org.metawidget.swing.widgetprocessor.binding.beansbinding.NumberConverter;
import org.metawidget.swing.widgetprocessor.binding.beansbinding.ReadOnlyToStringConverter;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.ObjectUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansBindingProcessor
implements AdvancedWidgetProcessor<JComponent, SwingMetawidget>,
BindingConverter {
    private final AutoBinding.UpdateStrategy mUpdateStrategy;
    private final Map<ConvertFromTo<?, ?>, Converter<?, ?>> mConverters = CollectionUtils.newHashMap();

    public BeansBindingProcessor() {
        this(new BeansBindingProcessorConfig());
    }

    public BeansBindingProcessor(BeansBindingProcessorConfig beansBindingProcessorConfig) {
        this.mUpdateStrategy = beansBindingProcessorConfig.getUpdateStrategy();
        this.registerConverter(Byte.class, String.class, new NumberConverter<Byte>(Byte.class));
        this.registerConverter(Short.class, String.class, new NumberConverter<Short>(Short.class));
        this.registerConverter(Integer.class, String.class, new NumberConverter<Integer>(Integer.class));
        this.registerConverter(Long.class, String.class, new NumberConverter<Long>(Long.class));
        this.registerConverter(Float.class, String.class, new NumberConverter<Float>(Float.class));
        this.registerConverter(Double.class, String.class, new NumberConverter<Double>(Double.class));
        this.registerConverter(Boolean.class, String.class, new BooleanConverter());
        if (beansBindingProcessorConfig.getConverters() != null) {
            this.mConverters.putAll(beansBindingProcessorConfig.getConverters());
        }
    }

    @Override
    public void onStartBuild(SwingMetawidget swingMetawidget) {
        State state = this.getState(swingMetawidget);
        if (state.bindings != null) {
            for (Binding<Object, ?, ? extends Component, ?> binding : state.bindings) {
                binding.unbind();
            }
        }
        swingMetawidget.putClientProperty(BeansBindingProcessor.class, null);
    }

    @Override
    public JComponent processWidget(JComponent jComponent, String string, Map<String, String> map, SwingMetawidget swingMetawidget) {
        JComponent jComponent2 = jComponent;
        if (jComponent2 instanceof JScrollPane) {
            jComponent2 = (JComponent)((JScrollPane)jComponent2).getViewport().getView();
        }
        if (jComponent2 instanceof SwingMetawidget) {
            State state = this.getState(swingMetawidget);
            if (state.nestedMetawidgets == null) {
                state.nestedMetawidgets = CollectionUtils.newHashSet();
            }
            state.nestedMetawidgets.add((SwingMetawidget)jComponent);
            return jComponent;
        }
        this.typesafeAdd(jComponent2, string, map, swingMetawidget);
        return jComponent;
    }

    public void rebind(Object object, SwingMetawidget swingMetawidget) {
        swingMetawidget.updateToInspectWithoutInvalidate(object);
        State state = this.getState(swingMetawidget);
        if (state.bindings != null) {
            for (Binding binding : state.bindings) {
                binding.unbind();
                binding.setSourceObject(object);
                Binding binding2 = this.processBinding(binding, swingMetawidget);
                if (binding2 == null) continue;
                binding2.bind();
                Binding.SyncFailure syncFailure = binding2.refresh();
                if (syncFailure == null) continue;
                throw WidgetProcessorException.newException(syncFailure.getType().toString());
            }
        }
        if (state.nestedMetawidgets != null) {
            for (SwingMetawidget swingMetawidget2 : state.nestedMetawidgets) {
                this.rebind(object, swingMetawidget2);
            }
        }
    }

    public void save(SwingMetawidget swingMetawidget) {
        State state = this.getState(swingMetawidget);
        if (state.bindings != null) {
            for (Binding object : state.bindings) {
                Object object2 = object.getSourceObject();
                BeanProperty beanProperty = (BeanProperty)object.getSourceProperty();
                if (!beanProperty.isWriteable(object2) || object.getConverter() instanceof ReadOnlyToStringConverter) continue;
                try {
                    Binding.SyncFailure syncFailure = object.save();
                    if (syncFailure == null) continue;
                    throw WidgetProcessorException.newException(syncFailure.getConversionException());
                }
                catch (ClassCastException classCastException) {
                    throw WidgetProcessorException.newException("When saving from " + ((Component)object.getTargetObject()).getClass() + " to " + beanProperty + " (have you used BeansBindingProcessorConfig.setConverter?)", classCastException);
                }
            }
        }
        if (state.nestedMetawidgets != null) {
            for (SwingMetawidget swingMetawidget2 : state.nestedMetawidgets) {
                this.save(swingMetawidget2);
            }
        }
    }

    @Override
    public Object convertFromString(String string, Class<?> clazz) {
        if (String.class.equals(clazz)) {
            return string;
        }
        Converter<String, ?> converter = this.getConverter(String.class, clazz);
        if (converter != null) {
            return converter.convertForward((Object)string);
        }
        Converter<?, String> converter2 = this.getConverter(clazz, String.class);
        if (converter2 != null) {
            return converter2.convertReverse((Object)string);
        }
        return string;
    }

    @Override
    public void onEndBuild(SwingMetawidget swingMetawidget) {
    }

    protected <SS, SV, TS extends Component, TV> Binding<SS, SV, TS, TV> processBinding(Binding<SS, SV, TS, TV> binding, SwingMetawidget swingMetawidget) {
        return binding;
    }

    private <S, T> void registerConverter(Class<S> clazz, Class<T> clazz2, Converter<S, T> converter) {
        this.mConverters.put(new ConvertFromTo<S, T>(clazz, clazz2), converter);
    }

    private <SS, SV, TS extends Component, TV> void typesafeAdd(TS TS, String string, Map<String, String> map, SwingMetawidget swingMetawidget) {
        Object object;
        String string2 = swingMetawidget.getValueProperty(TS);
        if (string2 == null) {
            return;
        }
        Object t = swingMetawidget.getToInspect();
        String string3 = PathUtils.parsePath(swingMetawidget.getPath()).getNames().replace('/', '.');
        if ("property".equals(string)) {
            if (string3.length() > 0) {
                string3 = string3 + '.';
            }
            string3 = string3 + map.get("name");
        }
        BeanProperty beanProperty = BeanProperty.create((String)string3);
        BeanProperty beanProperty2 = BeanProperty.create((String)string2);
        Binding<SS, SV, TS, TV> binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)this.mUpdateStrategy, t, (Property)beanProperty, TS, (Property)beanProperty2);
        Class clazz = beanProperty2.getWriteType(TS);
        Object object2 = null;
        if (beanProperty.isWriteable(t)) {
            object = beanProperty.getWriteType(t);
            object2 = this.getConverter((Class<SV>)object, clazz);
        } else if (beanProperty.isReadable(t)) {
            object = beanProperty.getValue(t);
            if (object != null) {
                Class<?> clazz2 = object.getClass();
                object2 = this.getConverter(clazz2, clazz);
            }
        } else {
            throw WidgetProcessorException.newException("Property '" + string3 + "' has no getter and no setter (or parent is null)");
        }
        if (object2 == null && WidgetBuilderUtils.isReadOnly(map) && clazz.equals(String.class)) {
            object2 = new ReadOnlyToStringConverter();
        }
        binding.setConverter(object2);
        binding = this.processBinding(binding, swingMetawidget);
        if (binding == null) {
            return;
        }
        try {
            binding.bind();
        }
        catch (ClassCastException classCastException) {
            throw WidgetProcessorException.newException("When binding " + swingMetawidget.getPath() + '/' + string3 + " to " + TS.getClass() + "." + string2 + " (have you used BeansBindingProcessorConfig.setConverter?)", classCastException);
        }
        object = this.getState(swingMetawidget);
        if (((State)object).bindings == null) {
            ((State)object).bindings = CollectionUtils.newHashSet();
        }
        ((State)object).bindings.add(binding);
    }

    private <SV, TV> Converter<SV, TV> getConverter(Class<SV> clazz, Class<TV> clazz2) {
        Class<Object> clazz3 = clazz;
        Class<Object> clazz4 = clazz2;
        if (clazz3.isPrimitive()) {
            clazz3 = ClassUtils.getWrapperClass(clazz3);
        }
        if (clazz4.isPrimitive()) {
            clazz4 = ClassUtils.getWrapperClass(clazz4);
        }
        while (clazz3 != null) {
            Converter<?, ?> converter = this.mConverters.get(new ConvertFromTo<SV, TV>(clazz3, clazz4));
            if (converter != null) {
                return converter;
            }
            clazz3 = clazz3.getSuperclass();
        }
        return null;
    }

    private State getState(SwingMetawidget swingMetawidget) {
        State state = (State)swingMetawidget.getClientProperty(BeansBindingProcessor.class);
        if (state == null) {
            state = new State();
            swingMetawidget.putClientProperty(BeansBindingProcessor.class, state);
        }
        return state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ConvertFromTo<S, T> {
        private Class<S> mSource;
        private Class<T> mTarget;

        public ConvertFromTo(Class<S> clazz, Class<T> clazz2) {
            this.mSource = clazz;
            this.mTarget = clazz2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals(this.mSource, ((ConvertFromTo)object).mSource)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.mTarget, ((ConvertFromTo)object).mTarget);
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + ObjectUtils.nullSafeHashCode(this.mSource.hashCode());
            n = 31 * n + ObjectUtils.nullSafeHashCode(this.mTarget.hashCode());
            return n;
        }
    }

    static class State {
        Set<Binding<Object, ?, ? extends Component, ?>> bindings;
        Set<SwingMetawidget> nestedMetawidgets;

        State() {
        }
    }
}

