/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.widgetprocessor.binding.beanutils;

import java.awt.Component;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.inspector.impl.propertystyle.ValueAndDeclaredType;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.swing.widgetprocessor.binding.BindingConverter;
import org.metawidget.swing.widgetprocessor.binding.beanutils.BeanUtilsBindingProcessorConfig;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanUtilsBindingProcessor
implements AdvancedWidgetProcessor<JComponent, SwingMetawidget>,
BindingConverter {
    private final PropertyStyle mPropertyStyle;

    public BeanUtilsBindingProcessor() {
        this(new BeanUtilsBindingProcessorConfig());
    }

    public BeanUtilsBindingProcessor(BeanUtilsBindingProcessorConfig beanUtilsBindingProcessorConfig) {
        this.mPropertyStyle = beanUtilsBindingProcessorConfig.getPropertyStyle();
    }

    @Override
    public void onStartBuild(SwingMetawidget swingMetawidget) {
        swingMetawidget.putClientProperty(BeanUtilsBindingProcessor.class, null);
    }

    @Override
    public JComponent processWidget(JComponent jComponent, String string, Map<String, String> map, SwingMetawidget swingMetawidget) {
        JComponent jComponent2 = jComponent;
        if (jComponent2 instanceof JScrollPane) {
            jComponent2 = (JComponent)((JScrollPane)jComponent2).getViewport().getView();
        }
        if (jComponent2 instanceof SwingMetawidget) {
            State state = this.getState(swingMetawidget);
            if (state.nestedMetawidgets == null) {
                state.nestedMetawidgets = CollectionUtils.newHashSet();
            }
            state.nestedMetawidgets.add((SwingMetawidget)jComponent);
            return jComponent;
        }
        String string2 = swingMetawidget.getValueProperty(jComponent2);
        if (string2 == null) {
            return jComponent;
        }
        String string3 = swingMetawidget.getPath();
        if ("property".equals(string)) {
            string3 = string3 + '/' + map.get("name");
        }
        try {
            PathUtils.TypeAndNames typeAndNames = PathUtils.parsePath(string3, '/');
            Object object = this.mPropertyStyle.traverse(swingMetawidget.getToInspect(), typeAndNames.getType(), false, typeAndNames.getNamesAsArray()).getValue();
            String string4 = typeAndNames.getNames().replace('/', '.');
            SavedBinding savedBinding = new SavedBinding(jComponent2, string2, string4, "true".equals(map.get("no-setter")));
            this.saveValueToWidget(savedBinding, object);
            State state = this.getState(swingMetawidget);
            if (state.bindings == null) {
                state.bindings = CollectionUtils.newHashSet();
            }
            state.bindings.add(savedBinding);
        }
        catch (Exception exception) {
            throw WidgetProcessorException.newException(exception);
        }
        return jComponent;
    }

    public void rebind(Object object, SwingMetawidget swingMetawidget) {
        swingMetawidget.updateToInspectWithoutInvalidate(object);
        State state = this.getState(swingMetawidget);
        if (state.bindings != null) {
            try {
                for (SavedBinding object2 : state.bindings) {
                    String string = object2.getNames();
                    ValueAndDeclaredType valueAndDeclaredType = this.mPropertyStyle.traverse(object, object.getClass().getName(), false, string.split("\\."));
                    if (valueAndDeclaredType.getDeclaredType() == null) {
                        throw WidgetProcessorException.newException("Property '" + string + "' has no getter");
                    }
                    this.saveValueToWidget(object2, valueAndDeclaredType.getValue());
                }
            }
            catch (Exception exception) {
                throw WidgetProcessorException.newException(exception);
            }
        }
        if (state.nestedMetawidgets != null) {
            for (SwingMetawidget swingMetawidget2 : state.nestedMetawidgets) {
                this.rebind(object, swingMetawidget2);
            }
        }
    }

    public void save(SwingMetawidget swingMetawidget) {
        State state = this.getState(swingMetawidget);
        if (state.bindings != null) {
            try {
                for (SavedBinding object : state.bindings) {
                    if (!object.isSettable()) continue;
                    Object object2 = this.retrieveValueFromWidget(object);
                    this.saveValueToObject(swingMetawidget, object.getNames(), object2);
                }
            }
            catch (Exception exception) {
                throw WidgetProcessorException.newException(exception);
            }
        }
        if (state.nestedMetawidgets != null) {
            for (SwingMetawidget swingMetawidget2 : state.nestedMetawidgets) {
                this.save(swingMetawidget2);
            }
        }
    }

    @Override
    public Object convertFromString(String string, Class<?> clazz) {
        return ConvertUtils.convert((String)string, clazz);
    }

    @Override
    public void onEndBuild(SwingMetawidget swingMetawidget) {
    }

    protected void saveValueToObject(SwingMetawidget swingMetawidget, String string, Object object) throws Exception {
        Object t = swingMetawidget.getToInspect();
        String[] stringArray = string.split("\\.");
        Object object2 = this.mPropertyStyle.traverse(t, t.getClass().getName(), true, stringArray).getValue();
        if (object2 == null) {
            return;
        }
        Class<?> clazz = object2.getClass();
        String string2 = stringArray[stringArray.length - 1];
        Property property = this.mPropertyStyle.getProperties(clazz.getName()).get(string2);
        Object object3 = ConvertUtils.convert((Object)object, ClassUtils.niceForName(property.getType()));
        property.write(object2, object3);
    }

    protected Object retrieveValueFromWidget(SavedBinding savedBinding) throws Exception {
        return PropertyUtils.getProperty((Object)savedBinding.getComponent(), (String)savedBinding.getComponentProperty());
    }

    protected void saveValueToWidget(SavedBinding savedBinding, Object object) throws Exception {
        BeanUtils.setProperty((Object)savedBinding.getComponent(), (String)savedBinding.getComponentProperty(), (Object)object);
    }

    private State getState(SwingMetawidget swingMetawidget) {
        State state = (State)swingMetawidget.getClientProperty(BeanUtilsBindingProcessor.class);
        if (state == null) {
            state = new State();
            swingMetawidget.putClientProperty(BeanUtilsBindingProcessor.class, state);
        }
        return state;
    }

    static class SavedBinding {
        private Component mComponent;
        private String mComponentProperty;
        private String mNames;
        private boolean mNoSetter;

        public SavedBinding(Component component, String string, String string2, boolean bl) {
            this.mComponent = component;
            this.mComponentProperty = string;
            this.mNames = string2;
            this.mNoSetter = bl;
        }

        public Component getComponent() {
            return this.mComponent;
        }

        public String getComponentProperty() {
            return this.mComponentProperty;
        }

        public String getNames() {
            return this.mNames;
        }

        public boolean isSettable() {
            return !this.mNoSetter;
        }
    }

    static class State {
        Set<SavedBinding> bindings;
        Set<SwingMetawidget> nestedMetawidgets;

        State() {
        }
    }
}

