/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.widgetprocessor.binding.reflection;

import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import org.metawidget.swing.Stub;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionBindingProcessor
implements AdvancedWidgetProcessor<JComponent, SwingMetawidget> {
    @Override
    public void onStartBuild(SwingMetawidget swingMetawidget) {
        swingMetawidget.putClientProperty(ReflectionBindingProcessor.class, null);
    }

    @Override
    public JComponent processWidget(JComponent jComponent, String string, Map<String, String> map, SwingMetawidget swingMetawidget) {
        if (jComponent instanceof SwingMetawidget) {
            State state = this.getState(swingMetawidget);
            if (state.nestedMetawidgets == null) {
                state.nestedMetawidgets = CollectionUtils.newHashSet();
            }
            state.nestedMetawidgets.add((SwingMetawidget)jComponent);
            return jComponent;
        }
        if (!"action".equals(string)) {
            return jComponent;
        }
        if (jComponent instanceof Stub) {
            return jComponent;
        }
        if (!(jComponent instanceof AbstractButton)) {
            throw WidgetProcessorException.newException("ReflectionBindingProcessor only supports binding actions to AbstractButtons");
        }
        if (WidgetBuilderUtils.isReadOnly(map)) {
            return jComponent;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        BoundAction boundAction = new BoundAction(abstractButton.getText(), swingMetawidget.getToInspect(), swingMetawidget.getPath(), map.get("name"));
        abstractButton.setAction(boundAction);
        State state = this.getState(swingMetawidget);
        if (state.actions == null) {
            state.actions = CollectionUtils.newHashSet();
        }
        state.actions.add(boundAction);
        return abstractButton;
    }

    @Override
    public void onEndBuild(SwingMetawidget swingMetawidget) {
    }

    public void rebind(Object object, SwingMetawidget swingMetawidget) {
        swingMetawidget.updateToInspectWithoutInvalidate(object);
        State state = this.getState(swingMetawidget);
        if (state.actions != null) {
            for (BoundAction serializable : state.actions) {
                serializable.rebind(object);
            }
        }
        if (state.nestedMetawidgets != null) {
            for (SwingMetawidget swingMetawidget2 : state.nestedMetawidgets) {
                this.rebind(object, swingMetawidget2);
            }
        }
    }

    private State getState(SwingMetawidget swingMetawidget) {
        State state = (State)swingMetawidget.getClientProperty(ReflectionBindingProcessor.class);
        if (state == null) {
            state = new State();
            swingMetawidget.putClientProperty(ReflectionBindingProcessor.class, state);
        }
        return state;
    }

    static class BoundAction
    extends AbstractAction {
        private Object mBindTo;
        private String[] mNames;
        private Method mAction;

        public BoundAction(String string, Object object, String string2, String string3) {
            super(string);
            this.mBindTo = object;
            if (string2 == null) {
                return;
            }
            this.mNames = PathUtils.parsePath(string2).getNamesAsArray();
            Object object2 = this.mBindTo;
            for (String string4 : this.mNames) {
                if (object2 == null) {
                    return;
                }
                object2 = ClassUtils.getProperty(object2, string4);
            }
            try {
                this.mAction = object2.getClass().getMethod(string3, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    this.mAction = object2.getClass().getMethod(string3, ActionEvent.class);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    throw WidgetProcessorException.newException(noSuchMethodException2);
                }
            }
        }

        public void rebind(Object object) {
            this.mBindTo = object;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)this.getValue("Name");
            Object object = this.mBindTo;
            for (String string2 : this.mNames) {
                if (object == null) {
                    return;
                }
                object = ClassUtils.getProperty(object, string2);
            }
            try {
                if (this.mAction.getParameterTypes().length == 0) {
                    this.mAction.invoke(object, (Object[])null);
                } else {
                    this.mAction.invoke(object, new ActionEvent(this.mBindTo, 0, string));
                }
            }
            catch (Exception exception) {
                throw WidgetProcessorException.newException(exception);
            }
        }
    }

    static class State {
        Set<BoundAction> actions;
        Set<SwingMetawidget> nestedMetawidgets;

        State() {
        }
    }
}

