/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swt.layout;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.metawidget.layout.iface.LayoutException;
import org.metawidget.util.simple.ObjectUtils;

public class GridLayoutConfig {
    private int mNumberOfColumns = 1;
    private int mLabelAlignment = 16384;
    private Color mLabelForeground;
    private Font mLabelFont;
    private String mLabelSuffix = ":";
    private int mRequiredAlignment = 0x1000000;
    private String mRequiredText = "*";

    public GridLayoutConfig setNumberOfColumns(int n) {
        if (n < 1) {
            throw LayoutException.newException("numberOfColumns must be >= 1");
        }
        this.mNumberOfColumns = n;
        return this;
    }

    public GridLayoutConfig setLabelAlignment(int n) {
        this.mLabelAlignment = n;
        return this;
    }

    public GridLayoutConfig setLabelForeground(Color color) {
        this.mLabelForeground = color;
        return this;
    }

    public GridLayoutConfig setLabelFont(Font font) {
        this.mLabelFont = font;
        return this;
    }

    public GridLayoutConfig setLabelSuffix(String string) {
        this.mLabelSuffix = string;
        return this;
    }

    public GridLayoutConfig setRequiredAlignment(int n) {
        this.mRequiredAlignment = n;
        return this;
    }

    public GridLayoutConfig setRequiredText(String string) {
        this.mRequiredText = string;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!ObjectUtils.nullSafeClassEquals(this, object)) {
            return false;
        }
        if (this.mNumberOfColumns != ((GridLayoutConfig)object).mNumberOfColumns) {
            return false;
        }
        if (this.mLabelAlignment != ((GridLayoutConfig)object).mLabelAlignment) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mLabelFont, ((GridLayoutConfig)object).mLabelFont)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mLabelForeground, ((GridLayoutConfig)object).mLabelForeground)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mLabelSuffix, ((GridLayoutConfig)object).mLabelSuffix)) {
            return false;
        }
        if (this.mRequiredAlignment != ((GridLayoutConfig)object).mRequiredAlignment) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.mRequiredText, ((GridLayoutConfig)object).mRequiredText);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.mNumberOfColumns;
        n = 31 * n + this.mLabelAlignment;
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mLabelFont);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mLabelForeground);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mLabelSuffix);
        n = 31 * n + this.mRequiredAlignment;
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mRequiredText);
        return n;
    }

    protected int getNumberOfColumns() {
        return this.mNumberOfColumns;
    }

    protected int getLabelAlignment() {
        return this.mLabelAlignment;
    }

    protected Color getLabelForeground() {
        return this.mLabelForeground;
    }

    protected Font getLabelFont() {
        return this.mLabelFont;
    }

    protected String getLabelSuffix() {
        return this.mLabelSuffix;
    }

    protected int getRequiredAlignment() {
        return this.mRequiredAlignment;
    }

    protected String getRequiredText() {
        return this.mRequiredText;
    }
}

