/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swt.layout;

import java.util.Map;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.swt.Facet;
import org.metawidget.swt.Stub;
import org.metawidget.swt.SwtMetawidget;
import org.metawidget.swt.layout.MigLayoutConfig;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.SimpleLayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigLayout
implements AdvancedLayout<Control, Composite, SwtMetawidget> {
    private final int mNumberOfColumns;
    private final boolean mDebugMode;

    public MigLayout() {
        this(new MigLayoutConfig());
    }

    public MigLayout(MigLayoutConfig migLayoutConfig) {
        this.mNumberOfColumns = migLayoutConfig.getNumberOfColumns();
        this.mDebugMode = migLayoutConfig.isDebugMode();
    }

    @Override
    public void onStartBuild(SwtMetawidget swtMetawidget) {
    }

    @Override
    public void startContainerLayout(Composite composite, SwtMetawidget swtMetawidget) {
        composite.setData(MigLayout.class.getName(), null);
        State state = this.getState(composite);
        LC lC = new LC().insets("0");
        if (this.mDebugMode) {
            lC.debug(500);
        }
        net.miginfocom.swt.MigLayout migLayout = new net.miginfocom.swt.MigLayout(lC);
        composite.setLayout((Layout)migLayout);
        state.defaultLabelVerticalPadding = new GC((Drawable)composite).getFontMetrics().getLeading();
    }

    @Override
    public void layoutWidget(Control control, String string, Map<String, String> map, Composite composite, SwtMetawidget swtMetawidget) {
        boolean bl;
        if (control instanceof Stub && ((Stub)control).getChildren().length == 0) {
            CC cC = new CC();
            cC.setHideMode(3);
            control.setLayoutData((Object)cC);
            control.setVisible(false);
            return;
        }
        State state = this.getState(composite);
        boolean bl2 = bl = control instanceof SwtMetawidget || SimpleLayoutUtils.isSpanAllColumns(map);
        if (bl && state.currentColumn > 0) {
            state.currentColumn = 0;
            ++state.currentRow;
        }
        String string2 = null;
        if (map != null) {
            string2 = swtMetawidget.getLabelString(map);
        }
        this.layoutBeforeChild(control, string2, string, map, (Control)composite, swtMetawidget);
        CC cC = new CC();
        if (string2 != null) {
            cC.cell(new int[]{state.currentColumn * 2 + 1, state.currentRow});
        } else {
            cC.cell(new int[]{state.currentColumn * 2, state.currentRow});
            cC.spanX(2);
        }
        cC.pushX(Float.valueOf(1.0f)).growX();
        if (bl) {
            cC.spanX();
            state.currentColumn = this.mNumberOfColumns;
        }
        cC.alignY("top");
        if (this.willFillVertically(control, map)) {
            cC.pushY(Float.valueOf(1.0f)).growY();
        }
        control.setLayoutData((Object)cC);
        ++state.currentColumn;
        if (state.currentColumn >= this.mNumberOfColumns) {
            state.currentColumn = 0;
            ++state.currentRow;
        }
    }

    @Override
    public void endContainerLayout(Composite composite, SwtMetawidget swtMetawidget) {
    }

    @Override
    public void onEndBuild(SwtMetawidget swtMetawidget) {
        Facet facet = swtMetawidget.getFacet("buttons");
        if (facet != null) {
            State state = this.getState(swtMetawidget);
            if (state.currentColumn > 0) {
                state.currentColumn = 0;
            }
            facet.setLayoutData(new CC().cell(new int[]{0, ++state.currentRow}).spanX().growX());
            facet.moveBelow(null);
        }
    }

    protected String layoutBeforeChild(Control control, String string, String string2, Map<String, String> map, Control control2, SwtMetawidget swtMetawidget) {
        State state = this.getState((Composite)control2);
        if (SimpleLayoutUtils.needsLabel(string, string2)) {
            Label label = new Label((Composite)control2, 0);
            if (map != null && "true".equals(map.get("required")) && !WidgetBuilderUtils.isReadOnly(map) && !swtMetawidget.isReadOnly()) {
                label.setText(string + "*:");
            } else {
                label.setText(string + ":");
            }
            CC cC = new CC();
            cC.cell(new int[]{state.currentColumn * 2, state.currentRow});
            cC.growX();
            cC.alignY("top");
            cC.pad(state.defaultLabelVerticalPadding, 0, state.defaultLabelVerticalPadding, 0);
            label.setLayoutData((Object)cC);
            label.moveAbove(control);
        }
        return string;
    }

    protected boolean willFillVertically(Control control, Map<String, String> map) {
        return map != null && "true".equals(map.get("large"));
    }

    private State getState(Composite composite) {
        State state = (State)composite.getData(MigLayout.class.getName());
        if (state == null) {
            state = new State();
            composite.setData(MigLayout.class.getName(), (Object)state);
        }
        return state;
    }

    static class State {
        int currentColumn;
        int currentRow;
        int defaultLabelVerticalPadding;

        State() {
        }
    }
}

