/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swt.layout;

import org.metawidget.layout.iface.LayoutException;
import org.metawidget.util.simple.ObjectUtils;

public class MigLayoutConfig {
    private int mNumberOfColumns = 1;
    private boolean mDebugMode = false;

    public MigLayoutConfig setNumberOfColumns(int n) {
        if (n < 1) {
            throw LayoutException.newException("numberOfColumns must be >= 1");
        }
        this.mNumberOfColumns = n;
        return this;
    }

    public MigLayoutConfig setDebugMode(boolean bl) {
        this.mDebugMode = bl;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!ObjectUtils.nullSafeClassEquals(this, object)) {
            return false;
        }
        if (this.mNumberOfColumns != ((MigLayoutConfig)object).mNumberOfColumns) {
            return false;
        }
        return this.mDebugMode == ((MigLayoutConfig)object).mDebugMode;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.mNumberOfColumns;
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mDebugMode);
        return n;
    }

    protected int getNumberOfColumns() {
        return this.mNumberOfColumns;
    }

    protected boolean isDebugMode() {
        return this.mDebugMode;
    }
}

