/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swt.widgetprocessor.binding.databinding;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.internal.databinding.BindingStatus;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.metawidget.swt.SwtMetawidget;
import org.metawidget.swt.widgetprocessor.binding.databinding.DataBindingProcessorConfig;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.ObjectUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBindingProcessor
implements AdvancedWidgetProcessor<Control, SwtMetawidget> {
    private List<DisplayRealm> mRealms = CollectionUtils.newArrayList();
    private final Map<ConvertFromTo, IConverter> mConverters = CollectionUtils.newHashMap();

    public DataBindingProcessor() {
        this(new DataBindingProcessorConfig());
    }

    public DataBindingProcessor(DataBindingProcessorConfig dataBindingProcessorConfig) {
        IConverter[] iConverterArray = dataBindingProcessorConfig.getConverters();
        if (iConverterArray != null) {
            for (IConverter iConverter : iConverterArray) {
                this.mConverters.put(new ConvertFromTo((Class)iConverter.getFromType(), (Class)iConverter.getToType()), iConverter);
            }
        }
    }

    @Override
    public void onStartBuild(SwtMetawidget swtMetawidget) {
        swtMetawidget.setData(DataBindingProcessor.class.getName(), null);
    }

    @Override
    public Control processWidget(Control control, String string, Map<String, String> map, SwtMetawidget swtMetawidget) {
        if ("action".equals(string)) {
            return control;
        }
        if (control instanceof SwtMetawidget) {
            State state = this.getState(swtMetawidget);
            if (state.nestedMetawidgets == null) {
                state.nestedMetawidgets = CollectionUtils.newHashSet();
            }
            state.nestedMetawidgets.add((SwtMetawidget)control);
            return control;
        }
        String string2 = swtMetawidget.getValueProperty(control);
        if (string2 == null) {
            return control;
        }
        State state = this.getState(swtMetawidget);
        Realm realm = state.bindingContext.getValidationRealm();
        IObservableValue iObservableValue = BeanProperties.value((String)string2).observe(realm, (Object)control);
        UpdateValueStrategy updateValueStrategy = "true".equals(map.get("no-setter")) ? new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER) : new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST);
        Object t = swtMetawidget.getToInspect();
        String string3 = PathUtils.parsePath(swtMetawidget.getInspectionPath()).getNames().replace('/', '.');
        if ("property".equals(string)) {
            if (string3.length() > 0) {
                string3 = string3 + '.';
            }
            string3 = string3 + map.get("name");
        }
        IObservableValue iObservableValue2 = PojoObservables.observeValue((Realm)realm, t, (String)string3);
        UpdateValueStrategy updateValueStrategy2 = new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST);
        updateValueStrategy.setConverter(this.getConverter((Class)iObservableValue.getValueType(), (Class)iObservableValue2.getValueType()));
        updateValueStrategy2.setConverter(this.getConverter((Class)iObservableValue2.getValueType(), (Class)iObservableValue.getValueType()));
        state.bindingContext.bindValue(iObservableValue, iObservableValue2, updateValueStrategy, updateValueStrategy2);
        return control;
    }

    public Object convertFromString(String string, Class<?> clazz) {
        IConverter iConverter = this.getConverter(String.class, clazz);
        if (iConverter != null) {
            return iConverter.convert((Object)string);
        }
        return string;
    }

    @Override
    public void onEndBuild(SwtMetawidget swtMetawidget) {
        State state = this.getState(swtMetawidget);
        state.bindingContext.updateTargets();
    }

    public void save(SwtMetawidget swtMetawidget) {
        State state = this.getState(swtMetawidget);
        state.bindingContext.updateModels();
        for (Object object : state.bindingContext.getValidationStatusProviders()) {
            Binding binding = (Binding)object;
            BindingStatus bindingStatus = (BindingStatus)binding.getValidationStatus().getValue();
            if (bindingStatus.isOK()) continue;
            throw WidgetProcessorException.newException(bindingStatus.getException());
        }
        if (state.nestedMetawidgets != null) {
            for (SwtMetawidget swtMetawidget2 : state.nestedMetawidgets) {
                this.save(swtMetawidget2);
            }
        }
    }

    private State getState(SwtMetawidget swtMetawidget) {
        State state = (State)swtMetawidget.getData(DataBindingProcessor.class.getName());
        if (state == null) {
            state = new State();
            state.bindingContext = new DataBindingContext(this.getRealm(swtMetawidget.getDisplay()));
            swtMetawidget.setData(DataBindingProcessor.class.getName(), state);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Realm getRealm(Display display) {
        List<DisplayRealm> list = this.mRealms;
        synchronized (list) {
            for (DisplayRealm displayRealm : this.mRealms) {
                if (displayRealm.mDisplay != display) continue;
                return displayRealm;
            }
            Object object = new DisplayRealm(display);
            this.mRealms.add((DisplayRealm)((Object)object));
            return object;
        }
    }

    private IConverter getConverter(Class<?> clazz, Class<?> clazz2) {
        for (Class<?> clazz3 = clazz; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            IConverter iConverter = this.mConverters.get(new ConvertFromTo(clazz3, clazz2));
            if (iConverter == null) continue;
            return iConverter;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ConvertFromTo {
        private Class<?> mSource;
        private Class<?> mTarget;

        public ConvertFromTo(Class<?> clazz, Class<?> clazz2) {
            this.mSource = clazz;
            this.mTarget = clazz2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!ObjectUtils.nullSafeClassEquals(this, object)) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals(this.mSource, ((ConvertFromTo)object).mSource)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.mTarget, ((ConvertFromTo)object).mTarget);
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + ObjectUtils.nullSafeHashCode(this.mSource.hashCode());
            n = 31 * n + ObjectUtils.nullSafeHashCode(this.mTarget.hashCode());
            return n;
        }
    }

    static class DisplayRealm
    extends Realm {
        Display mDisplay;

        DisplayRealm(Display display) {
            this.mDisplay = display;
        }

        public boolean isCurrent() {
            return Display.getCurrent() == this.mDisplay;
        }
    }

    static class State {
        DataBindingContext bindingContext;
        Set<SwtMetawidget> nestedMetawidgets;

        State() {
        }
    }
}

