/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util;

import java.lang.reflect.Array;
import java.util.List;
import java.util.regex.Pattern;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String toString(Object object) {
        return ArrayUtils.toString(object, StringUtils.SEPARATOR_COMMA);
    }

    public static String toString(Object object, String string) {
        return ArrayUtils.toString(object, string, false, false);
    }

    public static String toString(Object object, String string, boolean bl, boolean bl2) {
        if (object == null) {
            return "";
        }
        if (!object.getClass().isArray()) {
            throw new UnsupportedOperationException("Not an array");
        }
        Pattern pattern = Pattern.compile(string, 16);
        String string2 = "\\\\" + string;
        StringBuilder stringBuilder = new StringBuilder();
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            String string3 = String.valueOf(Array.get(object, i));
            if (stringBuilder.length() > 0 || bl) {
                stringBuilder.append(string);
            }
            string3 = pattern.matcher(string3).replaceAll(string2);
            stringBuilder.append(string3);
        }
        if (bl2 && stringBuilder.length() > 0) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String[] fromString(String string) {
        return ArrayUtils.fromString(string, ',');
    }

    public static String[] fromString(String string, char c) {
        if (string == null) {
            return EMPTY_STRING_ARRAY;
        }
        List<String> list = CollectionUtils.fromString(string, c);
        return list.toArray(new String[list.size()]);
    }

    public static <T> T[] add(T[] TArray, T ... TArray2) {
        if (TArray == null) {
            return TArray2;
        }
        return ArrayUtils.addAt(TArray, TArray.length, TArray2);
    }

    public static <T> T[] addAt(T[] TArray, int n, T ... TArray2) {
        if (TArray == null) {
            return TArray2;
        }
        if (TArray2 == null) {
            return TArray;
        }
        int n2 = TArray2.length;
        if (n2 == 0) {
            return TArray;
        }
        int n3 = TArray.length;
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n3 + n2);
        if (n > 0) {
            System.arraycopy(TArray, 0, objectArray, 0, n);
        }
        System.arraycopy(TArray2, 0, objectArray, n, n2);
        if (n < TArray.length) {
            System.arraycopy(TArray, n, objectArray, n + n2, TArray.length - n);
        }
        return objectArray;
    }

    public static <T> boolean contains(T[] TArray, T t) {
        return ArrayUtils.indexOf(TArray, t) != -1;
    }

    public static <T> int indexOf(T[] TArray, T t) {
        if (TArray == null) {
            return -1;
        }
        for (int i = 0; i < TArray.length; ++i) {
            T t2 = TArray[i];
            if (!(t2 == null ? t == null : t2.equals(t))) continue;
            return i;
        }
        return -1;
    }

    public static <T> T[] removeAt(T[] TArray, int n) {
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length - 1);
        if (n > 0) {
            System.arraycopy(TArray, 0, objectArray, 0, n);
        }
        if (n < TArray.length - 1) {
            System.arraycopy(TArray, n + 1, objectArray, n, TArray.length - (n + 1));
        }
        return objectArray;
    }

    private ArrayUtils() {
    }
}

