/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessControlException;
import java.util.Set;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtils {
    public static final String JAVABEAN_SET_PREFIX = "set";
    public static final String JAVABEAN_GET_PREFIX = "get";
    public static final String JAVABEAN_IS_PREFIX = "is";
    static final Set<ClassLoader> ALIEN_CLASSLOADERS = CollectionUtils.newHashSet();

    public static Method getReadMethod(Class<?> clazz, String string) {
        String string2 = StringUtils.capitalize(string);
        try {
            return clazz.getMethod(JAVABEAN_GET_PREFIX + string2, new Class[0]);
        }
        catch (Exception exception) {
            try {
                Method method = clazz.getMethod(JAVABEAN_IS_PREFIX + string2, new Class[0]);
                if (Boolean.TYPE.equals(method.getReturnType())) {
                    return method;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new RuntimeException("No such method get" + string2 + " (or boolean " + JAVABEAN_IS_PREFIX + string2 + ") on " + clazz);
        }
    }

    public static Method getWriteMethod(Class<?> clazz, String string, Class<?> clazz2) {
        String string2 = StringUtils.capitalize(string);
        for (Class<?> clazz3 = clazz2; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            try {
                return clazz.getMethod(JAVABEAN_SET_PREFIX + string2, clazz3);
            }
            catch (Exception exception) {
                continue;
            }
        }
        for (Class<?> clazz4 : clazz2.getInterfaces()) {
            try {
                return clazz.getMethod(JAVABEAN_SET_PREFIX + string2, clazz4);
            }
            catch (Exception exception) {
            }
        }
        throw new RuntimeException("No such method set" + string2 + "( " + clazz2.getName() + " ) on " + clazz);
    }

    public static <T> T getProperty(Object object, String string) {
        try {
            Method method = ClassUtils.getReadMethod(object.getClass(), string);
            return (T)method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            if (object == null) {
                throw new RuntimeException("Unable to get '" + string + "' because base is null", exception);
            }
            throw new RuntimeException("Unable to get '" + string + "' of '" + object + "' (" + object.getClass() + ")", exception);
        }
    }

    public static void setProperty(Object object, String string, Object object2) {
        try {
            Class<?> clazz = object.getClass();
            Method method = ClassUtils.getReadMethod(clazz, string);
            method = ClassUtils.getWriteMethod(clazz, string, method.getReturnType());
            method.invoke(object, object2);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to set '" + string + "' of '" + object + "' to '" + object2 + "'", exception);
        }
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        if (Number.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Character.class.isAssignableFrom(clazz);
    }

    public static Class<?> getWrapperClass(Class<?> clazz) {
        if (Byte.TYPE.equals(clazz)) {
            return Byte.class;
        }
        if (Short.TYPE.equals(clazz)) {
            return Short.class;
        }
        if (Integer.TYPE.equals(clazz)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(clazz)) {
            return Long.class;
        }
        if (Float.TYPE.equals(clazz)) {
            return Float.class;
        }
        if (Double.TYPE.equals(clazz)) {
            return Double.class;
        }
        if (Boolean.TYPE.equals(clazz)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(clazz)) {
            return Character.class;
        }
        throw new RuntimeException(clazz + " is not a primitive type");
    }

    public static boolean classExists(String string) {
        try {
            Class.forName(string, false, null);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    public static Object parseNumber(Class<?> clazz, String string) {
        if (string == null || "".equals(string)) {
            return null;
        }
        if (Byte.TYPE.equals(clazz)) {
            return Byte.parseByte(string);
        }
        if (Byte.class.equals(clazz)) {
            return Byte.valueOf(string);
        }
        if (Short.TYPE.equals(clazz)) {
            return Short.parseShort(string);
        }
        if (Short.class.equals(clazz)) {
            return Short.valueOf(string);
        }
        if (Integer.TYPE.equals(clazz)) {
            return Integer.parseInt(string);
        }
        if (Integer.class.equals(clazz)) {
            return Integer.valueOf(string);
        }
        if (Long.TYPE.equals(clazz)) {
            return Long.parseLong(string);
        }
        if (Long.class.equals(clazz)) {
            return Long.valueOf(string);
        }
        if (Float.TYPE.equals(clazz)) {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (Float.class.equals(clazz)) {
            return Float.valueOf(string);
        }
        if (Double.TYPE.equals(clazz)) {
            return Double.parseDouble(string);
        }
        if (Double.class.equals(clazz)) {
            return Double.valueOf(string);
        }
        throw new RuntimeException(clazz + " is not a number type");
    }

    public static Object getNumberMinValue(Class<?> clazz) {
        if (Byte.TYPE.equals(clazz) || Byte.class.equals(clazz)) {
            return (byte)-128;
        }
        if (Short.TYPE.equals(clazz) || Short.class.equals(clazz)) {
            return (short)Short.MIN_VALUE;
        }
        if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
            return Integer.MIN_VALUE;
        }
        if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
            return Integer.MIN_VALUE;
        }
        if (Long.TYPE.equals(clazz) || Long.class.equals(clazz)) {
            return Long.MIN_VALUE;
        }
        if (Float.TYPE.equals(clazz) || Float.class.equals(clazz)) {
            return Float.valueOf(-3.4028235E38f);
        }
        if (Double.TYPE.equals(clazz) || Double.class.equals(clazz)) {
            return -1.7976931348623157E308;
        }
        throw new RuntimeException(clazz + " is not a number type");
    }

    public static Object getNumberMaxValue(Class<?> clazz) {
        if (Byte.TYPE.equals(clazz) || Byte.class.equals(clazz)) {
            return (byte)127;
        }
        if (Short.TYPE.equals(clazz) || Short.class.equals(clazz)) {
            return (short)Short.MAX_VALUE;
        }
        if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
            return Integer.MAX_VALUE;
        }
        if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
            return Integer.MAX_VALUE;
        }
        if (Long.TYPE.equals(clazz) || Long.class.equals(clazz)) {
            return Long.MAX_VALUE;
        }
        if (Float.TYPE.equals(clazz) || Float.class.equals(clazz)) {
            return Float.valueOf(Float.MAX_VALUE);
        }
        if (Double.TYPE.equals(clazz) || Double.class.equals(clazz)) {
            return Double.MAX_VALUE;
        }
        throw new RuntimeException(clazz + " is not a number type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAlienClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            return;
        }
        if (classLoader.equals(Thread.currentThread().getContextClassLoader())) {
            return;
        }
        if (classLoader.equals(ClassUtils.class.getClassLoader())) {
            return;
        }
        Set<ClassLoader> set = ALIEN_CLASSLOADERS;
        synchronized (set) {
            ALIEN_CLASSLOADERS.add(classLoader);
        }
    }

    public static Class<?> niceForName(String string) {
        return ClassUtils.niceForName(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> niceForName(String string, ClassLoader classLoader) {
        String string2 = string;
        int n = string2.indexOf(60);
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        try {
            if (classLoader != null) {
                return Class.forName(string2, false, classLoader);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        try {
            if (classLoader2 != null && !classLoader2.equals(classLoader)) {
                return Class.forName(string2, false, classLoader2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ClassLoader classLoader3 = ClassUtils.class.getClassLoader();
        try {
            if (!classLoader3.equals(classLoader2) && !classLoader3.equals(classLoader)) {
                return Class.forName(string2, false, classLoader3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Set<ClassLoader> set = ALIEN_CLASSLOADERS;
        synchronized (set) {
            for (ClassLoader classLoader4 : ALIEN_CLASSLOADERS) {
                try {
                    return Class.forName(string2, false, classLoader4);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        return ClassUtils.getPrimitive(string2);
    }

    public static boolean isPrimitive(String string) {
        return ClassUtils.getPrimitive(string) != null;
    }

    public static String getSimpleName(String string) {
        return StringUtils.substringAfterLast(string, '.');
    }

    public static Class<?> getOriginalDeclaringClass(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        for (Class<?> clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            try {
                clazz2.getDeclaredMethod(method.getName(), method.getParameterTypes());
                clazz = clazz2;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return clazz;
    }

    public static String getPackagesAsFolderNames(Class<?> clazz) {
        return '/' + clazz.getPackage().getName().replace('.', '/');
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Annotation> T getOriginalAnnotation(Method method, Class<T> clazz) {
        T t;
        Method method2 = method;
        String string = method2.getName();
        Class<?>[] classArray = method2.getParameterTypes();
        while (method2.getAnnotations().length == 0) {
            void object;
            Class<?> clazz2 = method2.getDeclaringClass().getSuperclass();
            method2 = null;
            while (object != null) {
                try {
                    method2 = object.getDeclaredMethod(string, classArray);
                    break;
                }
                catch (Exception exception) {
                    Class clazz3 = object.getSuperclass();
                }
            }
            if (method2 != null) continue;
            break;
        }
        if (method2 != null && (t = method2.getAnnotation(clazz)) != null) {
            return t;
        }
        for (Class<?> clazz4 : method.getDeclaringClass().getInterfaces()) {
            try {
                method2 = clazz4.getDeclaredMethod(string, classArray);
                T t2 = method2.getAnnotation(clazz);
                if (t2 == null) continue;
                return t2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Type getOriginalGenericReturnType(Method method) {
        Method method2 = method;
        String string = method2.getName();
        Class<?>[] classArray = method2.getParameterTypes();
        block2: do {
            Type type;
            if ((type = method2.getGenericReturnType()) instanceof ParameterizedType) {
                return type;
            }
            Class<?> clazz = method2.getDeclaringClass().getSuperclass();
            method2 = null;
            while (clazz != null) {
                try {
                    method2 = clazz.getDeclaredMethod(string, classArray);
                    continue block2;
                }
                catch (Exception exception) {
                    clazz = clazz.getSuperclass();
                }
            }
        } while (method2 != null);
        return method.getGenericReturnType();
    }

    public static Type[] getOriginalGenericParameterTypes(Method method) {
        Method method2 = method;
        String string = method2.getName();
        Class<?>[] classArray = method2.getParameterTypes();
        block2: do {
            Type[] typeArray;
            if ((typeArray = method2.getGenericParameterTypes())[0] instanceof ParameterizedType) {
                return typeArray;
            }
            Class<?> clazz = method2.getDeclaringClass().getSuperclass();
            method2 = null;
            while (clazz != null) {
                try {
                    method2 = clazz.getDeclaredMethod(string, classArray);
                    continue block2;
                }
                catch (Exception exception) {
                    clazz = clazz.getSuperclass();
                }
            }
        } while (method2 != null);
        return method.getGenericParameterTypes();
    }

    public static String getGenericTypeAsString(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        Type[] typeArray = null;
        try {
            typeArray = ((ParameterizedType)type).getActualTypeArguments();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (typeArray == null || typeArray.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Type type2 : typeArray) {
            if (type2 == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(StringUtils.SEPARATOR_COMMA);
            }
            if (type2 instanceof Class) {
                stringBuilder.append(((Class)type2).getName());
                continue;
            }
            stringBuilder.append(type2.toString());
        }
        return stringBuilder.toString();
    }

    private static Class<?> getPrimitive(String string) {
        if ("byte".equals(string)) {
            return Byte.TYPE;
        }
        if ("short".equals(string)) {
            return Short.TYPE;
        }
        if ("int".equals(string)) {
            return Integer.TYPE;
        }
        if ("long".equals(string)) {
            return Long.TYPE;
        }
        if ("float".equals(string)) {
            return Float.TYPE;
        }
        if ("double".equals(string)) {
            return Double.TYPE;
        }
        if ("boolean".equals(string)) {
            return Boolean.TYPE;
        }
        if ("char".equals(string)) {
            return Character.TYPE;
        }
        return null;
    }

    private ClassUtils() {
    }
}

