/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtils {
    public static final <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    public static final <T> ArrayList<T> newArrayList(Collection<T> collection) {
        return new ArrayList<T>(collection);
    }

    public static final <T> ArrayList<T> newArrayList(int n) {
        return new ArrayList(n);
    }

    public static final <T> ArrayList<T> newArrayList(T ... TArray) {
        if (TArray == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(Arrays.asList(TArray));
    }

    public static final <K> HashSet<K> newHashSet() {
        return new HashSet();
    }

    public static final <K> HashSet<K> newHashSet(Collection<K> collection) {
        return new HashSet<K>(collection);
    }

    public static final <K> HashSet<K> newHashSet(K ... KArray) {
        return new HashSet<K>(Arrays.asList(KArray));
    }

    public static final <K> Stack<K> newStack() {
        return new Stack();
    }

    public static final <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static final <K, V> HashMap<K, V> newHashMap(Map<K, V> map) {
        return new HashMap<K, V>(map);
    }

    public static final <K, V> HashMap<K, V> newHashMap(int n) {
        return new HashMap(n);
    }

    public static final <K, V> Map<K, V> newHashMap(List<K> list, List<V> list2) {
        if (list.size() != list2.size()) {
            throw WidgetBuilderException.newException("Keys list must be same size as values list");
        }
        HashMap<K, V> hashMap = CollectionUtils.newHashMap();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            hashMap.put(list.get(i), list2.get(i));
        }
        return hashMap;
    }

    public static final <K, V> WeakHashMap<K, V> newWeakHashMap() {
        return new WeakHashMap();
    }

    public static final <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static final <K, V> LinkedHashMap<K, V> newLinkedHashMap(Map<K, V> map) {
        return new LinkedHashMap<K, V>(map);
    }

    public static final <K, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static final <K, V> TreeMap<K, V> newTreeMap(Comparator<K> comparator) {
        return new TreeMap(comparator);
    }

    public static <T> List<T> unmodifiableList(T ... TArray) {
        return Collections.unmodifiableList(Arrays.asList(TArray));
    }

    public static <T> String toString(Collection<T> collection) {
        return CollectionUtils.toString(collection, StringUtils.SEPARATOR_COMMA);
    }

    public static <T> String toString(Collection<T> collection, String string) {
        return CollectionUtils.toString(collection, string, false, false);
    }

    public static <T> String toString(Collection<T> collection, String string, boolean bl, boolean bl2) {
        if (collection == null) {
            return "";
        }
        Collection<T> collection2 = collection;
        if (collection2 instanceof Set) {
            collection2 = CollectionUtils.newArrayList(collection);
            Collections.sort((List)collection2, null);
        }
        Pattern pattern = Pattern.compile(string, 16);
        String string2 = "\\\\" + string;
        StringBuilder stringBuilder = new StringBuilder();
        for (T t : collection2) {
            String string3 = String.valueOf(t);
            if (stringBuilder.length() > 0 || bl) {
                stringBuilder.append(string);
            }
            string3 = pattern.matcher(string3).replaceAll(string2);
            stringBuilder.append(string3);
        }
        if (bl2 && stringBuilder.length() > 0) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static List<String> fromString(String string) {
        return CollectionUtils.fromString(string, ',');
    }

    public static List<String> fromString(String string, char c) {
        if (string == null || string.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = CollectionUtils.newArrayList();
        Pattern pattern = Pattern.compile("((\\\\" + c + "|[^" + c + "])*)(" + c + "|$)");
        Pattern pattern2 = Pattern.compile("\\" + c, 16);
        String string2 = String.valueOf(c);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string3 = matcher.group(1).trim();
            string3 = pattern2.matcher(string3).replaceAll(string2);
            arrayList.add(string3);
            if (matcher.end(1) != string.length()) continue;
            break;
        }
        return arrayList;
    }

    private CollectionUtils() {
    }
}

