/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogUtils {
    static String LAST_TRACE_MESSAGE;
    static Object[] LAST_TRACE_ARGUMENTS;
    static String LAST_DEBUG_MESSAGE;
    static Object[] LAST_DEBUG_ARGUMENTS;
    static String LAST_INFO_MESSAGE;
    static String LAST_WARN_MESSAGE;
    static String LAST_ERROR_MESSAGE;

    public static Log getLog(Class<?> clazz) {
        try {
            return new CommonsLog(clazz);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return new UtilLog(clazz.getName());
        }
    }

    private LogUtils() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommonsLog
    implements Log {
        private org.apache.commons.logging.Log mLog;

        public CommonsLog(Class<?> clazz) {
            this.mLog = LogFactory.getLog(clazz);
        }

        @Override
        public boolean isTraceEnabled() {
            return this.mLog.isTraceEnabled();
        }

        @Override
        public void trace(String string, Object ... objectArray) {
            String string2 = string;
            if (this.isTraceEnabled()) {
                int n = objectArray.length - 1;
                if (n == -1) {
                    this.mLog.trace((Object)string2);
                } else {
                    if (objectArray[n] instanceof Throwable && string.indexOf("{" + n + "}") == -1) {
                        if (n > 0) {
                            string2 = MessageFormat.format(string2, objectArray);
                        }
                        this.mLog.trace((Object)string2, (Throwable)objectArray[n]);
                        --n;
                    } else {
                        string2 = MessageFormat.format(string2, objectArray);
                        this.mLog.trace((Object)string2);
                    }
                    if (n != -1 && string.indexOf("{" + n + "}") == -1) {
                        throw new RuntimeException("Given " + (n + 1) + " arguments to log, but no {" + n + "} in message '" + string + "'");
                    }
                }
            }
            LAST_TRACE_MESSAGE = string2;
            LAST_TRACE_ARGUMENTS = objectArray;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.mLog.isDebugEnabled();
        }

        @Override
        public void debug(String string, Object ... objectArray) {
            String string2 = string;
            if (this.isDebugEnabled()) {
                int n = objectArray.length - 1;
                if (n == -1) {
                    this.mLog.debug((Object)string2);
                } else {
                    if (objectArray[n] instanceof Throwable && string.indexOf("{" + n + "}") == -1) {
                        if (n > 0) {
                            string2 = MessageFormat.format(string2, objectArray);
                        }
                        this.mLog.debug((Object)string2, (Throwable)objectArray[n]);
                        --n;
                    } else {
                        string2 = MessageFormat.format(string2, objectArray);
                        this.mLog.debug((Object)string2);
                    }
                    if (n != -1 && string.indexOf("{" + n + "}") == -1) {
                        throw new RuntimeException("Given " + (n + 1) + " arguments to log, but no {" + n + "} in message '" + string + "'");
                    }
                }
            }
            LAST_DEBUG_MESSAGE = string2;
            LAST_DEBUG_ARGUMENTS = objectArray;
        }

        @Override
        public boolean isInfoEnabled() {
            return this.mLog.isInfoEnabled();
        }

        @Override
        public void info(String string, Object ... objectArray) {
            String string2 = string;
            if (this.isInfoEnabled()) {
                int n = objectArray.length - 1;
                if (n == -1) {
                    this.mLog.info((Object)string2);
                } else {
                    if (objectArray[n] instanceof Throwable && string.indexOf("{" + n + "}") == -1) {
                        if (n > 0) {
                            string2 = MessageFormat.format(string2, objectArray);
                        }
                        this.mLog.info((Object)string2, (Throwable)objectArray[n]);
                        --n;
                    } else {
                        string2 = MessageFormat.format(string2, objectArray);
                        this.mLog.info((Object)string2);
                    }
                    if (n != -1 && string.indexOf("{" + n + "}") == -1) {
                        throw new RuntimeException("Given " + (n + 1) + " arguments to log, but no {" + n + "} in message '" + string + "'");
                    }
                }
            }
            LAST_INFO_MESSAGE = string2;
        }

        @Override
        public boolean isWarnEnabled() {
            return this.mLog.isWarnEnabled();
        }

        @Override
        public void warn(String string, Object ... objectArray) {
            String string2 = string;
            if (this.isWarnEnabled()) {
                int n = objectArray.length - 1;
                if (n == -1) {
                    this.mLog.warn((Object)string2);
                } else {
                    if (objectArray[n] instanceof Throwable && string.indexOf("{" + n + "}") == -1) {
                        if (n > 0) {
                            string2 = MessageFormat.format(string2, objectArray);
                        }
                        this.mLog.warn((Object)string2, (Throwable)objectArray[n]);
                        --n;
                    } else {
                        string2 = MessageFormat.format(string2, objectArray);
                        this.mLog.warn((Object)string2);
                    }
                    if (n != -1 && string.indexOf("{" + n + "}") == -1) {
                        throw new RuntimeException("Given " + (n + 1) + " arguments to log, but no {" + n + "} in message '" + string + "'");
                    }
                }
            }
            LAST_WARN_MESSAGE = string2;
        }

        @Override
        public boolean isErrorEnabled() {
            return this.mLog.isErrorEnabled();
        }

        @Override
        public void error(String string, Object ... objectArray) {
            if (!this.isErrorEnabled()) {
                return;
            }
            String string2 = string;
            int n = objectArray.length - 1;
            if (n == -1) {
                this.mLog.error((Object)string2);
            } else {
                if (objectArray[n] instanceof Throwable && string.indexOf("{" + n + "}") == -1) {
                    if (n > 0) {
                        string2 = MessageFormat.format(string2, objectArray);
                    }
                    this.mLog.error((Object)string2, (Throwable)objectArray[n]);
                    --n;
                } else {
                    string2 = MessageFormat.format(string2, objectArray);
                    this.mLog.error((Object)string2);
                }
                if (n != -1 && string.indexOf("{" + n + "}") == -1) {
                    throw new RuntimeException("Given " + (n + 1) + " arguments to log, but no {" + n + "} in message '" + string + "'");
                }
            }
            LAST_ERROR_MESSAGE = string2;
        }
    }

    private static class UtilLog
    implements Log {
        private Logger mLogger;

        public UtilLog(String string) {
            this.mLogger = Logger.getLogger(string);
        }

        public boolean isTraceEnabled() {
            return this.mLogger.isLoggable(Level.FINER);
        }

        public void trace(String string, Object ... objectArray) {
            LAST_TRACE_MESSAGE = this.log(Level.FINER, string, objectArray);
        }

        public boolean isDebugEnabled() {
            return this.mLogger.isLoggable(Level.FINE);
        }

        public void debug(String string, Object ... objectArray) {
            LAST_DEBUG_MESSAGE = this.log(Level.FINE, string, objectArray);
        }

        public boolean isInfoEnabled() {
            return this.mLogger.isLoggable(Level.INFO);
        }

        public void info(String string, Object ... objectArray) {
            LAST_INFO_MESSAGE = this.log(Level.INFO, string, objectArray);
        }

        public boolean isWarnEnabled() {
            return this.mLogger.isLoggable(Level.WARNING);
        }

        public void warn(String string, Object ... objectArray) {
            LAST_WARN_MESSAGE = this.log(Level.WARNING, string, objectArray);
        }

        public boolean isErrorEnabled() {
            return this.mLogger.isLoggable(Level.SEVERE);
        }

        public void error(String string, Object ... objectArray) {
            LAST_ERROR_MESSAGE = this.log(Level.SEVERE, string, objectArray);
        }

        private String log(Level level, String string, Object ... objectArray) {
            String string2 = string;
            if (this.mLogger.isLoggable(level)) {
                int n = objectArray.length - 1;
                if (n == -1) {
                    this.mLogger.log(level, string2);
                } else {
                    if (objectArray[n] instanceof Throwable && string.indexOf("{" + n + "}") == -1) {
                        if (n > 0) {
                            string2 = MessageFormat.format(string2, objectArray);
                        }
                        this.mLogger.log(level, string2, (Throwable)objectArray[n]);
                        --n;
                    } else {
                        string2 = MessageFormat.format(string2, objectArray);
                        this.mLogger.log(level, string2);
                    }
                    if (n != -1 && string.indexOf("{" + n + "}") == -1) {
                        throw new RuntimeException("Given " + (n + 1) + " arguments to log, but no {" + n + "} in message '" + string + "'");
                    }
                }
            }
            return string2;
        }
    }

    public static interface Log {
        public boolean isTraceEnabled();

        public void trace(String var1, Object ... var2);

        public boolean isDebugEnabled();

        public void debug(String var1, Object ... var2);

        public boolean isInfoEnabled();

        public void info(String var1, Object ... var2);

        public boolean isWarnEnabled();

        public void warn(String var1, Object ... var2);

        public boolean isErrorEnabled();

        public void error(String var1, Object ... var2);
    }
}

