/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util;

import java.util.Map;
import org.metawidget.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WidgetBuilderUtils {
    public static boolean isReadOnly(Map<String, String> map) {
        if ("true".equals(map.get("read-only"))) {
            return true;
        }
        return "true".equals(map.get("no-setter"));
    }

    public static Class<?> getActualClassOrType(Map<String, String> map, Class<?> clazz) {
        return WidgetBuilderUtils.getActualClassOrType(map, clazz, null);
    }

    public static Class<?> getActualClassOrType(Map<String, String> map, Class<?> clazz, ClassLoader classLoader) {
        String string = map.get("actual-class");
        if ((string == null || "".equals(string)) && ((string = map.get("type")) == null || "".equals(string))) {
            return clazz;
        }
        return ClassUtils.niceForName(string, classLoader);
    }

    public static String getComponentType(Map<String, String> map) {
        String string = map.get("parameterized-type");
        if (string != null) {
            return string;
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(map, null);
        if (clazz == null) {
            return null;
        }
        if (clazz.isArray()) {
            return clazz.getComponentType().getName();
        }
        return null;
    }

    public static boolean needsEmptyLookupItem(Map<String, String> map) {
        if ("true".equals(map.get("lookup-has-empty-choice"))) {
            return true;
        }
        if ("true".equals(map.get("required"))) {
            return false;
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(map, null);
        return clazz == null || !clazz.isPrimitive();
    }

    private WidgetBuilderUtils() {
    }
}

