/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.metawidget.util.CollectionUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtils {
    private static final DocumentBuilder DOCUMENT_BUILDER;
    private static final Pattern PATTERN_AMP;
    private static final Pattern PATTERN_LT;
    private static final Pattern PATTERN_GT;
    private static final Pattern PATTERN_QUOT;
    private static final Pattern PATTERN_APOS;

    public static Map<String, String> getAttributesAsMap(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap.getLength();
        if (n == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hashMap = CollectionUtils.newHashMap(n);
        for (int i = 0; i < n; ++i) {
            Node node2 = namedNodeMap.item(i);
            hashMap.put(node2.getNodeName(), node2.getNodeValue());
        }
        return hashMap;
    }

    public static void setMapAsAttributes(Element element, Map<String, String> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getValue();
            if (string == null) {
                element.removeAttribute(entry.getKey());
                continue;
            }
            element.setAttribute(entry.getKey(), string);
        }
    }

    public static Element getChildNamed(Element element, String ... stringArray) {
        if (element == null) {
            return null;
        }
        Element element2 = null;
        NodeList nodeList = element.getChildNodes();
        for (String string : stringArray) {
            block4: {
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Node node = nodeList.item(i);
                    if (!(node instanceof Element) || !string.equals((element2 = (Element)node).getLocalName())) {
                        continue;
                    }
                    break block4;
                }
                return null;
            }
            nodeList = element2.getChildNodes();
        }
        return element2;
    }

    public static Element getChildWithAttribute(Element element, String string) {
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(element2 = (Element)node).hasAttribute(string)) continue;
            return element2;
        }
        return null;
    }

    public static Element getChildWithAttributeValue(Element element, String string, String string2) {
        int n;
        NodeList nodeList;
        if (element == null) {
            return null;
        }
        try {
            nodeList = element.getChildNodes();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        try {
            n = nodeList.getLength();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            Node node;
            try {
                node = nodeList.item(i);
            }
            catch (NullPointerException nullPointerException) {
                continue;
            }
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            try {
                if (!string2.equals(element2.getAttribute(string))) continue;
                return element2;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Element getSiblingNamed(Element element, String string) {
        if (element == null) {
            return null;
        }
        Node node = element;
        do {
            if ((node = node.getNextSibling()) != null) continue;
            return null;
        } while (!(node instanceof Element) || !string.equals(node.getNodeName()));
        return (Element)node;
    }

    public static Element getSiblingWithAttribute(Element element, String string) {
        Node node;
        if (element == null) {
            return null;
        }
        Node node2 = element;
        do {
            if ((node2 = node2.getNextSibling()) != null) continue;
            return null;
        } while (!(node2 instanceof Element) || !(node = node2).hasAttribute(string));
        return node;
    }

    public static Element importElement(Document document, Element element) {
        try {
            return (Element)document.importNode(element, true);
        }
        catch (DOMException dOMException) {
            Element element2 = document.createElementNS(element.getNamespaceURI(), element.getNodeName());
            XmlUtils.setMapAsAttributes(element2, XmlUtils.getAttributesAsMap(element));
            NodeList nodeList = element2.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                element2.appendChild(XmlUtils.importElement(document, (Element)node));
            }
            return element2;
        }
    }

    public static String documentToString(Document document, boolean bl) {
        if (document == null) {
            return "";
        }
        return XmlUtils.nodeToString(document.getFirstChild(), bl);
    }

    public static String nodeToString(Node node, boolean bl) {
        return XmlUtils.nodeToString(node, bl ? 0 : -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document documentFromString(String string) {
        if (string == null) {
            return null;
        }
        try {
            DocumentBuilder documentBuilder = DOCUMENT_BUILDER;
            synchronized (documentBuilder) {
                return DOCUMENT_BUILDER.parse(new InputSource(new StringReader(string)));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocument() {
        DocumentBuilder documentBuilder = DOCUMENT_BUILDER;
        synchronized (documentBuilder) {
            return DOCUMENT_BUILDER.newDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(InputStream inputStream) throws IOException, SAXException {
        DocumentBuilder documentBuilder = DOCUMENT_BUILDER;
        synchronized (documentBuilder) {
            return DOCUMENT_BUILDER.parse(inputStream);
        }
    }

    public static Element getFirstChildElement(Element element) {
        Node node;
        for (node = element.getFirstChild(); node != null && !(node instanceof Element); node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static Element getNextSiblingElement(Element element) {
        try {
            Node node;
            for (node = element.getNextSibling(); node != null && !(node instanceof Element); node = node.getNextSibling()) {
            }
            return (Element)node;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public static void combineElements(Element element, Element element2, String string, String string2) {
        Object object;
        Object object2;
        NamedNodeMap namedNodeMap = element2.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            object2 = namedNodeMap.item(i);
            object = object2.getNodeName();
            String string3 = object2.getNodeValue();
            if (string3 == null || string3.length() == 0) {
                element.removeAttribute((String)object);
            }
            element.setAttribute((String)object, string3);
        }
        NodeList nodeList = element2.getChildNodes();
        NodeList nodeList2 = element.getChildNodes();
        object2 = CollectionUtils.newHashSet();
        object = null;
        int n2 = nodeList.getLength();
        block1: for (int i = 0; i < n2; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element3 = (Element)node;
            String string4 = element3.getAttribute(string);
            if (string4 == null || "".equals(string4)) {
                throw new RuntimeException("Child node #" + (i + 1) + " has no @" + string + ": " + XmlUtils.nodeToString((Node)element3, false));
            }
            if (!object2.add(string4)) {
                throw new RuntimeException("Element has more than one child with @" + string + " '" + string4 + "'");
            }
            int n3 = nodeList2.getLength();
            for (int j = 0; j < n3; ++j) {
                String string5;
                Element element4;
                String string6;
                Node node2 = nodeList2.item(j);
                if (!(node2 instanceof Element) || !string4.equals(string6 = (element4 = (Element)node2).getAttribute(string))) continue;
                String string7 = element4.getNodeName();
                if (!string7.equals(string5 = element3.getNodeName())) {
                    throw new RuntimeException("Matching elements named '" + string6 + "', but existing one is a '" + string7 + "' whilst new one is a '" + string5 + "'");
                }
                object = j == n3 - 1 ? null : element4;
                XmlUtils.combineElements(element4, element3, string2, string2);
                continue block1;
            }
            if (object != null) {
                Element element5 = XmlUtils.importElement(element.getOwnerDocument(), element3);
                element.insertBefore(element5, object.getNextSibling());
                object = element5;
                continue;
            }
            element.appendChild(XmlUtils.importElement(element.getOwnerDocument(), element3));
        }
    }

    public static String attributesToString(Attributes attributes) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" ");
            stringBuilder.append(attributes.getLocalName(i));
            stringBuilder.append("=\"");
            stringBuilder.append(attributes.getValue(i));
            stringBuilder.append("\"");
        }
        return stringBuilder.toString();
    }

    private static String nodeToString(Node node, int n) {
        NamedNodeMap namedNodeMap;
        Node node2;
        if (node == null) {
            return null;
        }
        if (!(node instanceof Element)) {
            String string = node.getNodeValue();
            if (string == null) {
                return null;
            }
            return XmlUtils.escapeForXml(string.trim());
        }
        StringBuilder stringBuilder = new StringBuilder();
        XmlUtils.indent(stringBuilder, n);
        String string = XmlUtils.escapeForXml(node.getNodeName());
        stringBuilder.append("<");
        stringBuilder.append(string);
        String string2 = node.getNamespaceURI();
        Node node3 = node.getParentNode();
        if (!(string2 == null || node3 != null && string2.equals(node3.getNamespaceURI()))) {
            stringBuilder.append(" xmlns=\"");
            stringBuilder.append(string2);
            stringBuilder.append("\"");
        }
        if ((node2 = (namedNodeMap = node.getAttributes()).getNamedItem("name")) != null) {
            stringBuilder.append(" name=\"");
            stringBuilder.append(XmlUtils.escapeForXml(node2.getNodeValue()));
            stringBuilder.append("\"");
        }
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node4 = namedNodeMap.item(i);
            String string3 = node4.getNodeName();
            if ("xmlns".equals(string3) || "name".equals(string3)) continue;
            stringBuilder.append(" ");
            stringBuilder.append(XmlUtils.escapeForXml(string3));
            stringBuilder.append("=\"");
            stringBuilder.append(XmlUtils.escapeForXml(node4.getNodeValue()));
            stringBuilder.append("\"");
        }
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        if (n2 == 0) {
            stringBuilder.append("/>");
        } else {
            stringBuilder.append(">");
            int n3 = n;
            if (n != -1) {
                ++n3;
            }
            for (int i = 0; i < n2; ++i) {
                Node node5 = nodeList.item(i);
                if (n != -1 && node5 instanceof Element) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(XmlUtils.nodeToString(node5, n3));
            }
            if (n != -1 && stringBuilder.charAt(stringBuilder.length() - 1) == '>') {
                stringBuilder.append("\n");
                XmlUtils.indent(stringBuilder, n);
            }
            stringBuilder.append("</");
            stringBuilder.append(string);
            stringBuilder.append(">");
        }
        return stringBuilder.toString();
    }

    private static void indent(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("   ");
        }
    }

    private static String escapeForXml(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string;
        string2 = PATTERN_AMP.matcher(string2).replaceAll("&amp;");
        string2 = PATTERN_LT.matcher(string2).replaceAll("&lt;");
        string2 = PATTERN_GT.matcher(string2).replaceAll("&gt;");
        string2 = PATTERN_QUOT.matcher(string2).replaceAll("&quot;");
        string2 = PATTERN_APOS.matcher(string2).replaceAll("&apos;");
        return string2;
    }

    private XmlUtils() {
    }

    static {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        try {
            DOCUMENT_BUILDER = documentBuilderFactory.newDocumentBuilder();
            DOCUMENT_BUILDER.setEntityResolver(new NopEntityResolver());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        PATTERN_AMP = Pattern.compile("&", 16);
        PATTERN_LT = Pattern.compile("<", 16);
        PATTERN_GT = Pattern.compile(">", 16);
        PATTERN_QUOT = Pattern.compile("\"", 16);
        PATTERN_APOS = Pattern.compile("'", 16);
    }

    static class NopEntityResolver
    implements EntityResolver {
        private static final byte[] BYTES = "<?xml version='1.0' encoding='UTF-8'?>".getBytes();

        NopEntityResolver() {
        }

        public InputSource resolveEntity(String string, String string2) {
            return new InputSource(new ByteArrayInputStream(BYTES));
        }
    }

    public static class CachingContentHandler
    extends DefaultHandler {
        private ContentHandler mDelegate;
        private CachedCommand mLastCommand;
        private ArrayList<CachedCommand> mCache = CollectionUtils.newArrayList();
        private boolean mCachingPaused;

        public CachingContentHandler(ContentHandler contentHandler) {
            this.mDelegate = contentHandler;
        }

        public boolean isPaused() {
            return this.mCachingPaused;
        }

        public void pause(boolean bl) {
            if (this.isPaused()) {
                throw new RuntimeException("CachingContentHandler already paused");
            }
            this.mCachingPaused = true;
            if (!bl) {
                this.mCache.remove(this.mCache.size() - 1);
            }
        }

        public void unpause(boolean bl) {
            if (!this.isPaused()) {
                throw new RuntimeException("CachingContentHandler not paused");
            }
            this.mCachingPaused = false;
            if (bl) {
                this.mCache.add(this.mLastCommand);
            }
        }

        public void replay(ContentHandler contentHandler) throws SAXException {
            if (this.mCache.isEmpty()) {
                throw new SAXException("Nothing to replay. Not cached any SAX events");
            }
            if (this.mDelegate != null) {
                throw new SAXException("Not ready to replay - ContentHandler delegate is non-null. Either endDocument must be triggered, or releaseDelegate must be called explicitly");
            }
            for (CachedCommand cachedCommand : this.mCache) {
                cachedCommand.replay(contentHandler);
            }
        }

        public void releaseDelegate() {
            this.mDelegate = null;
            this.mLastCommand = null;
            this.mCache.trimToSize();
        }

        public void startDocument() throws SAXException {
            this.mLastCommand = new StartDocumentCommand();
            if (!this.mCachingPaused) {
                if (!this.mCache.isEmpty()) {
                    throw new SAXException("Already cached SAX events. CachingContentHandler can only cache SAX events once");
                }
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void processingInstruction(String string, String string2) throws SAXException {
            this.mLastCommand = new ProcessingInstructionCommand(string, string2);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void setDocumentLocator(Locator locator) {
            this.mDelegate.setDocumentLocator(locator);
        }

        public void skippedEntity(String string) throws SAXException {
            this.mLastCommand = new SkippedEntityCommand(string);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
            this.mLastCommand = new StartPrefixMappingCommand(string, string2);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void endPrefixMapping(String string) throws SAXException {
            this.mLastCommand = new EndPrefixMappingCommand(string);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.mLastCommand = new StartElementCommand(string, string2, string3, attributes);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.mLastCommand = new CharactersCommand(cArray, n, n2);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.mLastCommand = new IgnorableWhitespaceCommand(cArray, n, n2);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this.mLastCommand = new EndElementCommand(string, string2, string3);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void endDocument() throws SAXException {
            this.mLastCommand = new EndDocumentCommand();
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
            this.releaseDelegate();
        }

        private static class EndDocumentCommand
        implements CachedCommand {
            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.endDocument();
            }

            public String toString() {
                return "endDocument";
            }
        }

        private static class EndElementCommand
        implements CachedCommand {
            private String mUri;
            private String mLocalName;
            private String mQName;

            public EndElementCommand(String string, String string2, String string3) {
                this.mUri = string;
                this.mLocalName = string2;
                this.mQName = string3;
            }

            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.endElement(this.mUri, this.mLocalName, this.mQName);
            }

            public String toString() {
                return "endElement " + this.mUri + " " + this.mLocalName + " " + this.mQName;
            }
        }

        private static class IgnorableWhitespaceCommand
        implements CachedCommand {
            private char[] mCharacters;

            public IgnorableWhitespaceCommand(char[] cArray, int n, int n2) {
                this.mCharacters = new char[n2];
                System.arraycopy(cArray, n, this.mCharacters, 0, n2);
            }

            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.ignorableWhitespace(this.mCharacters, 0, this.mCharacters.length);
            }

            public String toString() {
                return "ignorableWhitespace " + String.valueOf(this.mCharacters);
            }
        }

        private static class CharactersCommand
        implements CachedCommand {
            private char[] mCharacters;

            public CharactersCommand(char[] cArray, int n, int n2) {
                this.mCharacters = new char[n2];
                System.arraycopy(cArray, n, this.mCharacters, 0, n2);
            }

            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.characters(this.mCharacters, 0, this.mCharacters.length);
            }

            public String toString() {
                return "characters " + String.valueOf(this.mCharacters);
            }
        }

        private static class StartElementCommand
        implements CachedCommand {
            private String mUri;
            private String mLocalName;
            private String mQName;
            private Attributes mAttributes;

            public StartElementCommand(String string, String string2, String string3, Attributes attributes) {
                this.mUri = string;
                this.mLocalName = string2;
                this.mQName = string3;
                this.mAttributes = new AttributesImpl(attributes);
            }

            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.startElement(this.mUri, this.mLocalName, this.mQName, this.mAttributes);
            }

            public String toString() {
                return "startElement " + this.mUri + " " + this.mLocalName + " " + this.mQName + XmlUtils.attributesToString(this.mAttributes);
            }
        }

        private static class EndPrefixMappingCommand
        implements CachedCommand {
            private String mPrefix;

            public EndPrefixMappingCommand(String string) {
                this.mPrefix = string;
            }

            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.endPrefixMapping(this.mPrefix);
            }

            public String toString() {
                return "endPrefixMapping " + this.mPrefix;
            }
        }

        private static class StartPrefixMappingCommand
        implements CachedCommand {
            private String mPrefix;
            private String mUri;

            public StartPrefixMappingCommand(String string, String string2) {
                this.mPrefix = string;
                this.mUri = string2;
            }

            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.startPrefixMapping(this.mPrefix, this.mUri);
            }

            public String toString() {
                return "startPrefixMapping " + this.mPrefix + " " + this.mUri;
            }
        }

        private static class SkippedEntityCommand
        implements CachedCommand {
            private String mName;

            public SkippedEntityCommand(String string) {
                this.mName = string;
            }

            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.skippedEntity(this.mName);
            }

            public String toString() {
                return "skippedEntity " + this.mName;
            }
        }

        private static class ProcessingInstructionCommand
        implements CachedCommand {
            private String mTarget;
            private String mData;

            public ProcessingInstructionCommand(String string, String string2) {
                this.mTarget = string;
                this.mData = string2;
            }

            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.processingInstruction(this.mTarget, this.mData);
            }

            public String toString() {
                return "processInstruction " + this.mTarget + " " + this.mData;
            }
        }

        private static class StartDocumentCommand
        implements CachedCommand {
            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.startDocument();
            }

            public String toString() {
                return "startDocument";
            }
        }

        private static interface CachedCommand {
            public void replay(ContentHandler var1) throws SAXException;
        }
    }
}

