/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util.simple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectUtils {
    public static boolean nullSafeClassEquals(Object object, Object object2) {
        if (object == null || object2 == null) {
            return false;
        }
        return object.getClass() == object2.getClass();
    }

    public static int nullSafeHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (object.getClass().isArray()) {
            return ObjectUtils.deepHashCode((Object[])object);
        }
        return object.hashCode();
    }

    public static boolean nullSafeEquals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object.getClass().isArray()) {
            if (object2 == null || !object2.getClass().isArray()) {
                return false;
            }
            return ObjectUtils.deepEquals((Object[])object, (Object[])object2);
        }
        return object.equals(object2);
    }

    public static <T> int nullSafeCompareTo(Comparable<T> comparable, T t) {
        if (comparable == null) {
            if (t == null) {
                return 0;
            }
            return -1;
        }
        if (t == null) {
            return 1;
        }
        return comparable.compareTo(t);
    }

    private static int deepHashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 1;
        for (Object object : objectArray) {
            int n2 = 0;
            if (object instanceof Object[]) {
                n2 = ObjectUtils.deepHashCode((Object[])object);
            } else if (object != null) {
                n2 = object.hashCode();
            }
            n = 31 * n + n2;
        }
        return n;
    }

    private static boolean deepEquals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray.length;
        if (objectArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            Object object2 = objectArray2[i];
            if (object == object2) continue;
            if (object == null) {
                return false;
            }
            boolean bl = object instanceof Object[] && object2 instanceof Object[] ? ObjectUtils.deepEquals((Object[])object, (Object[])object2) : object.equals(object2);
            if (bl) continue;
            return false;
        }
        return true;
    }

    private ObjectUtils() {
    }
}

