/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util.simple;

public class PathUtils {
    static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static TypeAndNames parsePath(String string) {
        return new TypeAndNames(string, '/');
    }

    public static TypeAndNames parsePath(String string, char c) {
        return new TypeAndNames(string, c);
    }

    private PathUtils() {
    }

    public static class TypeAndNames {
        private String mPath;
        private char mSeparator;
        private String mParsedType;
        private String mParsedNames;
        private String[] mParsedNamesAsArray;

        public TypeAndNames(String string, char c) {
            this.mPath = string.trim();
            this.mSeparator = c;
        }

        public String getType() {
            if (this.mParsedType == null) {
                int n = this.mPath.indexOf(this.mSeparator);
                if (n == -1) {
                    this.mParsedType = this.mPath;
                    this.mParsedNames = "";
                } else {
                    this.mParsedType = this.mPath.substring(0, n);
                    this.mParsedNames = n == this.mPath.length() - 1 ? "" : this.mPath.substring(n + 1);
                }
            }
            return this.mParsedType;
        }

        public String getNames() {
            if (this.mParsedNames == null) {
                this.getType();
            }
            return this.mParsedNames;
        }

        public String[] getNamesAsArray() {
            if (this.mParsedNamesAsArray == null) {
                String string = this.getNames();
                this.mParsedNamesAsArray = "".equals(string) ? EMPTY_STRING_ARRAY : this.getNames().split("\\" + this.mSeparator);
            }
            return this.mParsedNamesAsArray;
        }
    }
}

