/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util.simple;

import java.util.Comparator;

public final class StringUtils {
    public static final char SEPARATOR_FORWARD_SLASH_CHAR = '/';
    public static final String SEPARATOR_FORWARD_SLASH = String.valueOf('/');
    public static final char SEPARATOR_DOT_CHAR = '.';
    public static final String SEPARATOR_DOT = String.valueOf('.');
    public static final char SEPARATOR_COMMA_CHAR = ',';
    public static final String SEPARATOR_COMMA = String.valueOf(',');
    public static final String RESOURCE_KEY_NOT_FOUND_PREFIX = "???";
    public static final String RESOURCE_KEY_NOT_FOUND_SUFFIX = "???";
    public static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            int n = string.compareToIgnoreCase(string2);
            if (n == 0) {
                n = string.compareTo(string2);
            }
            return n;
        }
    };

    public static String decapitalize(String string) {
        char c = string.charAt(0);
        if (Character.isLowerCase(c)) {
            return string;
        }
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1))) {
            return string;
        }
        return Character.toLowerCase(c) + string.substring(1);
    }

    public static String capitalize(String string) {
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1))) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String uncamelCase(String string) {
        return StringUtils.uncamelCase(string, ' ');
    }

    public static String uncamelCase(String string, char c) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl = true;
        char c2 = c;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < n; ++i) {
            char c3 = cArray[i];
            if (bl) {
                stringBuilder.append(Character.toUpperCase(c3));
                bl = false;
            } else if (Character.isUpperCase(c3) && (!Character.isUpperCase(c2) || i < cArray.length - 1 && cArray[i + 1] != c && !Character.isUpperCase(cArray[i + 1]))) {
                if (Character.isLetter(c2)) {
                    stringBuilder.append(c);
                }
                stringBuilder.append(c3);
            } else if (Character.isDigit(c3) && Character.isLetter(c2) && c2 != c) {
                stringBuilder.append(c);
                stringBuilder.append(c3);
            } else {
                stringBuilder.append(c3);
            }
            c2 = c3;
        }
        return stringBuilder.toString();
    }

    public static String camelCase(String string) {
        return StringUtils.camelCase(string, ' ');
    }

    public static String camelCase(String string, char c) {
        char[] cArray;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        for (char c2 : cArray = string.toCharArray()) {
            if (c2 == c) {
                bl = true;
                continue;
            }
            if (!Character.isLetter(c2) && !Character.isDigit(c2)) continue;
            if (stringBuilder.length() == 0) {
                stringBuilder.append(Character.toLowerCase(c2));
                continue;
            }
            if (bl) {
                stringBuilder.append(Character.toUpperCase(c2));
                bl = false;
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String quietValueOf(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static String substringBefore(String string, String string2) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String substringAfter(String string, String string2) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        return string.substring(n + string2.length());
    }

    public static String substringAfterLast(String string, char c) {
        int n = string.lastIndexOf(c);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String substringAfterLast(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (n == -1) {
            return string;
        }
        return string.substring(n + string2.length());
    }

    private StringUtils() {
    }
}

