/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.vaadin.ui;

import com.vaadin.terminal.PaintException;
import com.vaadin.terminal.PaintTarget;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CustomComponent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.metawidget.iface.MetawidgetException;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessor;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.layout.iface.Layout;
import org.metawidget.pipeline.w3c.W3CPipeline;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.vaadin.ui.Facet;
import org.metawidget.vaadin.ui.Stub;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VaadinMetawidget
extends CustomComponent {
    private Object mToInspect;
    private String mPath;
    private ResourceBundle mBundle;
    private boolean mNeedToBuildWidgets;
    private Element mLastInspection;
    private boolean mIgnoreAddRemove;
    private List<AbstractComponent> mExistingComponents = CollectionUtils.newArrayList();
    private List<AbstractComponent> mExistingUnusedComponents;
    private Map<Object, Facet> mFacets = CollectionUtils.newHashMap();
    private Map<Object, Object> mClientProperties;
    Pipeline mPipeline = this.newPipeline();

    public void setToInspect(Object object) {
        this.updateToInspectWithoutInvalidate(object);
        this.invalidateInspection();
    }

    public <T> T getToInspect() {
        return (T)this.mToInspect;
    }

    public void setPath(String string) {
        this.mPath = string;
        this.invalidateInspection();
    }

    public String getPath() {
        return this.mPath;
    }

    public void setConfig(String string) {
        this.mPipeline.setConfig(string);
        this.invalidateInspection();
    }

    public void setInspector(Inspector inspector) {
        this.mPipeline.setInspector(inspector);
        this.invalidateInspection();
    }

    public String inspect(Object object, String string, String ... stringArray) {
        return this.mPipeline.inspect(object, string, stringArray);
    }

    public void addInspectionResultProcessor(InspectionResultProcessor<VaadinMetawidget> inspectionResultProcessor) {
        this.mPipeline.addInspectionResultProcessor(inspectionResultProcessor);
        this.invalidateInspection();
    }

    public void removeInspectionResultProcessor(InspectionResultProcessor<VaadinMetawidget> inspectionResultProcessor) {
        this.mPipeline.removeInspectionResultProcessor(inspectionResultProcessor);
        this.invalidateInspection();
    }

    public void setInspectionResultProcessors(InspectionResultProcessor<VaadinMetawidget> ... inspectionResultProcessorArray) {
        this.mPipeline.setInspectionResultProcessors(inspectionResultProcessorArray);
        this.invalidateInspection();
    }

    public void setWidgetBuilder(WidgetBuilder<Component, VaadinMetawidget> widgetBuilder) {
        this.mPipeline.setWidgetBuilder(widgetBuilder);
        this.invalidateWidgets();
    }

    public void addWidgetProcessor(WidgetProcessor<Component, VaadinMetawidget> widgetProcessor) {
        this.mPipeline.addWidgetProcessor(widgetProcessor);
        this.invalidateWidgets();
    }

    public void removeWidgetProcessor(WidgetProcessor<Component, VaadinMetawidget> widgetProcessor) {
        this.mPipeline.removeWidgetProcessor(widgetProcessor);
        this.invalidateWidgets();
    }

    public void setWidgetProcessors(WidgetProcessor<Component, VaadinMetawidget> ... widgetProcessorArray) {
        this.mPipeline.setWidgetProcessors(widgetProcessorArray);
        this.invalidateWidgets();
    }

    public <T> T getWidgetProcessor(Class<T> clazz) {
        this.buildWidgets();
        return this.mPipeline.getWidgetProcessor(clazz);
    }

    public void setLayout(Layout<Component, ComponentContainer, VaadinMetawidget> layout) {
        this.mPipeline.setLayout(layout);
        this.invalidateWidgets();
    }

    public ResourceBundle getBundle() {
        return this.mBundle;
    }

    public void setBundle(ResourceBundle resourceBundle) {
        this.mBundle = resourceBundle;
        this.invalidateWidgets();
    }

    public String getLabelString(Map<String, String> map) {
        if (map == null) {
            return "";
        }
        String string = map.get("label");
        if (string != null) {
            if ("".equals(string)) {
                return null;
            }
            String string2 = this.getLocalizedKey(StringUtils.camelCase(string));
            if (string2 != null) {
                return string2.trim();
            }
            return string.trim();
        }
        String string3 = map.get("name");
        if (string3 != null) {
            String string4 = this.getLocalizedKey(string3);
            if (string4 != null) {
                return string4.trim();
            }
            return StringUtils.uncamelCase(string3);
        }
        return "";
    }

    public String getLocalizedKey(String string) {
        if (this.mBundle == null) {
            return null;
        }
        try {
            return this.mBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "???" + string + "???";
        }
    }

    public boolean isReadOnly() {
        return this.mPipeline.isReadOnly();
    }

    public void setReadOnly(boolean bl) {
        if (this.mPipeline.isReadOnly() == bl) {
            return;
        }
        this.mPipeline.setReadOnly(bl);
        this.invalidateWidgets();
    }

    public int getMaximumInspectionDepth() {
        return this.mPipeline.getMaximumInspectionDepth();
    }

    public void setMaximumInspectionDepth(int n) {
        this.mPipeline.setMaximumInspectionDepth(n);
        this.invalidateWidgets();
    }

    public List<AbstractComponent> fetchExistingUnusedComponents() {
        return this.mExistingUnusedComponents;
    }

    public int getComponentCount() {
        this.buildWidgets();
        return super.getComponentCount();
    }

    public Iterator<Component> getComponentIterator() {
        this.buildWidgets();
        return super.getComponentIterator();
    }

    public <T extends Component> T getComponent(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        VaadinMetawidget vaadinMetawidget = this;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (vaadinMetawidget instanceof VaadinMetawidget) {
                vaadinMetawidget.buildWidgets();
            }
            vaadinMetawidget = vaadinMetawidget instanceof ComponentContainer ? this.getComponent((ComponentContainer)vaadinMetawidget, string) : null;
            if (i == n - 1) {
                return (T)((Object)vaadinMetawidget);
            }
            if (vaadinMetawidget != null) continue;
            throw MetawidgetException.newException("No such component '" + string + "' of '" + ArrayUtils.toString(stringArray, "', '") + "'");
        }
        return (T)((Object)vaadinMetawidget);
    }

    public Facet getFacet(String string) {
        this.buildWidgets();
        return this.mFacets.get(string);
    }

    public <C extends Component> C getContent() {
        this.buildWidgets();
        return (C)this.getCompositionRoot();
    }

    public void addComponent(Component component) {
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
            AbstractComponent abstractComponent = (AbstractComponent)component;
            if (component instanceof Facet) {
                this.mFacets.put(abstractComponent.getData(), (Facet)component);
                return;
            }
            this.mExistingComponents.add(abstractComponent);
        } else {
            this.setCompositionRoot(component);
        }
    }

    public void removeComponent(Component component) {
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
            if (component instanceof Facet) {
                this.mFacets.remove(((Facet)component).getData());
            } else {
                this.mExistingComponents.remove(component);
            }
        }
    }

    public void paintContent(PaintTarget paintTarget) throws PaintException {
        this.buildWidgets();
        super.paintContent(paintTarget);
    }

    public void putClientProperty(Object object, Object object2) {
        if (this.mClientProperties == null) {
            this.mClientProperties = new HashMap<Object, Object>();
        }
        this.mClientProperties.put(object, object2);
    }

    public <T> T getClientProperty(Object object) {
        if (this.mClientProperties == null) {
            return null;
        }
        return (T)this.mClientProperties.get(object);
    }

    protected Pipeline newPipeline() {
        return new Pipeline();
    }

    protected String getDefaultConfiguration() {
        return ClassUtils.getPackagesAsFolderNames(VaadinMetawidget.class) + "/metawidget-vaadin-default.xml";
    }

    protected void invalidateInspection() {
        this.mLastInspection = null;
        this.invalidateWidgets();
    }

    protected void invalidateWidgets() {
        if (this.mNeedToBuildWidgets) {
            return;
        }
        this.mNeedToBuildWidgets = true;
        if (this.mClientProperties != null) {
            this.mClientProperties.clear();
        }
        this.requestRepaint();
    }

    protected void buildWidgets() {
        if (!this.mNeedToBuildWidgets) {
            return;
        }
        this.mPipeline.configureOnce();
        this.mNeedToBuildWidgets = false;
        this.mIgnoreAddRemove = true;
        try {
            if (this.mLastInspection == null) {
                this.mLastInspection = this.inspect();
            }
            if (this.mPath != null) {
                this.mPipeline.buildWidgets(this.mLastInspection);
            }
        }
        catch (Exception exception) {
            throw MetawidgetException.newException(exception);
        }
        finally {
            this.mIgnoreAddRemove = false;
        }
    }

    protected void startBuild() {
        this.mExistingUnusedComponents = CollectionUtils.newArrayList(this.mExistingComponents);
    }

    protected void layoutWidget(Component component, String string, Map<String, String> map) {
        ((AbstractComponent)component).setData((Object)map.get("name"));
        this.removeComponent(component);
        Map<String, String> map2 = this.mPipeline.getAdditionalAttributes(component);
        if (map2 != null) {
            map.putAll(map2);
        }
    }

    protected void endBuild() {
        if (this.mExistingUnusedComponents != null) {
            for (AbstractComponent abstractComponent : this.mExistingUnusedComponents) {
                if (abstractComponent instanceof Facet) continue;
                HashMap<String, String> hashMap = CollectionUtils.newHashMap();
                hashMap.put("section", "");
                this.mPipeline.layoutWidget((Component)abstractComponent, "property", (Map<String, String>)hashMap);
            }
        }
    }

    protected void initNestedMetawidget(VaadinMetawidget vaadinMetawidget, Map<String, String> map) {
        this.mPipeline.initNestedPipeline(vaadinMetawidget.mPipeline, map);
        vaadinMetawidget.setPath(this.mPath + '/' + map.get("name"));
        vaadinMetawidget.setBundle(this.mBundle);
        vaadinMetawidget.setToInspect(this.mToInspect);
    }

    private void updateToInspectWithoutInvalidate(Object object) {
        if (this.mToInspect == null) {
            if (this.mPath == null && object != null) {
                this.mPath = object.getClass().getName();
            }
        } else if (this.mToInspect.getClass().getName().equals(this.mPath)) {
            this.mPath = object == null ? null : object.getClass().getName();
        }
        this.mToInspect = object;
    }

    private Element inspect() {
        if (this.mPath == null) {
            return null;
        }
        PathUtils.TypeAndNames typeAndNames = PathUtils.parsePath(this.mPath);
        return (Element)this.mPipeline.inspectAsDom(this.mToInspect, typeAndNames.getType(), typeAndNames.getNamesAsArray());
    }

    private Component getComponent(ComponentContainer componentContainer, String string) {
        Iterator iterator = componentContainer.getComponentIterator();
        while (iterator.hasNext()) {
            AbstractComponent abstractComponent = (AbstractComponent)iterator.next();
            if (!(abstractComponent.getData() == null && abstractComponent instanceof ComponentContainer ? (abstractComponent = (AbstractComponent)this.getComponent((ComponentContainer)abstractComponent, string)) != null : string.equals(abstractComponent.getData()))) continue;
            return abstractComponent;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Pipeline
    extends W3CPipeline<Component, ComponentContainer, VaadinMetawidget>
    implements Serializable {
        protected Pipeline() {
        }

        @Override
        protected VaadinMetawidget getPipelineOwner() {
            return VaadinMetawidget.this;
        }

        @Override
        protected String getDefaultConfiguration() {
            return VaadinMetawidget.this.getDefaultConfiguration();
        }

        @Override
        protected void startBuild() {
            VaadinMetawidget.this.startBuild();
            super.startBuild();
        }

        @Override
        protected void layoutWidget(Component component, String string, Map<String, String> map) {
            VaadinMetawidget.this.layoutWidget(component, string, map);
            super.layoutWidget(component, string, map);
        }

        @Override
        protected Map<String, String> getAdditionalAttributes(Component component) {
            if (component instanceof Stub) {
                return ((Stub)component).getAttributes();
            }
            return null;
        }

        @Override
        public VaadinMetawidget buildNestedMetawidget(Map<String, String> map) throws Exception {
            if ("true".equals(map.get("hidden"))) {
                return null;
            }
            VaadinMetawidget vaadinMetawidget = (VaadinMetawidget)((Object)((Object)((Object)VaadinMetawidget.this)).getClass().newInstance());
            VaadinMetawidget.this.initNestedMetawidget(vaadinMetawidget, map);
            return vaadinMetawidget;
        }

        @Override
        protected void endBuild() {
            VaadinMetawidget.this.endBuild();
            super.endBuild();
        }
    }
}

