/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.vaadin.ui.widgetbuilder;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextArea;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.vaadin.ui.VaadinMetawidget;
import org.metawidget.vaadin.ui.widgetbuilder.LookupLabel;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyWidgetBuilder
implements WidgetBuilder<Component, VaadinMetawidget> {
    @Override
    public Component buildWidget(String string, Map<String, String> map, VaadinMetawidget vaadinMetawidget) {
        if (!WidgetBuilderUtils.isReadOnly(map)) {
            return null;
        }
        if ("true".equals(map.get("hidden"))) {
            return null;
        }
        if ("action".equals(string)) {
            Button button = new Button(vaadinMetawidget.getLabelString(map));
            button.setEnabled(false);
            return button;
        }
        if ("true".equals(map.get("masked"))) {
            return new Panel();
        }
        String string2 = map.get("lookup");
        if (string2 != null && !"".equals(string2)) {
            String string3 = map.get("lookup-labels");
            if (string3 != null && !"".equals(string3)) {
                return new LookupLabel(CollectionUtils.newHashMap(CollectionUtils.fromString(string2), CollectionUtils.fromString(string3)));
            }
            return new Label();
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(map, String.class);
        if (clazz != null) {
            if (clazz.isPrimitive()) {
                return new Label();
            }
            if (String.class.equals(clazz)) {
                if ("true".equals(map.get("large"))) {
                    TextArea textArea = new TextArea();
                    textArea.setReadOnly(true);
                    return textArea;
                }
                return new Label();
            }
            if (Character.class.equals(clazz)) {
                return new Label();
            }
            if (Date.class.equals(clazz)) {
                return new Label();
            }
            if (Boolean.class.equals(clazz)) {
                return new Label();
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return new Label();
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return null;
            }
        }
        if ("true".equals(map.get("dont-expand"))) {
            return new Label();
        }
        return null;
    }
}

