/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.vaadin.ui.widgetbuilder;

import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.PopupDateField;
import com.vaadin.ui.Select;
import com.vaadin.ui.Slider;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.TextField;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.vaadin.ui.Stub;
import org.metawidget.vaadin.ui.VaadinMetawidget;
import org.metawidget.vaadin.ui.widgetprocessor.binding.BindingConverter;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetbuilder.iface.WidgetBuilderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VaadinWidgetBuilder
implements WidgetBuilder<Component, VaadinMetawidget> {
    @Override
    public Component buildWidget(String string, Map<String, String> map, VaadinMetawidget vaadinMetawidget) {
        if ("true".equals(map.get("hidden"))) {
            return new Stub();
        }
        if ("action".equals(string)) {
            return new Button();
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(map, String.class);
        if (Boolean.class.equals(clazz) && "true".equals(map.get("required"))) {
            return new CheckBox();
        }
        String string2 = map.get("lookup");
        if (string2 != null && !"".equals(string2)) {
            return this.createSelectComponent(map, string2, vaadinMetawidget);
        }
        if (clazz != null) {
            if (clazz.isPrimitive()) {
                if (Boolean.TYPE.equals(clazz)) {
                    return new CheckBox();
                }
                if (Character.TYPE.equals(clazz)) {
                    TextField textField = new TextField();
                    textField.setMaxLength(1);
                    return textField;
                }
                String string3 = map.get("minimum-value");
                String string4 = map.get("maximum-value");
                if (string3 != null && !"".equals(string3) && string4 != null && !"".equals(string4)) {
                    Slider slider = new Slider();
                    slider.setMin(Double.parseDouble(string3));
                    try {
                        slider.setValue(slider.getMin());
                    }
                    catch (Slider.ValueOutOfBoundsException valueOutOfBoundsException) {
                        throw WidgetBuilderException.newException(valueOutOfBoundsException);
                    }
                    slider.setMax(Double.parseDouble(string4));
                    return slider;
                }
                return this.createTextField(map);
            }
            if (String.class.equals(clazz)) {
                if ("true".equals(map.get("masked"))) {
                    return new PasswordField();
                }
                if ("true".equals(map.get("large"))) {
                    return new TextArea();
                }
                return this.createTextField(map);
            }
            if (Character.class.isAssignableFrom(clazz)) {
                TextField textField = new TextField();
                textField.setMaxLength(1);
                return textField;
            }
            if (Date.class.equals(clazz)) {
                return new PopupDateField();
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return this.createTextField(map);
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new Stub();
            }
        }
        if ("true".equals(map.get("dont-expand"))) {
            return this.createTextField(map);
        }
        return null;
    }

    private TextField createTextField(Map<String, String> map) {
        TextField textField = new TextField();
        String string = map.get("maximum-length");
        if (string != null && !"".equals(string)) {
            textField.setMaxLength(Integer.parseInt(map.get("maximum-length")));
        }
        return textField;
    }

    private Component createSelectComponent(Map<String, String> map, String string, VaadinMetawidget vaadinMetawidget) {
        String string2;
        Select select = new Select();
        if (!WidgetBuilderUtils.needsEmptyLookupItem(map)) {
            select.setNullSelectionAllowed(false);
        }
        List<String> list = CollectionUtils.fromString(string);
        Map<String, String> map2 = null;
        String string3 = map.get("lookup-labels");
        if (string3 != null && !"".equals(string3)) {
            map2 = CollectionUtils.newHashMap(list, CollectionUtils.fromString(map.get("lookup-labels")));
        }
        Class<?> clazz = (string2 = map.get("type")) != null ? ClassUtils.niceForName(string2) : null;
        BindingConverter bindingConverter = vaadinMetawidget.getWidgetProcessor(BindingConverter.class);
        for (String string4 : list) {
            Object object = string4;
            if (bindingConverter != null && clazz != null) {
                object = bindingConverter.convertFromString(string4, clazz);
            }
            select.addItem(object);
            if (map2 == null) continue;
            select.setItemCaption(object, map2.get(string4));
        }
        if (!WidgetBuilderUtils.needsEmptyLookupItem(map)) {
            select.setRequired(true);
        }
        return select;
    }
}

