/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.vaadin.ui.widgetprocessor;

import com.vaadin.data.Validator;
import com.vaadin.data.validator.AbstractValidator;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Component;
import java.util.Map;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.vaadin.ui.VaadinMetawidget;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimumMaximumValidatorProcessor
implements WidgetProcessor<Component, VaadinMetawidget> {
    @Override
    public Component processWidget(Component component, String string, Map<String, String> map, VaadinMetawidget vaadinMetawidget) {
        if (!(component instanceof AbstractField)) {
            return component;
        }
        String string2 = map.get("minimum-value");
        String string3 = map.get("maximum-value");
        if ((string2 == null || "".equals(string2)) && (string3 == null || "".equals(string3))) {
            return component;
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(map, null);
        if (clazz == null) {
            return component;
        }
        if (!clazz.isPrimitive() && !Number.class.isAssignableFrom(clazz)) {
            return component;
        }
        if (Character.TYPE.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            return component;
        }
        ((AbstractField)component).addValidator((Validator)new MinimumMaximumValidator(clazz, string2, string3));
        return component;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MinimumMaximumValidator
    extends AbstractValidator {
        private Class<?> mNumberType;
        private Object mMinimum;
        private Object mMaximum;

        public MinimumMaximumValidator(Class<?> clazz, String string, String string2) {
            super("");
            this.mNumberType = clazz;
            this.mMinimum = ClassUtils.parseNumber(clazz, string);
            this.mMaximum = ClassUtils.parseNumber(clazz, string2);
            if (this.mMinimum == null) {
                this.setErrorMessage("Must be less than " + this.mMaximum);
            } else if (this.mMaximum == null) {
                this.setErrorMessage("Must be greater than " + this.mMinimum);
            } else {
                this.setErrorMessage("Must be between " + this.mMinimum + " and " + this.mMaximum);
            }
        }

        public boolean isValid(Object object) {
            if (object == null) {
                return !this.mNumberType.isPrimitive();
            }
            if (Byte.TYPE.equals(this.mNumberType) || Byte.class.equals(this.mNumberType)) {
                if (this.mMinimum != null && (Byte)object < (Byte)this.mMinimum) {
                    return false;
                }
                if (this.mMaximum != null && (Byte)object > (Byte)this.mMaximum) {
                    return false;
                }
            } else if (Short.TYPE.equals(this.mNumberType) || Short.class.equals(this.mNumberType)) {
                if (this.mMinimum != null && (Short)object < (Short)this.mMinimum) {
                    return false;
                }
                if (this.mMaximum != null && (Short)object > (Short)this.mMaximum) {
                    return false;
                }
            } else if (Integer.TYPE.equals(this.mNumberType) || Integer.class.equals(this.mNumberType)) {
                if (this.mMinimum != null && ((Number)object).intValue() < (Integer)this.mMinimum) {
                    return false;
                }
                if (this.mMaximum != null && ((Number)object).intValue() > (Integer)this.mMaximum) {
                    return false;
                }
            } else if (Long.TYPE.equals(this.mNumberType) || Long.class.equals(this.mNumberType)) {
                if (this.mMinimum != null && (Long)object < (Long)this.mMinimum) {
                    return false;
                }
                if (this.mMaximum != null && (Long)object > (Long)this.mMaximum) {
                    return false;
                }
            } else if (Float.TYPE.equals(this.mNumberType) || Float.class.equals(this.mNumberType)) {
                if (this.mMinimum != null && ((Float)object).floatValue() < ((Float)this.mMinimum).floatValue()) {
                    return false;
                }
                if (this.mMaximum != null && ((Float)object).floatValue() > ((Float)this.mMaximum).floatValue()) {
                    return false;
                }
            } else if (Double.TYPE.equals(this.mNumberType) || Double.class.equals(this.mNumberType)) {
                if (this.mMinimum != null && (Double)object < (Double)this.mMinimum) {
                    return false;
                }
                if (this.mMaximum != null && (Double)object > (Double)this.mMaximum) {
                    return false;
                }
            } else {
                throw WidgetProcessorException.newException(this.mNumberType + " cannot be validated within min/max");
            }
            return true;
        }
    }
}

